/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.IOException;
import java.io.Reader;
import org.apache.derby.iapi.services.io.Limit;

public final class LimitReader
extends Reader
implements Limit {
    private int remainingCharacters;
    private boolean limitInPlace;
    private Reader reader;

    public LimitReader(Reader reader) {
        this.reader = reader;
        this.clearLimit();
    }

    @Override
    public int read() throws IOException {
        if (!this.limitInPlace) {
            return this.reader.read();
        }
        if (this.remainingCharacters == 0) {
            return -1;
        }
        int n2 = this.reader.read();
        if (n2 >= 0) {
            --this.remainingCharacters;
        }
        return n2;
    }

    @Override
    public int read(char[] cArray, int n2, int n3) throws IOException {
        if (!this.limitInPlace) {
            return this.reader.read(cArray, n2, n3);
        }
        if (this.remainingCharacters == 0) {
            return -1;
        }
        if (this.remainingCharacters < n3) {
            n3 = this.remainingCharacters;
        }
        if ((n3 = this.reader.read(cArray, n2, n3)) >= 0) {
            this.remainingCharacters -= n3;
        }
        return n3;
    }

    @Override
    public long skip(long l2) throws IOException {
        if (!this.limitInPlace) {
            return this.reader.skip(l2);
        }
        if (this.remainingCharacters == 0) {
            return 0L;
        }
        if ((long)this.remainingCharacters < l2) {
            l2 = this.remainingCharacters;
        }
        l2 = this.reader.skip(l2);
        this.remainingCharacters = (int)((long)this.remainingCharacters - l2);
        return l2;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public void setLimit(int n2) {
        this.remainingCharacters = n2;
        this.limitInPlace = true;
    }

    public final int getLimit() {
        return this.remainingCharacters;
    }

    @Override
    public int clearLimit() {
        int n2 = this.remainingCharacters;
        this.limitInPlace = false;
        this.remainingCharacters = -1;
        return n2;
    }
}

