/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import java.sql.Timestamp;
import java.util.Arrays;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.types.DataTypeUtilities;

public final class UserDescriptor
extends TupleDescriptor {
    private String _userName;
    private String _hashingScheme;
    private char[] _password;
    private Timestamp _lastModified;

    UserDescriptor(DataDictionary dataDictionary, String string, String string2, char[] cArray, Timestamp timestamp) {
        super(dataDictionary);
        this._userName = string;
        this._hashingScheme = string2;
        if (cArray == null) {
            this._password = null;
        } else {
            this._password = new char[cArray.length];
            System.arraycopy(cArray, 0, this._password, 0, cArray.length);
        }
        this._lastModified = DataTypeUtilities.clone(timestamp);
    }

    public String getUserName() {
        return this._userName;
    }

    public String getHashingScheme() {
        return this._hashingScheme;
    }

    public Timestamp getLastModified() {
        return DataTypeUtilities.clone(this._lastModified);
    }

    public char[] getAndZeroPassword() {
        int n2 = this._password.length;
        char[] cArray = new char[n2];
        System.arraycopy(this._password, 0, cArray, 0, n2);
        Arrays.fill(this._password, '\u0000');
        return cArray;
    }

    @Override
    public String getDescriptorType() {
        return "User";
    }

    @Override
    public String getDescriptorName() {
        return this._userName;
    }
}

