/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.execute;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.ArrayUtil;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;

public class ExecRowBuilder
implements Formatable {
    private boolean indexable;
    private Object[] template;
    private int[] columns;
    private int count;
    private int maxColumnNumber;

    public ExecRowBuilder(int n2, boolean bl) {
        this.template = new Object[n2];
        this.columns = new int[n2];
        this.indexable = bl;
    }

    public ExecRowBuilder() {
    }

    public void setColumn(int n2, Object object) {
        this.template[this.count] = object;
        this.columns[this.count] = n2;
        ++this.count;
        this.maxColumnNumber = Math.max(this.maxColumnNumber, n2);
    }

    public ExecRow build(ExecutionFactory executionFactory) throws StandardException {
        ExecRow execRow = this.indexable ? executionFactory.getIndexableRow(this.maxColumnNumber) : executionFactory.getValueRow(this.maxColumnNumber);
        for (int i2 = 0; i2 < this.count; ++i2) {
            Object object = this.template[i2];
            DataValueDescriptor dataValueDescriptor = object instanceof DataValueDescriptor ? ((DataValueDescriptor)object).getNewNull() : ((DataTypeDescriptor)object).getNull();
            execRow.setColumn(this.columns[i2], dataValueDescriptor);
        }
        return execRow;
    }

    public void reset(ExecRow execRow) throws StandardException {
        for (int i2 = 0; i2 < this.count; ++i2) {
            int n2 = this.columns[i2];
            execRow.setColumn(n2, execRow.getColumn(n2).getNewNull());
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeBoolean(this.indexable);
        ArrayUtil.writeArray(objectOutput, this.template);
        objectOutput.writeObject(this.columns);
        objectOutput.writeInt(this.count);
        objectOutput.writeInt(this.maxColumnNumber);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.indexable = objectInput.readBoolean();
        this.template = ArrayUtil.readObjectArray(objectInput);
        this.columns = (int[])objectInput.readObject();
        this.count = objectInput.readInt();
        this.maxColumnNumber = objectInput.readInt();
    }

    @Override
    public int getTypeFormatId() {
        return 279;
    }
}

