/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.store.raw;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Hashtable;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.locks.Latch;
import org.apache.derby.iapi.services.locks.Lockable;
import org.apache.derby.iapi.store.raw.ContainerLock;
import org.apache.derby.iapi.store.raw.PageKey;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.util.Matchable;

public final class ContainerKey
implements Matchable,
Lockable {
    private final long segmentId;
    private final long containerId;

    public ContainerKey(long l2, long l3) {
        this.segmentId = l2;
        this.containerId = l3;
    }

    public long getContainerId() {
        return this.containerId;
    }

    public long getSegmentId() {
        return this.segmentId;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        CompressedNumber.writeLong(objectOutput, this.segmentId);
        CompressedNumber.writeLong(objectOutput, this.containerId);
    }

    public static ContainerKey read(ObjectInput objectInput) throws IOException {
        long l2 = CompressedNumber.readLong(objectInput);
        long l3 = CompressedNumber.readLong(objectInput);
        return new ContainerKey(l2, l3);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ContainerKey) {
            ContainerKey containerKey = (ContainerKey)object;
            return this.containerId == containerKey.containerId && this.segmentId == containerKey.segmentId;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.segmentId ^ this.containerId);
    }

    public String toString() {
        return "Container(" + this.segmentId + ", " + this.containerId + ")";
    }

    @Override
    public boolean match(Object object) {
        if (this.equals(object)) {
            return true;
        }
        if (object instanceof PageKey) {
            return this.equals(((PageKey)object).getContainerId());
        }
        if (object instanceof RecordHandle) {
            return this.equals(((RecordHandle)object).getContainerId());
        }
        return false;
    }

    @Override
    public void lockEvent(Latch latch) {
    }

    @Override
    public boolean requestCompatible(Object object, Object object2) {
        ContainerLock containerLock = (ContainerLock)object;
        ContainerLock containerLock2 = (ContainerLock)object2;
        return containerLock.isCompatible(containerLock2);
    }

    @Override
    public boolean lockerAlwaysCompatible() {
        return true;
    }

    @Override
    public void unlockEvent(Latch latch) {
    }

    @Override
    public boolean lockAttributes(int n2, Hashtable<String, Object> hashtable) {
        if ((n2 & 2) == 0) {
            return false;
        }
        hashtable.put("CONTAINERID", this.getContainerId());
        hashtable.put("LOCKNAME", "Tablelock");
        hashtable.put("TYPE", "TABLE");
        return true;
    }
}

