/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io.vfmem;

import org.apache.derby.impl.io.vfmem.BlockedByteArrayInputStream;
import org.apache.derby.impl.io.vfmem.BlockedByteArrayOutputStream;

public class BlockedByteArray {
    private static final int _4K = 4096;
    private static final int _8K = 8192;
    private static final int _16K = 16384;
    private static final int _32K = 32768;
    private static final int DEFAULT_BLOCKSIZE = 4096;
    private static final int INITIAL_BLOCK_HOLDER_SIZE = 1024;
    private static final int MIN_HOLDER_GROWTH = 1024;
    private byte[][] blocks = new byte[1024][];
    private int blockSize;
    private int allocatedBlocks;
    private long length;

    public synchronized int read(long l2) {
        if (l2 < this.length) {
            int n2 = (int)(l2 / (long)this.blockSize);
            int n3 = (int)(l2 % (long)this.blockSize);
            return this.blocks[n2][n3] & 0xFF;
        }
        return -1;
    }

    public synchronized int read(long l2, byte[] byArray, int n2, int n3) {
        if (n3 < 0) {
            throw new ArrayIndexOutOfBoundsException(n3);
        }
        if (l2 >= this.length) {
            return -1;
        }
        n3 = (int)Math.min((long)n3, this.length - l2);
        int n4 = (int)(l2 / (long)this.blockSize);
        int n5 = (int)(l2 % (long)this.blockSize);
        int n6 = 0;
        while (n6 < n3) {
            int n7 = Math.min(n3 - n6, this.blockSize - n5);
            System.arraycopy(this.blocks[n4], n5, byArray, n2 + n6, n7);
            n6 += n7;
            ++n4;
            n5 = 0;
        }
        return n6;
    }

    public synchronized long length() {
        return this.length;
    }

    public synchronized void setLength(long l2) {
        long l3;
        if (this.blockSize == 0) {
            this.checkBlockSize((int)Math.min(Integer.MAX_VALUE, l2));
        }
        if (l2 > (l3 = (long)this.allocatedBlocks * (long)this.blockSize)) {
            this.increaseCapacity(l2);
        } else if (l2 < l3) {
            if (l2 <= 0L) {
                this.allocatedBlocks = 0;
                this.blocks = new byte[1024][];
            } else {
                int n2;
                for (int i2 = n2 = (int)(l2 / (long)this.blockSize) + 1; i2 <= this.allocatedBlocks; ++i2) {
                    this.blocks[i2] = null;
                }
                this.allocatedBlocks = Math.min(this.allocatedBlocks, n2);
            }
        }
        this.length = Math.max(0L, l2);
    }

    public synchronized int writeBytes(long l2, byte[] byArray, int n2, int n3) {
        if (this.blockSize == 0) {
            this.checkBlockSize(n3);
        }
        if (n3 < 0) {
            throw new ArrayIndexOutOfBoundsException(n3);
        }
        this.increaseCapacity(l2 + (long)n3);
        int n4 = (int)(l2 / (long)this.blockSize);
        int n5 = (int)(l2 % (long)this.blockSize);
        int n6 = 0;
        while (n6 < n3) {
            int n7 = Math.min(n3 - n6, this.blockSize - n5);
            System.arraycopy(byArray, n2, this.blocks[n4], n5, n7);
            n2 += n7;
            if ((n6 += n7) < n3) {
                ++n4;
                n5 = 0;
                continue;
            }
            n5 += n7;
        }
        this.length = Math.max(this.length, l2 + (long)n3);
        return n6;
    }

    public synchronized int writeByte(long l2, byte by) {
        if (this.blockSize == 0) {
            this.checkBlockSize(0);
        }
        this.increaseCapacity(l2);
        int n2 = (int)(l2 / (long)this.blockSize);
        int n3 = (int)(l2 % (long)this.blockSize);
        this.blocks[n2][n3] = by;
        this.length = Math.max(this.length, l2 + 1L);
        return 1;
    }

    synchronized BlockedByteArrayInputStream getInputStream() {
        return new BlockedByteArrayInputStream(this, 0L);
    }

    synchronized BlockedByteArrayOutputStream getOutputStream(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Position cannot be negative: " + l2);
        }
        return new BlockedByteArrayOutputStream(this, l2);
    }

    synchronized void release() {
        this.blocks = null;
        this.allocatedBlocks = -1;
        this.length = -1;
    }

    private void checkBlockSize(int n2) {
        this.blockSize = n2 == 4096 || n2 == 8192 || n2 == 16384 || n2 == 32768 ? n2 : 4096;
    }

    private void increaseCapacity(long l2) {
        int n2;
        if (l2 < (long)this.allocatedBlocks * (long)this.blockSize) {
            return;
        }
        int n3 = (int)(l2 / (long)this.blockSize) + 1;
        if (n3 > this.blocks.length) {
            n2 = Math.max(this.blocks.length + this.blocks.length / 3, n3 + 1024);
            byte[][] byArray = this.blocks;
            this.blocks = new byte[n2][];
            System.arraycopy(byArray, 0, this.blocks, 0, this.allocatedBlocks);
        }
        for (n2 = this.allocatedBlocks; n2 < n3; ++n2) {
            this.blocks[n2] = new byte[this.blockSize];
        }
        this.allocatedBlocks = n3;
    }
}

