/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io.vfmem;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.derby.impl.io.vfmem.DataStoreEntry;
import org.apache.derby.impl.io.vfmem.PathUtil;
import org.apache.derby.io.StorageFile;

public final class DataStore {
    private static final char SEP = PathUtil.SEP;
    private static final String[] EMPTY_STR_ARR = new String[0];
    private final Object LOCK = new Object();
    private final Object TMP_COUNTER_LOCK = new Object();
    private final Map<String, DataStoreEntry> files = new HashMap<String, DataStoreEntry>(80);
    private final String databaseName;
    private long tmpFileCounter = 0L;
    private boolean deleteMe;

    public DataStore(String string) {
        this.databaseName = string;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public boolean scheduledForDeletion() {
        return this.deleteMe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataStoreEntry createEntry(String string, boolean bl) {
        String string2 = new File(string).getPath();
        Object object = this.LOCK;
        synchronized (object) {
            if (this.files.containsKey(string2)) {
                return null;
            }
            String[] stringArray = this.getParentList(string2);
            for (int i2 = stringArray.length - 1; i2 >= 0; --i2) {
                DataStoreEntry dataStoreEntry = this.files.get(stringArray[i2]);
                if (dataStoreEntry == null) {
                    return null;
                }
                if (dataStoreEntry.isDirectory()) continue;
                return null;
            }
            DataStoreEntry dataStoreEntry = new DataStoreEntry(string2, bl);
            this.files.put(string2, dataStoreEntry);
            return dataStoreEntry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createAllParents(String string) {
        String string2 = new File(string).getPath();
        String[] stringArray = this.getParentList(string2);
        Object object = this.LOCK;
        synchronized (object) {
            for (int i2 = stringArray.length - 1; i2 >= 0; --i2) {
                String string3 = stringArray[i2];
                DataStoreEntry dataStoreEntry = this.files.get(string3);
                if (dataStoreEntry == null) {
                    this.createEntry(string3, true);
                    continue;
                }
                if (dataStoreEntry.isDirectory()) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteEntry(String string) {
        DataStoreEntry dataStoreEntry;
        String string2 = new File(string).getPath();
        Object object = this.LOCK;
        synchronized (object) {
            dataStoreEntry = this.files.remove(string2);
            if (dataStoreEntry != null) {
                if (dataStoreEntry.isDirectory()) {
                    String[] stringArray = this.listChildren(string2);
                    if (stringArray.length > 0) {
                        this.files.put(string2, dataStoreEntry);
                        return false;
                    }
                    if (string2.equals(this.databaseName) && this.files.get(this.databaseName) == null) {
                        this.deleteMe = true;
                    }
                }
                dataStoreEntry.release();
            }
        }
        return dataStoreEntry != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataStoreEntry getEntry(String string) {
        Object object = this.LOCK;
        synchronized (object) {
            return this.files.get(new File(string).getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteAll(String string) {
        String string2 = new File(string).getPath();
        Object object = this.LOCK;
        synchronized (object) {
            DataStoreEntry dataStoreEntry = this.files.remove(string2);
            if (dataStoreEntry == null) {
                return false;
            }
            if (dataStoreEntry.isDirectory()) {
                boolean bl = this._deleteAll(string2);
                if (this.files.get(this.databaseName) == null) {
                    this.deleteMe = true;
                }
                return bl;
            }
            dataStoreEntry.release();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listChildren(String string) {
        if (string.equals("")) {
            throw new IllegalArgumentException("The empty string is not a valid path");
        }
        String string2 = new File(string).getPath();
        if (string2.charAt(string2.length() - 1) != SEP) {
            string2 = string2 + SEP;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Object object = this.LOCK;
        synchronized (object) {
            for (String string3 : this.files.keySet()) {
                if (!string3.startsWith(string2) || (string3 = string3.substring(string2.length())).indexOf(PathUtil.SEP_STR) >= 0) continue;
                arrayList.add(string3);
            }
        }
        return arrayList.toArray(EMPTY_STR_ARR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean move(StorageFile storageFile, StorageFile storageFile2) {
        String string = new File(storageFile.getPath()).getPath();
        String string2 = new File(storageFile2.getPath()).getPath();
        Object object = this.LOCK;
        synchronized (object) {
            if (this.files.containsKey(string2)) {
                return false;
            }
            DataStoreEntry dataStoreEntry = this.files.remove(string);
            if (dataStoreEntry == null) {
                return false;
            }
            this.files.put(string2, dataStoreEntry);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge() {
        Object object = this.LOCK;
        synchronized (object) {
            Iterator<DataStoreEntry> iterator = this.files.values().iterator();
            while (iterator.hasNext()) {
                iterator.next().release();
            }
            this.files.clear();
        }
    }

    private boolean _deleteAll(String string) {
        if (string.charAt(string.length() - 1) != SEP) {
            string = string + SEP;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String object2 : this.files.keySet()) {
            if (!object2.startsWith(string)) continue;
            arrayList.add(object2);
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            DataStoreEntry dataStoreEntry = this.files.remove((String)iterator.next());
            dataStoreEntry.release();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTempFileCounter() {
        Object object = this.TMP_COUNTER_LOCK;
        synchronized (object) {
            return ++this.tmpFileCounter;
        }
    }

    private String[] getParentList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = string;
        while ((string2 = new File(string2).getParent()) != null) {
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

