/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

class BinaryToRawStream
extends FilterInputStream {
    private int length;
    private Object parent;

    BinaryToRawStream(InputStream inputStream, Object object) throws IOException {
        super(inputStream);
        this.parent = object;
        int n2 = inputStream.read();
        if (n2 == -1) {
            throw new EOFException();
        }
        if ((n2 & 0x80) != 0) {
            if (n2 == 192) {
                int n3 = inputStream.read();
                int n4 = inputStream.read();
                int n5 = inputStream.read();
                int n6 = inputStream.read();
                if (n3 == -1 || n4 == -1 || n5 == -1 || n6 == -1) {
                    throw new EOFException();
                }
                this.length = (n3 & 0xFF) << 24 | (n4 & 0xFF) << 16 | (n5 & 0xFF) << 8 | n6 & 0xFF;
            } else if (n2 == 160) {
                int n7 = inputStream.read();
                int n8 = inputStream.read();
                if (n7 == -1 || n8 == -1) {
                    throw new EOFException();
                }
                this.length = ((n7 & 0xFF) << 8) + (n8 & 0xFF);
            } else {
                this.length = n2 & 0x1F;
            }
        } else {
            int n9 = inputStream.read();
            int n10 = inputStream.read();
            int n11 = inputStream.read();
            if (n9 == -1 || n10 == -1 || n11 == -1) {
                throw new EOFException();
            }
            int n12 = (n2 & 0xFF) << 24 | (n9 & 0xFF) << 16 | (n10 & 0xFF) << 8 | n11 & 0xFF;
            this.length = n12 / 8;
            if (n12 % 8 != 0) {
                ++this.length;
            }
            if (this.length == 0) {
                this.length = -1;
            }
        }
    }

    int getLength() {
        return this.length;
    }
}

