/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;
import org.apache.derby.impl.jdbc.EmbedClob;
import org.apache.derby.impl.jdbc.InternalClob;

final class ClobUpdatableReader
extends Reader {
    private Reader streamReader;
    private long pos;
    private long lastUpdateCount = -1L;
    private final EmbedClob clob;
    private InternalClob iClob;
    private final long maxPos;
    private volatile boolean closed = false;

    public ClobUpdatableReader(EmbedClob embedClob) throws IOException, SQLException {
        this(embedClob, 1L, Long.MAX_VALUE);
    }

    public ClobUpdatableReader(EmbedClob embedClob, long l2, long l3) throws IOException, SQLException {
        this.clob = embedClob;
        this.iClob = embedClob.getInternalClob();
        this.pos = l2;
        long l4 = l2 + l3;
        if (l4 < l3 || l4 < l2) {
            l4 = Long.MAX_VALUE;
        }
        this.maxPos = l4;
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("Reader closed");
        }
        if (this.pos >= this.maxPos) {
            return -1;
        }
        this.updateReaderIfRequired();
        int n2 = this.streamReader.read();
        if (n2 > 0) {
            ++this.pos;
        }
        return n2;
    }

    @Override
    public int read(char[] cArray, int n2, int n3) throws IOException {
        if (this.closed) {
            throw new IOException("Reader closed");
        }
        if (this.pos >= this.maxPos) {
            return -1;
        }
        this.updateReaderIfRequired();
        int n4 = (int)Math.min((long)n3, this.maxPos - this.pos);
        int n5 = this.streamReader.read(cArray, n2, n4);
        if (n5 > 0) {
            this.pos += (long)n5;
        }
        return n5;
    }

    @Override
    public long skip(long l2) throws IOException {
        if (this.closed) {
            throw new IOException("Reader closed");
        }
        if (this.pos >= this.maxPos) {
            return 0L;
        }
        this.updateReaderIfRequired();
        long l3 = Math.min(l2, this.maxPos - this.pos);
        long l4 = this.streamReader.skip(l3);
        if (l4 > 0L) {
            this.pos += l4;
        }
        return l4;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            if (this.streamReader != null) {
                this.streamReader.close();
            }
        }
    }

    private void updateReaderIfRequired() throws IOException {
        if (this.iClob.isReleased()) {
            this.iClob = this.clob.getInternalClob();
            this.lastUpdateCount = -1L;
            if (this.iClob.isReleased()) {
                this.close();
                return;
            }
        }
        if (this.lastUpdateCount != this.iClob.getUpdateCount()) {
            this.lastUpdateCount = this.iClob.getUpdateCount();
            try {
                this.streamReader = this.iClob.getReader(this.pos);
            }
            catch (SQLException sQLException) {
                throw new IOException(sQLException.getMessage());
            }
        }
    }
}

