/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.sql.ParameterMetaData;
import java.sql.SQLException;
import org.apache.derby.iapi.sql.ParameterValueSet;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataTypeUtilities;
import org.apache.derby.impl.jdbc.Util;

public class EmbedParameterSetMetaData
implements ParameterMetaData {
    private final ParameterValueSet pvs;
    private final DataTypeDescriptor[] types;
    private final int paramCount;

    protected EmbedParameterSetMetaData(ParameterValueSet parameterValueSet, DataTypeDescriptor[] dataTypeDescriptorArray) {
        int n2 = parameterValueSet.getParameterCount();
        this.pvs = parameterValueSet;
        this.paramCount = n2;
        this.types = dataTypeDescriptorArray;
    }

    @Override
    public int getParameterCount() {
        return this.paramCount;
    }

    @Override
    public int isNullable(int n2) throws SQLException {
        this.checkPosition(n2);
        if (this.types[n2 - 1].isNullable()) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean isSigned(int n2) throws SQLException {
        this.checkPosition(n2);
        return this.types[n2 - 1].getTypeId().isNumericTypeId();
    }

    @Override
    public int getPrecision(int n2) throws SQLException {
        this.checkPosition(n2);
        int n3 = -1;
        if (n2 == 1 && this.pvs.hasReturnOutputParameter()) {
            n3 = this.pvs.getPrecision(n2);
        }
        if (n3 == -1) {
            return DataTypeUtilities.getPrecision(this.types[n2 - 1]);
        }
        return n3;
    }

    @Override
    public int getScale(int n2) throws SQLException {
        this.checkPosition(n2);
        if (n2 == 1 && this.pvs.hasReturnOutputParameter()) {
            return this.pvs.getScale(n2);
        }
        return this.types[n2 - 1].getScale();
    }

    @Override
    public int getParameterType(int n2) throws SQLException {
        this.checkPosition(n2);
        return this.types[n2 - 1].getTypeId().getJDBCTypeId();
    }

    @Override
    public String getParameterTypeName(int n2) throws SQLException {
        this.checkPosition(n2);
        return this.types[n2 - 1].getTypeId().getSQLTypeName();
    }

    @Override
    public String getParameterClassName(int n2) throws SQLException {
        this.checkPosition(n2);
        return this.types[n2 - 1].getTypeId().getResultSetMetaDataTypeName();
    }

    @Override
    public int getParameterMode(int n2) throws SQLException {
        this.checkPosition(n2);
        if (n2 == 1 && this.pvs.hasReturnOutputParameter()) {
            return 4;
        }
        return this.pvs.getParameterMode(n2);
    }

    private void checkPosition(int n2) throws SQLException {
        if (n2 < 1 || n2 > this.paramCount) {
            throw Util.generateCsSQLException("XCL13.S", n2, this.paramCount);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        try {
            return clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            throw Util.generateCsSQLException("XJ128.S", clazz);
        }
    }
}

