/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.derby.iapi.error.ExceptionUtil;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.store.raw.data.DataFactory;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.EncryptedLOBFile;
import org.apache.derby.impl.jdbc.LOBFile;
import org.apache.derby.impl.jdbc.LOBInputStream;
import org.apache.derby.impl.jdbc.LOBOutputStream;
import org.apache.derby.io.StorageFile;

final class LOBStreamControl {
    private LOBFile tmpFile;
    private byte[] dataBytes = new byte[0];
    private boolean isBytes = true;
    private final int bufferSize;
    private final EmbedConnection conn;
    private long updateCount;
    private static final int DEFAULT_BUF_SIZE = 4096;
    private static final int MAX_BUF_SIZE = 32768;

    LOBStreamControl(EmbedConnection embedConnection) {
        this.conn = embedConnection;
        this.updateCount = 0L;
        this.bufferSize = 4096;
    }

    LOBStreamControl(EmbedConnection embedConnection, byte[] byArray) throws IOException, StandardException {
        this.conn = embedConnection;
        this.updateCount = 0L;
        this.bufferSize = Math.min(Math.max(4096, byArray.length), 32768);
        this.write(byArray, 0, byArray.length, 0L);
    }

    private void init(byte[] byArray, long l2) throws IOException, StandardException {
        Object object = LOBStreamControl.findService("org.apache.derby.database.Database", this.conn.getDBName());
        final DataFactory dataFactory = (DataFactory)LOBStreamControl.findServiceModule(object, "org.apache.derby.iapi.store.raw.data.DataFactory");
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws IOException {
                    StorageFile storageFile = dataFactory.getStorageFactory().createTemporaryFile("lob", null);
                    if (dataFactory.databaseEncrypted()) {
                        LOBStreamControl.this.tmpFile = new EncryptedLOBFile(storageFile, dataFactory);
                    } else {
                        LOBStreamControl.this.tmpFile = new LOBFile(storageFile);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getCause();
        }
        this.conn.addLobFile(this.tmpFile);
        this.isBytes = false;
        if (l2 != 0L) {
            this.write(byArray, 0, (int)l2, 0L);
        }
        this.dataBytes = null;
    }

    private long updateData(byte[] byArray, int n2, int n3, long l2) throws StandardException {
        if (this.dataBytes == null) {
            if ((int)l2 == 0) {
                this.dataBytes = new byte[n3];
                System.arraycopy(byArray, n2, this.dataBytes, (int)l2, n3);
                return n3;
            }
            throw StandardException.newException("XJ076.S", l2);
        }
        if (l2 > (long)this.dataBytes.length) {
            throw StandardException.newException("XJ076.S", l2);
        }
        if (l2 + (long)n3 < (long)this.dataBytes.length) {
            System.arraycopy(byArray, n2, this.dataBytes, (int)l2, n3);
        } else {
            byte[] byArray2 = new byte[n3 + (int)l2];
            System.arraycopy(this.dataBytes, 0, byArray2, 0, (int)l2);
            System.arraycopy(byArray, n2, byArray2, (int)l2, n3);
            this.dataBytes = byArray2;
        }
        return l2 + (long)n3;
    }

    private void isValidPostion(long l2) throws IOException, StandardException {
        if (l2 < 0L) {
            throw StandardException.newException("XJ071.S", l2 + 1L);
        }
        if (l2 > Integer.MAX_VALUE) {
            throw StandardException.newException("XJ076.S", l2 + 1L);
        }
        if (this.isBytes ? (this.dataBytes == null ? l2 != 0L : (long)this.dataBytes.length < l2) : l2 > this.tmpFile.length()) {
            throw StandardException.newException("XJ076.S", l2 + 1L);
        }
    }

    private void isValidOffset(int n2, int n3) throws StandardException {
        if (n2 < 0 || n2 > n3) {
            throw StandardException.newException("XJ078.S", n2);
        }
    }

    synchronized long write(int n2, long l2) throws IOException, StandardException {
        this.isValidPostion(l2);
        ++this.updateCount;
        if (this.isBytes) {
            if (l2 < (long)this.bufferSize) {
                byte[] byArray = new byte[]{(byte)n2};
                this.updateData(byArray, 0, 1, l2);
                return l2 + 1L;
            }
            this.init(this.dataBytes, l2);
        }
        this.tmpFile.seek(l2);
        this.tmpFile.write(n2);
        return this.tmpFile.getFilePointer();
    }

    synchronized long write(byte[] byArray, int n2, int n3, long l2) throws IOException, StandardException {
        this.isValidPostion(l2);
        try {
            this.isValidOffset(n2, byArray.length);
        }
        catch (StandardException standardException) {
            if (standardException.getSQLState().equals(ExceptionUtil.getSQLStateFromIdentifier("XJ078.S"))) {
                throw new ArrayIndexOutOfBoundsException(standardException.getMessage());
            }
            throw standardException;
        }
        ++this.updateCount;
        if (this.isBytes) {
            if (l2 + (long)n3 <= (long)this.bufferSize) {
                return this.updateData(byArray, n2, n3, l2);
            }
            this.init(this.dataBytes, l2);
        }
        this.tmpFile.seek(l2);
        this.tmpFile.write(byArray, n2, n3);
        return this.tmpFile.getFilePointer();
    }

    synchronized int read(long l2) throws IOException, StandardException {
        this.isValidPostion(l2);
        if (this.isBytes) {
            if ((long)this.dataBytes.length == l2) {
                return -1;
            }
            return this.dataBytes[(int)l2] & 0xFF;
        }
        if (this.tmpFile.getFilePointer() != l2) {
            this.tmpFile.seek(l2);
        }
        try {
            return this.tmpFile.readByte() & 0xFF;
        }
        catch (EOFException eOFException) {
            return -1;
        }
    }

    private int readBytes(byte[] byArray, int n2, int n3, long l2) {
        if (l2 >= (long)this.dataBytes.length) {
            return -1;
        }
        int n4 = this.dataBytes.length - (int)l2;
        int n5 = n3 > n4 ? n4 : n3;
        System.arraycopy(this.dataBytes, (int)l2, byArray, n2, n5);
        return n5;
    }

    synchronized int read(byte[] byArray, int n2, int n3, long l2) throws IOException, StandardException {
        this.isValidPostion(l2);
        this.isValidOffset(n2, byArray.length);
        if (this.isBytes) {
            return this.readBytes(byArray, n2, n3, l2);
        }
        this.tmpFile.seek(l2);
        return this.tmpFile.read(byArray, n2, n3);
    }

    InputStream getInputStream(long l2) {
        return new LOBInputStream(this, l2);
    }

    OutputStream getOutputStream(long l2) {
        return new LOBOutputStream(this, l2);
    }

    long getLength() throws IOException {
        if (this.isBytes) {
            return this.dataBytes.length;
        }
        return this.tmpFile.length();
    }

    synchronized void truncate(long l2) throws IOException, StandardException {
        this.isValidPostion(l2);
        if (this.isBytes) {
            byte[] byArray = new byte[(int)l2];
            System.arraycopy(this.dataBytes, 0, byArray, 0, (int)l2);
            this.dataBytes = byArray;
        } else if (l2 < (long)this.bufferSize) {
            this.dataBytes = new byte[(int)l2];
            this.read(this.dataBytes, 0, this.dataBytes.length, 0L);
            this.isBytes = true;
            this.releaseTempFile(this.tmpFile);
            this.tmpFile = null;
        } else {
            this.tmpFile.setLength(l2);
        }
    }

    synchronized void copyData(InputStream inputStream, long l2) throws IOException, StandardException {
        int n2;
        byte[] byArray = new byte[this.bufferSize];
        for (long i2 = 0L; i2 < l2; i2 += (long)n2) {
            n2 = (int)Math.min(l2 - i2, (long)this.bufferSize);
            if ((n2 = inputStream.read(byArray, 0, n2)) == -1) {
                if (l2 == Long.MAX_VALUE) break;
                throw new EOFException(MessageService.getTextMessage("I029", l2, i2));
            }
            this.write(byArray, 0, n2, i2);
        }
        long l3 = this.getLength();
        if (l2 == Long.MAX_VALUE && l3 > 2L) {
            byte[] byArray2 = new byte[3];
            this.read(byArray2, 0, 3, l3 - 3L);
            if ((byArray2[0] & 0xFF) == 224 && (byArray2[1] & 0xFF) == 0 && (byArray2[2] & 0xFF) == 0) {
                this.truncate(l3 - 3L);
            }
        }
    }

    synchronized long copyUtf8Data(InputStream inputStream, long l2) throws IOException, StandardException {
        int n2;
        long l3 = 0L;
        int n3 = 0;
        int n4 = 0;
        byte[] byArray = new byte[this.bufferSize];
        while (l3 < l2 && (n2 = inputStream.read(byArray, 0, (int)Math.min((long)byArray.length, l2 - l3))) != -1) {
            while (n3 < n2) {
                int n5 = byArray[n3] & 0xFF;
                if ((n5 & 0x80) == 0) {
                    ++n3;
                } else if ((n5 & 0x60) == 64) {
                    n3 += 2;
                } else if ((n5 & 0x70) == 96) {
                    n3 += 3;
                } else {
                    throw new UTFDataFormatException("Invalid UTF-8 encoding: " + Integer.toHexString(n5) + ", charCount=" + l3 + ", offset=" + n3);
                }
                ++l3;
            }
            n3 -= n2;
            this.write(byArray, 0, n2, n4);
            n4 += n2;
        }
        long l4 = this.getLength();
        if (l4 > 2L) {
            byte[] byArray2 = new byte[3];
            this.read(byArray2, 0, 3, l4 - 3L);
            if ((byArray2[0] & 0xFF) == 224 && (byArray2[1] & 0xFF) == 0 && (byArray2[2] & 0xFF) == 0) {
                this.truncate(l4 - 3L);
                --l3;
            }
        }
        if (l2 != Long.MAX_VALUE && l3 != l2) {
            throw new EOFException(MessageService.getTextMessage("I029", l2, l3));
        }
        return l3;
    }

    protected void finalize() throws Throwable {
        this.free();
    }

    private void deleteFile(final StorageFile storageFile) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                storageFile.delete();
                return null;
            }
        });
    }

    void free() throws IOException {
        this.dataBytes = null;
        if (this.tmpFile != null) {
            this.releaseTempFile(this.tmpFile);
            this.tmpFile = null;
        }
    }

    private void releaseTempFile(LOBFile lOBFile) throws IOException {
        this.conn.removeLobFile(lOBFile);
        lOBFile.close();
        this.deleteFile(lOBFile.getStorageFile());
    }

    synchronized long replaceBytes(byte[] byArray, long l2, long l3) throws IOException, StandardException {
        long l4 = this.getLength();
        if (this.isBytes) {
            long l5 = l4 - l3 + l2 + (long)byArray.length;
            if (l5 > (long)this.bufferSize) {
                byte[] byArray2 = this.dataBytes;
                this.init(byArray2, l2);
                this.write(byArray, 0, byArray.length, this.getLength());
                if (l3 < l4) {
                    this.write(byArray2, (int)l3, (int)(l4 - l3), this.getLength());
                }
            } else {
                byte[] byArray3 = new byte[(int)l5];
                System.arraycopy(this.dataBytes, 0, byArray3, 0, (int)l2);
                System.arraycopy(byArray, 0, byArray3, (int)l2, byArray.length);
                if (l3 < l4) {
                    System.arraycopy(this.dataBytes, (int)l3, byArray3, (int)(l2 + (long)byArray.length), (int)(l4 - l3));
                }
                this.dataBytes = byArray3;
            }
        } else {
            int n2;
            int n3;
            byte[] byArray4 = new byte[]{};
            LOBFile lOBFile = this.tmpFile;
            this.init(byArray4, 0L);
            byte[] byArray5 = new byte[1024];
            lOBFile.seek(0L);
            for (long i2 = l2; i2 != 0L && (n3 = lOBFile.read(byArray5, 0, n2 = (int)Math.min(1024L, i2))) != -1; i2 -= (long)n3) {
                this.tmpFile.write(byArray5, 0, n3);
            }
            this.tmpFile.write(byArray);
            lOBFile.seek(l3);
            if (l3 < l4) {
                while ((n2 = lOBFile.read(byArray5, 0, 1024)) != -1) {
                    this.tmpFile.write(byArray5, 0, n2);
                }
            }
            this.releaseTempFile(lOBFile);
        }
        ++this.updateCount;
        return l2 + (long)byArray.length;
    }

    long getUpdateCount() {
        return this.updateCount;
    }

    private static Object findServiceModule(final Object object, final String string) throws StandardException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws StandardException {
                    return Monitor.findServiceModule(object, string);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw StandardException.plainWrapException(privilegedActionException);
        }
    }

    private static Object findService(final String string, final String string2) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return Monitor.findService(string, string2);
            }
        });
    }
}

