/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.load;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.derby.impl.load.ControlInfo;
import org.apache.derby.impl.load.ImportBlob;
import org.apache.derby.impl.load.ImportClob;
import org.apache.derby.impl.load.ImportLobFile;
import org.apache.derby.impl.load.LoadError;

final class ImportReadData
implements PrivilegedExceptionAction<Object> {
    private String inputFileName;
    private short skipLines;
    private int[] columnWidths;
    private int rowWidth;
    private char[] tempString;
    private int numberOfCharsReadSoFar;
    private BufferedReader bufferedReader;
    private static final int START_SIZE = 10240;
    private char[] currentToken = new char[10240];
    private int currentTokenMaxSize = 10240;
    boolean foundStartDelimiter;
    int totalCharsSoFar;
    int positionOfNonWhiteSpaceCharInFront;
    int positionOfNonWhiteSpaceCharInBack;
    int lineNumber;
    int fieldStartDelimiterIndex;
    int fieldStopDelimiterIndex;
    int stopDelimiterPosition;
    boolean foundStartAndStopDelimiters;
    boolean streamOpenForReading;
    static final int DEFAULT_FORMAT_CODE = 0;
    static final int ASCII_FIXED_FORMAT_CODE = 1;
    private int formatCode = 0;
    private boolean hasColumnDefinition;
    private char recordSeparatorChar0;
    private char fieldSeparatorChar0;
    private boolean recordSepStartNotWhite = true;
    private boolean fieldSepStartNotWhite = true;
    protected ControlInfo controlFileReader;
    protected int numberOfColumns;
    protected String[] columnTypes;
    protected char[] fieldSeparator;
    protected int fieldSeparatorLength;
    protected char[] recordSeparator;
    protected int recordSeparatorLength;
    protected String nullString;
    protected String columnDefinition;
    protected String format;
    protected String dataCodeset;
    protected char[] fieldStartDelimiter;
    protected int fieldStartDelimiterLength;
    protected char[] fieldStopDelimiter;
    protected int fieldStopDelimiterLength;
    protected boolean hasDelimiterAtEnd;
    private ImportLobFile[] lobFileHandles;
    private String lobFileName;
    private long lobOffset;
    private int lobLength;
    private boolean haveSep = true;

    private void loadPropertiesInfo() throws Exception {
        this.fieldSeparator = this.controlFileReader.getFieldSeparator().toCharArray();
        this.fieldSeparatorLength = this.fieldSeparator.length;
        this.recordSeparator = this.controlFileReader.getRecordSeparator().toCharArray();
        this.recordSeparatorLength = this.recordSeparator.length;
        this.nullString = this.controlFileReader.getNullString();
        this.columnDefinition = this.controlFileReader.getColumnDefinition();
        this.format = this.controlFileReader.getFormat();
        this.dataCodeset = this.controlFileReader.getDataCodeset();
        this.fieldStartDelimiter = this.controlFileReader.getFieldStartDelimiter().toCharArray();
        this.fieldStartDelimiterLength = this.fieldStartDelimiter.length;
        this.fieldStopDelimiter = this.controlFileReader.getFieldEndDelimiter().toCharArray();
        this.fieldStopDelimiterLength = this.fieldStopDelimiter.length;
        this.hasDelimiterAtEnd = this.controlFileReader.getHasDelimiterAtEnd();
        if (this.recordSeparatorLength > 0) {
            this.recordSeparatorChar0 = this.recordSeparator[0];
            boolean bl = this.recordSepStartNotWhite = !Character.isWhitespace(this.recordSeparatorChar0);
        }
        if (this.fieldSeparatorLength > 0) {
            this.fieldSeparatorChar0 = this.fieldSeparator[0];
            this.fieldSepStartNotWhite = !Character.isWhitespace(this.fieldSeparatorChar0);
        }
    }

    ImportReadData(String string, ControlInfo controlInfo, short s2) throws Exception {
        this.skipLines = s2;
        this.inputFileName = string;
        this.controlFileReader = controlInfo;
        this.loadPropertiesInfo();
        this.loadMetaData();
        this.lobFileHandles = new ImportLobFile[this.numberOfColumns];
    }

    int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    protected void ignoreFirstRow() throws Exception {
        this.readNextToken(this.recordSeparator, 0, this.recordSeparatorLength, true);
    }

    protected void ignoreHeaderLines() throws Exception {
        for (int i2 = 0; i2 < this.skipLines; ++i2) {
            if (!this.readNextToken(this.recordSeparator, 0, this.recordSeparatorLength, true)) {
                throw LoadError.unexpectedEndOfFile(this.lineNumber + 1);
            }
            ++this.lineNumber;
        }
    }

    protected void loadColumnTypes() throws Exception {
        this.findNumberOfColumnsInARow();
        this.closeStream();
        this.openFile();
        String[] stringArray = new String[this.numberOfColumns];
        this.readNextDelimitedRow(stringArray);
        this.columnTypes = new String[this.numberOfColumns / 2];
        for (int i2 = 0; i2 < this.numberOfColumns; i2 += 2) {
            this.columnTypes[i2 / 2] = stringArray[i2 + 1];
        }
        this.closeStream();
        this.openFile();
        this.numberOfColumns = 0;
    }

    private void openFile() throws Exception {
        try {
            AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw privilegedActionException.getException();
        }
    }

    @Override
    public final Object run() throws Exception {
        this.realOpenFile();
        return null;
    }

    private void realOpenFile() throws Exception {
        InputStream inputStream;
        Object object;
        try {
            try {
                object = new URL(this.inputFileName);
                if (((URL)object).getProtocol().equals("file")) {
                    this.inputFileName = ((URL)object).getFile();
                    throw new MalformedURLException();
                }
                inputStream = ((URL)object).openStream();
            }
            catch (MalformedURLException malformedURLException) {
                inputStream = new FileInputStream(this.inputFileName);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw LoadError.dataFileNotFound(this.inputFileName, fileNotFoundException);
        }
        catch (SecurityException securityException) {
            throw LoadError.dataFileNotFound(this.inputFileName, securityException);
        }
        object = this.dataCodeset == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, this.dataCodeset);
        this.bufferedReader = new BufferedReader((Reader)object, 32768);
        this.streamOpenForReading = true;
    }

    private void loadMetaData() throws Exception {
        this.openFile();
        if (this.columnDefinition.toUpperCase(Locale.ENGLISH).equals("True".toUpperCase(Locale.ENGLISH))) {
            this.hasColumnDefinition = true;
            this.ignoreFirstRow();
        }
        if (this.formatCode == 0) {
            this.findNumberOfColumnsInARow();
        }
        this.closeStream();
    }

    void closeStream() throws Exception {
        if (this.streamOpenForReading) {
            this.bufferedReader.close();
            this.streamOpenForReading = false;
        }
        if (this.lobFileHandles != null) {
            for (int i2 = 0; i2 < this.numberOfColumns; ++i2) {
                if (this.lobFileHandles[i2] == null) continue;
                this.lobFileHandles[i2].close();
            }
        }
    }

    int findNumberOfColumnsInARow() throws Exception {
        this.numberOfColumns = 1;
        while (!this.readTokensUntilEndOfRecord()) {
            ++this.numberOfColumns;
        }
        if (this.hasDelimiterAtEnd) {
            --this.numberOfColumns;
        }
        if (this.numberOfCharsReadSoFar == 0) {
            this.numberOfColumns = 0;
        }
        return this.numberOfColumns;
    }

    private void checkForWhiteSpaceInFront() {
        char c2;
        if (!(this.positionOfNonWhiteSpaceCharInFront + 1 != this.totalCharsSoFar || this.foundStartDelimiter || this.foundStartAndStopDelimiters || !Character.isWhitespace(c2 = this.currentToken[this.positionOfNonWhiteSpaceCharInFront]) || !this.recordSepStartNotWhite && c2 == this.recordSeparatorChar0 || !this.fieldSepStartNotWhite && c2 == this.fieldSeparatorChar0)) {
            ++this.positionOfNonWhiteSpaceCharInFront;
        }
    }

    private void checkForWhiteSpaceInBack() {
        boolean bl = true;
        this.positionOfNonWhiteSpaceCharInBack = 0;
        for (int i2 = this.totalCharsSoFar; i2 > this.stopDelimiterPosition && bl; --i2) {
            char c2 = this.currentToken[i2];
            if (Character.isWhitespace(c2)) {
                if (!this.recordSepStartNotWhite && c2 == this.recordSeparatorChar0 || !this.fieldSepStartNotWhite && c2 == this.fieldSeparatorChar0) continue;
                ++this.positionOfNonWhiteSpaceCharInBack;
                continue;
            }
            bl = false;
        }
    }

    boolean readTokensUntilEndOfRecord() throws Exception {
        int n2;
        int n3 = 0;
        int n4 = 0;
        this.fieldStopDelimiterIndex = 0;
        this.fieldStartDelimiterIndex = 0;
        this.totalCharsSoFar = 0;
        this.positionOfNonWhiteSpaceCharInFront = 0;
        this.foundStartDelimiter = false;
        this.foundStartAndStopDelimiters = false;
        this.numberOfCharsReadSoFar = 0;
        do {
            if ((n2 = this.bufferedReader.read()) == -1) {
                return true;
            }
            ++this.numberOfCharsReadSoFar;
            this.currentToken[this.totalCharsSoFar++] = (char)n2;
            this.checkForWhiteSpaceInFront();
            if (this.totalCharsSoFar == this.currentTokenMaxSize) {
                this.currentTokenMaxSize *= 2;
                char[] cArray = new char[this.currentTokenMaxSize];
                System.arraycopy(this.currentToken, 0, cArray, 0, this.totalCharsSoFar);
                this.currentToken = cArray;
            }
            if ((n3 = this.lookForPassedSeparator(this.fieldSeparator, n3, this.fieldSeparatorLength, n2, false)) != -1) continue;
            return false;
        } while (this.foundStartDelimiter || (n4 = this.lookForPassedSeparator(this.recordSeparator, n4, this.recordSeparatorLength, n2, true)) != -1);
        return true;
    }

    private int lookForPassedSeparator(char[] cArray, int n2, int n3, int n4, boolean bl) throws IOException {
        if (!this.foundStartDelimiter) {
            if (this.fieldStartDelimiterLength != 0 && !this.foundStartAndStopDelimiters && this.totalCharsSoFar != this.positionOfNonWhiteSpaceCharInFront && this.totalCharsSoFar - this.positionOfNonWhiteSpaceCharInFront <= this.fieldStartDelimiterLength) {
                if (n4 == this.fieldStartDelimiter[this.fieldStartDelimiterIndex]) {
                    ++this.fieldStartDelimiterIndex;
                    if (this.fieldStartDelimiterIndex == this.fieldStartDelimiterLength) {
                        this.foundStartDelimiter = true;
                        this.totalCharsSoFar = 0;
                        this.positionOfNonWhiteSpaceCharInFront = 0;
                        return 0;
                    }
                } else if (this.fieldStartDelimiterIndex > 0) {
                    this.reCheckRestOfTheCharacters(this.totalCharsSoFar - this.fieldStartDelimiterIndex, this.fieldStartDelimiter, this.fieldStartDelimiterLength);
                }
            }
            if (bl) {
                if (n4 == 13 || n4 == 10) {
                    this.recordSeparatorChar0 = (char)n4;
                    if (n4 == 13) {
                        this.omitLineFeed();
                    }
                    --this.totalCharsSoFar;
                    return -1;
                }
                return n2;
            }
            if (n4 == cArray[n2]) {
                if (++n2 == n3) {
                    this.totalCharsSoFar -= n3;
                    return -1;
                }
                return n2;
            }
            if (n2 > 0) {
                return this.reCheckRestOfTheCharacters(this.totalCharsSoFar - n2, cArray, n3);
            }
        } else {
            if (n4 == this.fieldStopDelimiter[this.fieldStopDelimiterIndex]) {
                ++this.fieldStopDelimiterIndex;
                if (this.fieldStopDelimiterIndex == this.fieldStopDelimiterLength) {
                    boolean bl2 = this.skipDoubleDelimiters(this.fieldStopDelimiter);
                    if (!bl2) {
                        this.foundStartDelimiter = false;
                        this.totalCharsSoFar -= this.fieldStopDelimiterLength;
                        this.stopDelimiterPosition = this.totalCharsSoFar;
                        this.foundStartAndStopDelimiters = true;
                    } else {
                        this.fieldStopDelimiterIndex = 0;
                    }
                    return 0;
                }
                return 0;
            }
            if (this.fieldStopDelimiterIndex > 0) {
                this.reCheckRestOfTheCharacters(this.totalCharsSoFar - this.fieldStopDelimiterIndex, this.fieldStopDelimiter, this.fieldStopDelimiterLength);
                return 0;
            }
        }
        return 0;
    }

    private int reCheckRestOfTheCharacters(int n2, char[] cArray, int n3) {
        int n4 = 0;
        for (int i2 = n2; i2 < this.totalCharsSoFar; ++i2) {
            if (this.currentToken[i2] == cArray[n4]) {
                ++n4;
                continue;
            }
            n4 = 0;
        }
        return n4;
    }

    private boolean skipDoubleDelimiters(char[] cArray) throws IOException {
        boolean bl = true;
        int n2 = cArray.length;
        this.bufferedReader.mark(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = this.bufferedReader.read();
            if (n3 == cArray[i2]) continue;
            this.bufferedReader.reset();
            bl = false;
            break;
        }
        return bl;
    }

    private void omitLineFeed() throws IOException {
        this.bufferedReader.mark(1);
        int n2 = this.bufferedReader.read();
        if (n2 != 10) {
            this.bufferedReader.reset();
        }
    }

    int getCurrentRowNumber() {
        return this.lineNumber;
    }

    boolean readNextRow(String[] stringArray) throws Exception {
        if (!this.streamOpenForReading) {
            this.openFile();
            if (this.hasColumnDefinition) {
                this.ignoreFirstRow();
            }
            this.ignoreHeaderLines();
        }
        boolean bl = this.formatCode == 0 ? this.readNextDelimitedRow(stringArray) : this.readNextFixedRow(stringArray);
        return bl;
    }

    private boolean readNextFixedRow(String[] stringArray) throws Exception {
        int n2;
        int n3 = 0;
        int n4 = 0;
        while ((n3 += this.bufferedReader.read(this.tempString, n3, this.rowWidth - n3)) < this.rowWidth) {
            if (n3 == n4 - 1) {
                if (n3 == -1) {
                    return false;
                }
                if (n4 != this.rowWidth - this.recordSeparator.length) {
                    throw LoadError.unexpectedEndOfFile(this.lineNumber + 1);
                }
                this.haveSep = false;
                break;
            }
            n4 = n3;
        }
        int n5 = 0;
        for (n2 = 0; n2 < this.numberOfColumns; ++n2) {
            int n6 = this.columnWidths[n2];
            if (n6 == 0) {
                stringArray[n2] = null;
                continue;
            }
            String string = new String(this.tempString, n5, n6);
            stringArray[n2] = string.trim().equals(this.nullString) ? null : string;
            n5 += n6;
        }
        if (this.haveSep) {
            for (n2 = this.recordSeparatorLength - 1; n2 >= 0; --n2) {
                if (this.tempString[n5 + n2] == this.recordSeparator[n2]) continue;
                throw LoadError.recordSeparatorMissing(this.lineNumber + 1);
            }
        } else {
            this.haveSep = true;
        }
        ++this.lineNumber;
        return true;
    }

    private boolean readNextDelimitedRow(String[] stringArray) throws Exception {
        int n2;
        int n3 = this.numberOfColumns - 1;
        if (n3 < 0) {
            return false;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if (!this.readNextToken(this.fieldSeparator, 0, this.fieldSeparatorLength, false)) {
                if (n2 == 0) {
                    return false;
                }
                throw LoadError.unexpectedEndOfFile(this.lineNumber + 1);
            }
            if (this.stopDelimiterPosition != 0 && this.stopDelimiterPosition != this.totalCharsSoFar) {
                for (int i2 = this.stopDelimiterPosition + 1; i2 < this.totalCharsSoFar; ++i2) {
                    if (Character.isWhitespace(this.currentToken[i2])) continue;
                    throw LoadError.dataAfterStopDelimiter(this.lineNumber + 1, n2 + 1);
                }
                this.totalCharsSoFar = this.stopDelimiterPosition;
            }
            stringArray[n2] = this.totalCharsSoFar != -1 ? new String(this.currentToken, this.positionOfNonWhiteSpaceCharInFront, this.totalCharsSoFar) : null;
        }
        if (!this.readNextToken(this.recordSeparator, 0, this.recordSeparatorLength, true)) {
            if (n3 == 0) {
                return false;
            }
            throw LoadError.unexpectedEndOfFile(this.lineNumber + 1);
        }
        if (this.stopDelimiterPosition != 0 && this.stopDelimiterPosition != this.totalCharsSoFar) {
            for (n2 = this.stopDelimiterPosition + 1; n2 < this.totalCharsSoFar; ++n2) {
                if (Character.isWhitespace(this.currentToken[n2])) continue;
                throw LoadError.dataAfterStopDelimiter(this.lineNumber + 1, this.numberOfColumns);
            }
            this.totalCharsSoFar = this.stopDelimiterPosition;
        }
        if (this.hasDelimiterAtEnd && this.fieldStopDelimiterLength <= 0) {
            --this.totalCharsSoFar;
        }
        if (this.totalCharsSoFar > -1) {
            if (!this.hasDelimiterAtEnd) {
                stringArray[n3] = new String(this.currentToken, this.positionOfNonWhiteSpaceCharInFront, this.totalCharsSoFar);
            } else if (this.totalCharsSoFar == this.fieldSeparatorLength && this.isFieldSep(this.currentToken)) {
                String string = new String(this.currentToken, this.positionOfNonWhiteSpaceCharInFront, this.totalCharsSoFar);
                stringArray[n3] = this.currentToken[this.totalCharsSoFar + 1] == this.fieldStopDelimiter[0] ? string : null;
            } else {
                stringArray[n3] = this.totalCharsSoFar > 0 ? new String(this.currentToken, this.positionOfNonWhiteSpaceCharInFront, this.totalCharsSoFar) : null;
            }
        } else {
            stringArray[n3] = null;
        }
        ++this.lineNumber;
        return true;
    }

    private boolean isFieldSep(char[] cArray) {
        for (int i2 = 0; i2 < cArray.length && i2 < this.fieldSeparatorLength; ++i2) {
            if (cArray[i2] == this.fieldSeparator[i2]) continue;
            return false;
        }
        return true;
    }

    boolean readNextToken(char[] cArray, int n2, int n3, boolean bl) throws Exception {
        this.fieldStopDelimiterIndex = 0;
        this.fieldStartDelimiterIndex = 0;
        this.totalCharsSoFar = 0;
        this.positionOfNonWhiteSpaceCharInFront = 0;
        this.stopDelimiterPosition = 0;
        this.foundStartAndStopDelimiters = false;
        this.foundStartDelimiter = false;
        int n4;
        while ((n4 = this.bufferedReader.read()) != -1) {
            int n5;
            this.currentToken[this.totalCharsSoFar++] = (char)n4;
            this.checkForWhiteSpaceInFront();
            if (this.totalCharsSoFar == this.currentTokenMaxSize) {
                this.currentTokenMaxSize *= 2;
                char[] cArray2 = new char[this.currentTokenMaxSize];
                System.arraycopy(this.currentToken, 0, cArray2, 0, this.totalCharsSoFar);
                this.currentToken = cArray2;
            }
            if ((n5 = this.lookForPassedSeparator(cArray, n2, n3, n4, bl)) == -1) {
                if (!this.foundStartAndStopDelimiters) {
                    if (this.totalCharsSoFar == 0) {
                        this.totalCharsSoFar = -1;
                    } else {
                        this.checkForWhiteSpaceInBack();
                        this.totalCharsSoFar = this.totalCharsSoFar - this.positionOfNonWhiteSpaceCharInFront - this.positionOfNonWhiteSpaceCharInBack;
                    }
                }
                return true;
            }
            n2 = n5;
        }
        return false;
    }

    String getClobColumnFromExtFileAsString(String string, int n2) throws SQLException {
        try {
            this.initExternalLobFile(string, n2);
            if (this.lobLength == -1) {
                return null;
            }
            return this.lobFileHandles[n2 - 1].getString(this.lobOffset, this.lobLength);
        }
        catch (Exception exception) {
            throw LoadError.unexpectedError(exception);
        }
    }

    Clob getClobColumnFromExtFile(String string, int n2) throws SQLException {
        try {
            this.initExternalLobFile(string, n2);
            if (this.lobLength == -1) {
                return null;
            }
            return new ImportClob(this.lobFileHandles[n2 - 1], this.lobOffset, this.lobLength);
        }
        catch (Exception exception) {
            throw LoadError.unexpectedError(exception);
        }
    }

    Blob getBlobColumnFromExtFile(String string, int n2) throws SQLException {
        this.initExternalLobFile(string, n2);
        if (this.lobLength == -1) {
            return null;
        }
        return new ImportBlob(this.lobFileHandles[n2 - 1], this.lobOffset, this.lobLength);
    }

    private void initExternalLobFile(String string, int n2) throws SQLException {
        int n3 = string.lastIndexOf(".");
        int n4 = string.lastIndexOf(".", n3 - 1);
        this.lobLength = Integer.parseInt(string.substring(n3 + 1, string.length() - 1));
        this.lobOffset = Long.parseLong(string.substring(n4 + 1, n3));
        this.lobFileName = string.substring(0, n4);
        if (this.lobFileHandles[n2 - 1] == null) {
            try {
                File file = new File(this.lobFileName);
                if (file.getParentFile() == null) {
                    file = new File(new File(this.inputFileName).getParentFile(), this.lobFileName);
                }
                this.lobFileHandles[n2 - 1] = new ImportLobFile(file, this.controlFileReader.getDataCodeset());
            }
            catch (Exception exception) {
                throw LoadError.unexpectedError(exception);
            }
        }
    }
}

