/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.bytecode;

import java.io.IOException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.classfile.ClassHolder;
import org.apache.derby.iapi.services.classfile.ClassMember;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.services.bytecode.BCJava;
import org.apache.derby.impl.services.bytecode.BCLocalField;
import org.apache.derby.impl.services.bytecode.BCMethod;
import org.apache.derby.impl.services.bytecode.GClass;
import org.apache.derby.impl.services.bytecode.Type;

class BCClass
extends GClass {
    String limitMsg;
    protected ClassHolder classHold;
    protected String superClassName;
    protected String name;
    BCJava factory;
    final Type classType;

    @Override
    public LocalField addField(String string, String string2, int n2) {
        Type type = this.factory.type(string);
        ClassMember classMember = this.classHold.addMember(string2, type.vmName(), n2);
        int n3 = this.classHold.addFieldReference(classMember);
        return new BCLocalField(type, n3);
    }

    @Override
    public ByteArray getClassBytecode() throws StandardException {
        if (this.bytecode != null) {
            return this.bytecode;
        }
        try {
            this.bytecode = this.classHold.getFileFormat();
        }
        catch (IOException iOException) {
            throw StandardException.newException("XBCM1.S", iOException, this.getFullName());
        }
        this.classHold = null;
        if (this.limitMsg != null) {
            throw StandardException.newException("XBCM4.S", this.getFullName(), this.limitMsg);
        }
        return this.bytecode;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public MethodBuilder newMethodBuilder(int n2, String string, String string2) {
        return this.newMethodBuilder(n2, string, string2, null);
    }

    @Override
    public MethodBuilder newMethodBuilder(int n2, String string, String string2, String[] stringArray) {
        BCMethod bCMethod = new BCMethod(this, string, string2, n2, stringArray, this.factory);
        return bCMethod;
    }

    @Override
    public MethodBuilder newConstructorBuilder(int n2) {
        return new BCMethod(this, "void", "<init>", n2, null, this.factory);
    }

    String getSuperClassName() {
        return this.superClassName;
    }

    ClassHolder modify() {
        return this.classHold;
    }

    BCClass(ClassFactory classFactory, String string, int n2, String string2, String string3, BCJava bCJava) {
        super(classFactory, string.concat(string2));
        this.name = string2;
        if (string3 == null) {
            string3 = "java.lang.Object";
        }
        this.superClassName = string3;
        this.classType = bCJava.type(this.getFullName());
        this.classHold = new ClassHolder(this.qualifiedName, bCJava.type((String)string3).vmNameSimple, n2);
        this.factory = bCJava;
    }

    ClassFactory getClassFactory() {
        return this.cf;
    }

    void addLimitExceeded(BCMethod bCMethod, String string, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.limitMsg != null) {
            stringBuffer.append(this.limitMsg);
            stringBuffer.append(", ");
        }
        stringBuffer.append("method:");
        stringBuffer.append(bCMethod.getName());
        stringBuffer.append(" ");
        stringBuffer.append(string);
        stringBuffer.append(" (");
        stringBuffer.append(n3);
        stringBuffer.append(" > ");
        stringBuffer.append(n2);
        stringBuffer.append(")");
        this.limitMsg = stringBuffer.toString();
    }

    void addLimitExceeded(String string) {
        this.limitMsg = this.limitMsg != null ? this.limitMsg + ", " + string : string;
    }
}

