/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.monitor;

import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.monitor.PersistentService;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.impl.services.monitor.BaseMonitor;
import org.apache.derby.impl.services.monitor.ModuleInstance;
import org.apache.derby.impl.services.monitor.ProtocolKey;

final class TopService {
    ProtocolKey key;
    ModuleInstance topModule;
    Hashtable<ProtocolKey, ModuleInstance> protocolTable;
    Vector<ModuleInstance> moduleInstances;
    BaseMonitor monitor;
    boolean inShutdown;
    PersistentService serviceType;
    Locale serviceLocale;

    TopService(BaseMonitor baseMonitor) {
        this.monitor = baseMonitor;
        this.protocolTable = new Hashtable();
        this.moduleInstances = new Vector(0, 5);
    }

    TopService(BaseMonitor baseMonitor, ProtocolKey protocolKey, PersistentService persistentService, Locale locale) {
        this(baseMonitor);
        this.key = protocolKey;
        this.serviceType = persistentService;
        this.serviceLocale = locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTopModule(Object object) {
        TopService topService = this;
        synchronized (topService) {
            ModuleInstance moduleInstance = this.findModuleInstance(object);
            if (moduleInstance != null) {
                this.topModule = moduleInstance;
                this.notifyAll();
            }
            if (this.getServiceType() != null) {
                ProtocolKey protocolKey = new ProtocolKey(this.key.getFactoryInterface(), this.monitor.getServiceName(object));
                this.addToProtocol(protocolKey, this.topModule);
            }
        }
    }

    Object getService() {
        return this.topModule.getInstance();
    }

    boolean isPotentialService(ProtocolKey protocolKey) {
        String string;
        if (this.serviceType == null) {
            string = protocolKey.getIdentifier();
        } else {
            try {
                string = this.serviceType.getCanonicalServiceName(protocolKey.getIdentifier());
            }
            catch (StandardException standardException) {
                return false;
            }
            if (string == null) {
                return false;
            }
        }
        if (this.topModule != null) {
            return this.topModule.isTypeAndName(this.serviceType, this.key.getFactoryInterface(), string);
        }
        if (!protocolKey.getFactoryInterface().isAssignableFrom(this.key.getFactoryInterface())) {
            return false;
        }
        return this.serviceType.isSameService(this.key.getIdentifier(), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isActiveService() {
        TopService topService = this;
        synchronized (topService) {
            return this.topModule != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isActiveService(ProtocolKey protocolKey) {
        TopService topService = this;
        synchronized (topService) {
            if (this.inShutdown) {
                return false;
            }
            if (!this.isPotentialService(protocolKey)) {
                return false;
            }
            if (this.topModule != null) {
                return true;
            }
            while (!this.inShutdown && this.topModule == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    InterruptStatus.setInterrupted();
                }
            }
            return !this.inShutdown;
            {
            }
        }
    }

    synchronized Object findModule(ProtocolKey protocolKey, boolean bl, Properties properties) {
        ModuleInstance moduleInstance = this.protocolTable.get(protocolKey);
        if (moduleInstance == null) {
            return null;
        }
        Object object = moduleInstance.getInstance();
        if (bl || BaseMonitor.canSupport(object, properties)) {
            return object;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModuleInstance findModuleInstance(Object object) {
        Vector<ModuleInstance> vector = this.moduleInstances;
        synchronized (vector) {
            for (int i2 = 0; i2 < this.moduleInstances.size(); ++i2) {
                ModuleInstance moduleInstance = this.moduleInstances.get(i2);
                if (moduleInstance.getInstance() != object) continue;
                return moduleInstance;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object bootModule(boolean bl, Object object, ProtocolKey protocolKey, Properties properties) throws StandardException {
        Object object2 = this;
        synchronized (object2) {
            if (this.inShutdown) {
                throw StandardException.newException("08006.D", this.getKey().getIdentifier());
            }
        }
        object2 = this.findModule(protocolKey, false, properties);
        if (object2 != null) {
            return object2;
        }
        if (this.monitor.reportOn) {
            this.monitor.report("Booting Module   " + protocolKey.toString() + " create = " + bl);
        }
        Object object3 = this;
        synchronized (object3) {
            int n2 = 0;
            while (true) {
                ModuleInstance moduleInstance;
                Vector<ModuleInstance> vector = this.moduleInstances;
                synchronized (vector) {
                    if (n2 >= this.moduleInstances.size()) {
                        break;
                    }
                    moduleInstance = this.moduleInstances.get(n2);
                }
                if (moduleInstance.isBooted() && moduleInstance.isTypeAndName(null, protocolKey.getFactoryInterface(), protocolKey.getIdentifier()) && BaseMonitor.canSupport(object2 = moduleInstance.getInstance(), properties) && this.addToProtocol(protocolKey, moduleInstance)) {
                    if (this.monitor.reportOn) {
                        this.monitor.report("Started Module   " + protocolKey.toString());
                        this.monitor.report("  Implementation " + object2.getClass().getName());
                    }
                    return object2;
                }
                ++n2;
            }
        }
        object2 = this.monitor.loadInstance(protocolKey.getFactoryInterface(), properties);
        if (object2 == null) {
            throw Monitor.missingImplementation(protocolKey.getFactoryInterface().getName());
        }
        object3 = new ModuleInstance(object2, protocolKey.getIdentifier(), object, this.topModule == null ? null : this.topModule.getInstance());
        this.moduleInstances.add((ModuleInstance)object3);
        try {
            BaseMonitor.boot(object2, bl, properties);
        }
        catch (StandardException standardException) {
            this.moduleInstances.remove(object3);
            throw standardException;
        }
        ((ModuleInstance)object3).setBooted();
        TopService topService = this;
        synchronized (topService) {
            if (this.addToProtocol(protocolKey, (ModuleInstance)object3)) {
                if (this.monitor.reportOn) {
                    this.monitor.report("Started Module   " + protocolKey.toString());
                    this.monitor.report("  Implementation " + ((ModuleInstance)object3).getInstance().getClass().getName());
                }
                return ((ModuleInstance)object3).getInstance();
            }
        }
        TopService.stop(object2);
        this.moduleInstances.remove(object3);
        return this.findModule(protocolKey, true, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean shutdown() {
        Object object = this;
        synchronized (object) {
            if (this.inShutdown) {
                return false;
            }
            this.inShutdown = true;
            this.notifyAll();
        }
        while (true) {
            Object object2 = this;
            synchronized (object2) {
                if (this.moduleInstances.isEmpty()) {
                    return true;
                }
                object = this.moduleInstances.get(0);
            }
            object2 = ((ModuleInstance)object).getInstance();
            TopService.stop(object2);
            TopService topService = this;
            synchronized (topService) {
                this.moduleInstances.remove(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addToProtocol(ProtocolKey protocolKey, ModuleInstance moduleInstance) {
        String string = moduleInstance.getIdentifier();
        TopService topService = this;
        synchronized (topService) {
            ModuleInstance moduleInstance2 = this.protocolTable.get(protocolKey);
            if (moduleInstance2 == null) {
                this.protocolTable.put(protocolKey, moduleInstance);
                return true;
            }
            return moduleInstance2 == moduleInstance;
            {
            }
        }
    }

    boolean inService(Object object) {
        return this.findModuleInstance(object) != null;
    }

    public ProtocolKey getKey() {
        return this.key;
    }

    PersistentService getServiceType() {
        return this.serviceType;
    }

    private static void stop(Object object) {
        if (object instanceof ModuleControl) {
            ((ModuleControl)object).stop();
        }
    }
}

