/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.Dependable;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.FormatableHashtable;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.impl.sql.catalog.DDdependableFinder;

public class DDColumnDependableFinder
extends DDdependableFinder {
    private byte[] columnBitMap;

    public DDColumnDependableFinder(int n2) {
        super(n2);
    }

    DDColumnDependableFinder(int n2, byte[] byArray) {
        super(n2);
        this.columnBitMap = byArray;
    }

    @Override
    Dependable findDependable(DataDictionary dataDictionary, UUID uUID) throws StandardException {
        TableDescriptor tableDescriptor = dataDictionary.getTableDescriptor(uUID);
        if (tableDescriptor != null) {
            tableDescriptor.setReferencedColumnMap(new FormatableBitSet(this.columnBitMap));
        }
        return tableDescriptor;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        FormatableHashtable formatableHashtable = (FormatableHashtable)objectInput.readObject();
        this.columnBitMap = (byte[])formatableHashtable.get("columnBitMap");
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        FormatableHashtable formatableHashtable = new FormatableHashtable();
        formatableHashtable.put("columnBitMap", this.columnBitMap);
        objectOutput.writeObject(formatableHashtable);
    }
}

