/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.BinaryOperatorNode;
import org.apache.derby.impl.sql.compile.CastNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.SubqueryNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public abstract class BinaryComparisonOperatorNode
extends BinaryOperatorNode {
    private boolean forQueryRewrite;
    private boolean betweenSelectivity;

    BinaryComparisonOperatorNode(ValueNode valueNode, ValueNode valueNode2, String string, String string2, boolean bl, ContextManager contextManager) throws StandardException {
        super(valueNode, valueNode2, string, string2, "org.apache.derby.iapi.types.DataValueDescriptor", "org.apache.derby.iapi.types.DataValueDescriptor", contextManager);
        this.forQueryRewrite = bl;
    }

    void setForQueryRewrite(boolean bl) {
        this.forQueryRewrite = bl;
    }

    boolean getForQueryRewrite() {
        return this.forQueryRewrite;
    }

    void setBetweenSelectivity() {
        this.betweenSelectivity = true;
    }

    boolean getBetweenSelectivity() {
        return this.betweenSelectivity;
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> list) throws StandardException {
        super.bindExpression(fromList, subqueryList, list);
        TypeId typeId = this.leftOperand.getTypeId();
        TypeId typeId2 = this.rightOperand.getTypeId();
        if (!typeId.isStringTypeId() && typeId2.isStringTypeId()) {
            DataTypeDescriptor dataTypeDescriptor = this.rightOperand.getTypeServices();
            this.rightOperand = new CastNode(this.rightOperand, new DataTypeDescriptor(typeId2, true, dataTypeDescriptor.getMaximumWidth()), this.getContextManager());
            ((CastNode)this.rightOperand).bindCastNodeOnly();
        } else if (!typeId2.isStringTypeId() && typeId.isStringTypeId()) {
            DataTypeDescriptor dataTypeDescriptor = this.leftOperand.getTypeServices();
            this.leftOperand = new CastNode(this.leftOperand, new DataTypeDescriptor(typeId, true, dataTypeDescriptor.getMaximumWidth()), this.getContextManager());
            ((CastNode)this.leftOperand).bindCastNodeOnly();
        }
        this.bindComparisonOperator();
        return this;
    }

    void bindComparisonOperator() throws StandardException {
        boolean bl = this.operator.equals("=") || this.operator.equals("<>");
        boolean bl2 = this.leftOperand.getTypeServices().comparable(this.rightOperand.getTypeServices(), bl, this.getClassFactory());
        if (!bl2 && !this.forQueryRewrite) {
            throw StandardException.newException("42818", this.leftOperand.getTypeServices().getSQLTypeNameWithCollation(), this.rightOperand.getTypeServices().getSQLTypeNameWithCollation());
        }
        boolean bl3 = this.leftOperand.getTypeServices().isNullable() || this.rightOperand.getTypeServices().isNullable();
        this.setType(new DataTypeDescriptor(TypeId.BOOLEAN_ID, bl3));
    }

    @Override
    ValueNode preprocess(int n2, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        this.leftOperand = this.leftOperand.preprocess(n2, fromList, subqueryList, predicateList);
        if (this.rightOperand instanceof SubqueryNode && !((SubqueryNode)this.rightOperand).getPreprocessed()) {
            ((SubqueryNode)this.rightOperand).setParentComparisonOperator(this);
            return this.rightOperand.preprocess(n2, fromList, subqueryList, predicateList);
        }
        this.rightOperand = this.rightOperand.preprocess(n2, fromList, subqueryList, predicateList);
        return this;
    }

    @Override
    ValueNode eliminateNots(boolean bl) throws StandardException {
        if (!bl) {
            return this;
        }
        return this.getNegation(this.leftOperand, this.rightOperand);
    }

    abstract BinaryOperatorNode getNegation(ValueNode var1, ValueNode var2) throws StandardException;

    abstract BinaryOperatorNode getSwappedEquivalent() throws StandardException;

    @Override
    ValueNode changeToCNF(boolean bl) throws StandardException {
        if (bl && this.rightOperand instanceof SubqueryNode) {
            this.rightOperand = this.rightOperand.changeToCNF(bl);
        }
        return this;
    }

    @Override
    ValueNode genSQLJavaSQLTree() throws StandardException {
        TypeId typeId;
        TypeId typeId2 = this.leftOperand.getTypeId();
        if (typeId2.userType()) {
            if (this.leftOperand.getTypeServices().comparable(this.leftOperand.getTypeServices(), false, this.getClassFactory())) {
                return this;
            }
            this.leftOperand = this.leftOperand.genSQLJavaSQLTree();
        }
        if ((typeId = this.rightOperand.getTypeId()).userType()) {
            if (this.rightOperand.getTypeServices().comparable(this.rightOperand.getTypeServices(), false, this.getClassFactory())) {
                return this;
            }
            this.rightOperand = this.rightOperand.genSQLJavaSQLTree();
        }
        return this;
    }
}

