/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.CollectNodesVisitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ProjectRestrictNode;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.RowResultSetNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.ValueNode;

class FromSubquery
extends FromTable {
    ResultSetNode subquery;
    private OrderByList orderByList;
    private ValueNode offset;
    private ValueNode fetchFirst;
    private boolean hasJDBClimitClause;
    private SchemaDescriptor origCompilationSchema = null;

    FromSubquery(ResultSetNode resultSetNode, OrderByList orderByList, ValueNode valueNode, ValueNode valueNode2, boolean bl, String string, ResultColumnList resultColumnList, Properties properties, ContextManager contextManager) {
        super(string, properties, contextManager);
        this.subquery = resultSetNode;
        this.orderByList = orderByList;
        this.offset = valueNode;
        this.fetchFirst = valueNode2;
        this.hasJDBClimitClause = bl;
        this.setResultColumns(resultColumnList);
    }

    @Override
    void printSubNodes(int n2) {
    }

    ResultSetNode getSubquery() {
        return this.subquery;
    }

    @Override
    FromTable getFromTableByName(String string, String string2, boolean bl) throws StandardException {
        if (string2 != null && this.origTableName != null && !string2.equals(this.origTableName.schemaName)) {
            return null;
        }
        if (this.getExposedName().equals(string)) {
            return this;
        }
        return null;
    }

    @Override
    ResultSetNode bindNonVTITables(DataDictionary dataDictionary, FromList fromList) throws StandardException {
        if (this.tableNumber == -1) {
            this.tableNumber = this.getCompilerContext().getNextTableNumber();
        }
        this.subquery = this.subquery.bindNonVTITables(dataDictionary, fromList);
        return this;
    }

    @Override
    ResultSetNode bindVTITables(FromList fromList) throws StandardException {
        this.subquery = this.subquery.bindVTITables(fromList);
        return this;
    }

    @Override
    void rejectParameters() throws StandardException {
        this.subquery.rejectParameters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void bindExpressions(FromList fromList) throws StandardException {
        FromList fromList2 = new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager());
        ResultColumnList resultColumnList = this.getResultColumns();
        if (this.orderByList != null) {
            this.orderByList.pullUpOrderByColumns(this.subquery);
        }
        FromList fromList3 = fromList2;
        CompilerContext compilerContext = this.getCompilerContext();
        if (this.origCompilationSchema != null) {
            compilerContext.pushCompilationSchema(this.origCompilationSchema);
        }
        CollectNodesVisitor<FromVTI> collectNodesVisitor = new CollectNodesVisitor<FromVTI>(FromVTI.class);
        this.subquery.accept(collectNodesVisitor);
        for (FromVTI fromVTI : collectNodesVisitor.getList()) {
            fromVTI.addOuterFromList(fromList);
        }
        try {
            this.subquery.bindExpressions(fromList3);
            this.subquery.bindResultColumns(fromList3);
        }
        finally {
            if (this.origCompilationSchema != null) {
                compilerContext.popCompilationSchema();
            }
        }
        if (this.orderByList != null) {
            this.orderByList.bindOrderByColumns(this.subquery);
        }
        FromSubquery.bindOffsetFetch(this.offset, this.fetchFirst);
        ResultColumnList resultColumnList2 = this.subquery.getResultColumns();
        if (this.getResultColumns() != null && this.getResultColumns().getCountMismatchAllowed() && this.getResultColumns().size() < resultColumnList2.size()) {
            for (int i2 = resultColumnList2.size() - 1; i2 >= this.getResultColumns().size(); --i2) {
                resultColumnList2.removeElementAt(i2);
            }
        }
        ResultColumnList resultColumnList3 = resultColumnList2.copyListAndObjects();
        resultColumnList3.genVirtualColumnNodes(this.subquery, this.subquery.getResultColumns());
        this.setResultColumns(resultColumnList3);
        if (resultColumnList != null) {
            this.getResultColumns().propagateDCLInfo(resultColumnList, this.correlationName);
        }
    }

    @Override
    ResultColumn getMatchingColumn(ColumnReference columnReference) throws StandardException {
        ResultColumn resultColumn = null;
        String string = columnReference.getTableName();
        if (columnReference.getGeneratedToReplaceAggregate()) {
            resultColumn = this.getResultColumns().getResultColumn(columnReference.getColumnName());
        } else if (string == null || string.equals(this.correlationName)) {
            resultColumn = this.getResultColumns().getAtMostOneResultColumn(columnReference, this.correlationName, false);
        }
        if (resultColumn != null) {
            columnReference.setTableNumber(this.tableNumber);
            columnReference.setColumnNumber(resultColumn.getColumnPosition());
        }
        return resultColumn;
    }

    @Override
    ResultSetNode preprocess(int n2, GroupByList groupByList, FromList fromList) throws StandardException {
        this.subquery.pushQueryExpressionSuffix();
        if (this.orderByList != null) {
            if (this.orderByList.size() > 1) {
                this.orderByList.removeDupColumns();
            }
            this.subquery.pushOrderByList(this.orderByList);
            this.orderByList = null;
        }
        this.subquery.pushOffsetFetchFirst(this.offset, this.fetchFirst, this.hasJDBClimitClause);
        this.subquery = this.subquery.preprocess(n2, groupByList, fromList);
        if ((groupByList == null || groupByList.size() == 0) && this.tableProperties == null && this.subquery.flattenableInFromSubquery(fromList)) {
            this.setReferencedTableMap(this.subquery.getReferencedTableMap());
            return this;
        }
        return this.extractSubquery(n2);
    }

    ResultSetNode extractSubquery(int n2) throws StandardException {
        ProjectRestrictNode projectRestrictNode = new ProjectRestrictNode(this.subquery, this.getResultColumns(), null, null, null, null, this.tableProperties, this.getContextManager());
        JBitSet jBitSet = new JBitSet(n2);
        jBitSet.set(this.tableNumber);
        projectRestrictNode.setReferencedTableMap(jBitSet);
        ((FromTable)projectRestrictNode).setTableNumber(this.tableNumber);
        return projectRestrictNode;
    }

    @Override
    FromList flatten(ResultColumnList resultColumnList, PredicateList predicateList, SubqueryList subqueryList, GroupByList groupByList, ValueNode valueNode) throws StandardException {
        FromList fromList = null;
        this.getResultColumns().setRedundant();
        this.subquery.getResultColumns().setRedundant();
        if (this.subquery instanceof SelectNode) {
            SelectNode selectNode = (SelectNode)this.subquery;
            fromList = selectNode.getFromList();
            if (selectNode.getWherePredicates().size() > 0) {
                predicateList.destructiveAppend(selectNode.getWherePredicates());
            }
            if (selectNode.getWhereSubquerys().size() > 0) {
                subqueryList.destructiveAppend(selectNode.getWhereSubquerys());
            }
        } else if (!(this.subquery instanceof RowResultSetNode)) {
            // empty if block
        }
        resultColumnList.remapColumnReferencesToExpressions();
        predicateList.remapColumnReferencesToExpressions();
        if (groupByList != null) {
            groupByList.remapColumnReferencesToExpressions();
        }
        if (valueNode != null) {
            valueNode.remapColumnReferencesToExpressions();
        }
        return fromList;
    }

    @Override
    String getExposedName() {
        return this.correlationName;
    }

    @Override
    ResultColumnList getAllResultColumns(TableName tableName) throws StandardException {
        TableName tableName2 = tableName != null ? this.makeTableName(tableName.getSchemaName(), this.correlationName) : this.makeTableName(null, this.correlationName);
        if (tableName != null && !tableName.equals(tableName2)) {
            return null;
        }
        TableName tableName3 = this.makeTableName(null, this.correlationName);
        ResultColumnList resultColumnList = new ResultColumnList(this.getContextManager());
        int n2 = this.getResultColumns().visibleSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            ResultColumn resultColumn = (ResultColumn)this.getResultColumns().elementAt(i2);
            if (resultColumn.isGenerated()) continue;
            String string = resultColumn.getName();
            boolean bl = resultColumn.isNameGenerated();
            TableName tableName4 = tableName3;
            ColumnReference columnReference = new ColumnReference(string, tableName4, this.getContextManager());
            resultColumn = new ResultColumn(string, (ValueNode)columnReference, this.getContextManager());
            resultColumn.setNameGenerated(bl);
            resultColumnList.addResultColumn(resultColumn);
        }
        return resultColumnList;
    }

    @Override
    boolean referencesTarget(String string, boolean bl) throws StandardException {
        return this.subquery.referencesTarget(string, bl);
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        return this.subquery.referencesSessionSchema();
    }

    @Override
    void bindUntypedNullsToResultColumns(ResultColumnList resultColumnList) throws StandardException {
        this.subquery.bindUntypedNullsToResultColumns(resultColumnList);
    }

    @Override
    void decrementLevel(int n2) {
        super.decrementLevel(n2);
        this.subquery.decrementLevel(n2);
    }

    void setOrigCompilationSchema(SchemaDescriptor schemaDescriptor) {
        this.origCompilationSchema = schemaDescriptor;
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        this.subquery.accept(visitor);
        if (this.orderByList != null) {
            this.orderByList.accept(visitor);
        }
        if (this.offset != null) {
            this.offset.accept(visitor);
        }
        if (this.fetchFirst != null) {
            this.fetchFirst.accept(visitor);
        }
    }
}

