/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.depend.ProviderList;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.CollectNodesVisitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;

class GenerationClauseNode
extends ValueNode {
    private ValueNode _generationExpression;
    private String _expressionText;
    private ValueNode _boundExpression;
    private ProviderList _apl;

    GenerationClauseNode(ValueNode valueNode, String string, ContextManager contextManager) {
        super(contextManager);
        this._generationExpression = valueNode;
        this._expressionText = string;
    }

    public String getExpressionText() {
        return this._expressionText;
    }

    void setAuxiliaryProviderList(ProviderList providerList) {
        this._apl = providerList;
    }

    ProviderList getAuxiliaryProviderList() {
        return this._apl;
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> list) throws StandardException {
        this._boundExpression = this._generationExpression.bindExpression(fromList, subqueryList, list);
        return this._boundExpression;
    }

    @Override
    void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        throw StandardException.newException("XSCH8.S", new Object[0]);
    }

    @Override
    boolean isEquivalent(ValueNode valueNode) throws StandardException {
        if (!this.isSameNodeKind(valueNode)) {
            return false;
        }
        GenerationClauseNode generationClauseNode = (GenerationClauseNode)valueNode;
        return this._generationExpression.isEquivalent(generationClauseNode._generationExpression);
    }

    public List<ColumnReference> findReferencedColumns() throws StandardException {
        CollectNodesVisitor<ColumnReference> collectNodesVisitor = new CollectNodesVisitor<ColumnReference>(ColumnReference.class);
        this._generationExpression.accept(collectNodesVisitor);
        return collectNodesVisitor.getList();
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this._generationExpression != null) {
            this._generationExpression = (ValueNode)this._generationExpression.accept(visitor);
        }
        if (this._boundExpression != null) {
            this._boundExpression = (ValueNode)this._boundExpression.accept(visitor);
        }
    }

    @Override
    public String toString() {
        return "expressionText: GENERATED ALWAYS AS ( " + this._expressionText + " )\n" + super.toString();
    }

    @Override
    void printSubNodes(int n2) {
    }
}

