/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.MiscellaneousStatementNode;
import org.apache.derby.impl.sql.compile.ParameterNode;

class SetSchemaNode
extends MiscellaneousStatementNode {
    private String name;
    private int type;

    SetSchemaNode(String string, int n2, ContextManager contextManager) {
        super(contextManager);
        this.name = string;
        this.type = n2;
    }

    @Override
    public String toString() {
        return "";
    }

    @Override
    String statementToString() {
        return "SET SCHEMA";
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getSetSchemaConstantAction(this.name, this.type);
    }

    @Override
    void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        if (this.type == 2) {
            this.generateParameterValueSet(activationClassBuilder);
        }
        activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
        activationClassBuilder.pushThisAsActivation(methodBuilder);
        methodBuilder.callMethod((short)185, null, "getMiscResultSet", "org.apache.derby.iapi.sql.ResultSet", 1);
    }

    void generateParameterValueSet(ActivationClassBuilder activationClassBuilder) throws StandardException {
        List<ParameterNode> list = this.getCompilerContext().getParameterList();
        ParameterNode.generateParameterValueSet(activationClassBuilder, 1, list);
    }

    @Override
    int activationKind() {
        if (this.type == 2) {
            return 2;
        }
        return 0;
    }
}

