/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.JavaValueNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;

public final class StaticClassFieldReferenceNode
extends JavaValueNode {
    private String fieldName;
    private String javaClassName;
    private boolean classNameDelimitedIdentifier;
    private Member field;

    StaticClassFieldReferenceNode(String string, String string2, boolean bl, ContextManager contextManager) {
        super(contextManager);
        this.fieldName = string2;
        this.javaClassName = string;
        this.classNameDelimitedIdentifier = bl;
    }

    @Override
    JavaValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> list) throws StandardException {
        ClassInspector classInspector = this.getClassFactory().getClassInspector();
        if ((this.getCompilerContext().getReliability() & 0x400) != 0 || !this.javaClassName.startsWith("java.sql.")) {
            throw StandardException.newException("42X01", this.javaClassName + "::" + this.fieldName);
        }
        this.verifyClassExist(this.javaClassName);
        this.field = classInspector.findPublicField(this.javaClassName, this.fieldName, true);
        this.setJavaTypeName(classInspector.getType(this.field));
        return this;
    }

    @Override
    void preprocess(int n2, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
    }

    @Override
    boolean categorize(JBitSet jBitSet, boolean bl) {
        return true;
    }

    @Override
    JavaValueNode remapColumnReferencesToExpressions() throws StandardException {
        return this;
    }

    @Override
    int getOrderableVariantType() {
        if (Modifier.isFinal(this.field.getModifiers())) {
            return 3;
        }
        return 0;
    }

    @Override
    void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        methodBuilder.getStaticField(this.field.getDeclaringClass().getName(), this.fieldName, this.getJavaTypeName());
    }
}

