/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.catalog.types.AggregateAliasInfo;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.TypeCompilerFactory;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.JSQLType;
import org.apache.derby.impl.sql.compile.AggregateDefinition;
import org.apache.derby.impl.sql.compile.MethodCallNode;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.StaticMethodCallNode;
import org.apache.derby.impl.sql.compile.ValueNode;

class UserAggregateDefinition
implements AggregateDefinition {
    private static final int INPUT_TYPE = 0;
    private static final int RETURN_TYPE = 1;
    private static final int AGGREGATOR_TYPE = 2;
    private static final int AGGREGATOR_PARAM_COUNT = 3;
    private static final String DERBY_BYTE_ARRAY_NAME = "byte[]";
    private AliasDescriptor _alias;

    public UserAggregateDefinition(AliasDescriptor aliasDescriptor) {
        this._alias = aliasDescriptor;
    }

    public AliasDescriptor getAliasDescriptor() {
        return this._alias;
    }

    @Override
    public final DataTypeDescriptor getAggregator(DataTypeDescriptor dataTypeDescriptor, StringBuffer stringBuffer) throws StandardException {
        try {
            CompilerContext compilerContext = (CompilerContext)QueryTreeNode.getContext("CompilerContext");
            ClassFactory classFactory = compilerContext.getClassFactory();
            TypeCompilerFactory typeCompilerFactory = compilerContext.getTypeCompilerFactory();
            Class clazz = classFactory.loadApplicationClass("org.apache.derby.agg.Aggregator");
            Class clazz2 = classFactory.loadApplicationClass(this._alias.getJavaClassName());
            Class[][] classArray = classFactory.getClassInspector().getTypeBounds(clazz, clazz2);
            if (classArray == null || classArray.length != 3 || classArray[0] == null || classArray[1] == null) {
                throw StandardException.newException("42ZC4", this._alias.getSchemaName(), this._alias.getName(), clazz2.getName());
            }
            Class<?>[] classArray2 = classFactory.getClassInspector().getGenericParameterTypes(clazz, clazz2);
            if (classArray2 == null) {
                classArray2 = new Class[3];
            }
            AggregateAliasInfo aggregateAliasInfo = (AggregateAliasInfo)this._alias.getAliasInfo();
            DataTypeDescriptor dataTypeDescriptor2 = DataTypeDescriptor.getType(aggregateAliasInfo.getForType());
            DataTypeDescriptor dataTypeDescriptor3 = DataTypeDescriptor.getType(aggregateAliasInfo.getReturnType());
            Class<?> clazz3 = this.getJavaClass(classFactory, dataTypeDescriptor2);
            Class<?> clazz4 = this.getJavaClass(classFactory, dataTypeDescriptor3);
            if (!typeCompilerFactory.getTypeCompiler(dataTypeDescriptor2.getTypeId()).storable(dataTypeDescriptor.getTypeId(), classFactory)) {
                return null;
            }
            Class[] classArray3 = classArray[0];
            for (int i2 = 0; i2 < classArray3.length; ++i2) {
                this.vetCompatibility(classArray3[i2], clazz3, "42ZC6");
            }
            if (classArray2[0] != null) {
                this.vetCompatibility(classArray2[0], clazz3, "42ZC6");
            }
            Class[] classArray4 = classArray[1];
            for (int i3 = 0; i3 < classArray4.length; ++i3) {
                this.vetCompatibility(classArray4[i3], clazz4, "42ZC7");
            }
            if (classArray2[1] != null) {
                this.vetCompatibility(classArray2[1], clazz4, "42ZC7");
            }
            stringBuffer.append("org.apache.derby.impl.sql.execute.UserDefinedAggregator");
            return dataTypeDescriptor3;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw this.aggregatorInstantiation(classNotFoundException);
        }
    }

    private void vetCompatibility(Class<?> clazz, Class<?> clazz2, String string) throws StandardException {
        if (!clazz.isAssignableFrom(clazz2)) {
            throw StandardException.newException(string, this._alias.getSchemaName(), this._alias.getName(), clazz2.toString(), clazz.toString());
        }
    }

    final ValueNode castInputValue(ValueNode valueNode, ContextManager contextManager) throws StandardException {
        DataTypeDescriptor dataTypeDescriptor;
        AggregateAliasInfo aggregateAliasInfo = (AggregateAliasInfo)this._alias.getAliasInfo();
        DataTypeDescriptor dataTypeDescriptor2 = DataTypeDescriptor.getType(aggregateAliasInfo.getForType());
        if (dataTypeDescriptor2.isExactTypeAndLengthMatch(dataTypeDescriptor = valueNode.getTypeServices())) {
            return null;
        }
        return StaticMethodCallNode.makeCast(valueNode, dataTypeDescriptor2, contextManager);
    }

    private Class<?> getJavaClass(ClassFactory classFactory, DataTypeDescriptor dataTypeDescriptor) throws StandardException, ClassNotFoundException {
        JSQLType jSQLType = new JSQLType(dataTypeDescriptor);
        String string = MethodCallNode.getObjectTypeName(jSQLType, null);
        if (DERBY_BYTE_ARRAY_NAME.equals(string)) {
            string = byte[].class.getName();
        }
        return classFactory.loadApplicationClass(string);
    }

    private StandardException aggregatorInstantiation(Throwable throwable) {
        return StandardException.newException("42ZC8", throwable, this._alias.getJavaClassName(), this._alias.getSchemaName(), this._alias.getName(), throwable.getMessage());
    }
}

