/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.access.RowLocationRetRowSource;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;

class CardinalityCounter
implements RowLocationRetRowSource {
    private RowLocationRetRowSource rowSource;
    private DataValueDescriptor[] prevKey;
    private long[] cardinality;
    private long numRows;

    public CardinalityCounter(RowLocationRetRowSource rowLocationRetRowSource) {
        this.rowSource = rowLocationRetRowSource;
    }

    @Override
    public boolean needsRowLocation() {
        return this.rowSource.needsRowLocation();
    }

    @Override
    public boolean needsRowLocationForDeferredCheckConstraints() {
        return this.rowSource.needsRowLocationForDeferredCheckConstraints();
    }

    @Override
    public void offendingRowLocation(RowLocation rowLocation, long l2) throws StandardException {
        this.rowSource.offendingRowLocation(rowLocation, l2);
    }

    @Override
    public void rowLocation(RowLocation rowLocation) throws StandardException {
        this.rowSource.rowLocation(rowLocation);
    }

    @Override
    public DataValueDescriptor[] getNextRowFromRowSource() throws StandardException {
        DataValueDescriptor[] dataValueDescriptorArray = this.rowSource.getNextRowFromRowSource();
        if (dataValueDescriptorArray != null) {
            this.keepCount(dataValueDescriptorArray);
        }
        return dataValueDescriptorArray;
    }

    @Override
    public boolean needsToClone() {
        return this.rowSource.needsToClone();
    }

    @Override
    public FormatableBitSet getValidColumns() {
        return this.rowSource.getValidColumns();
    }

    @Override
    public void closeRowSource() {
        this.rowSource.closeRowSource();
    }

    private DataValueDescriptor[] clone(DataValueDescriptor[] dataValueDescriptorArray) {
        DataValueDescriptor[] dataValueDescriptorArray2 = new DataValueDescriptor[dataValueDescriptorArray.length];
        for (int i2 = 0; i2 < dataValueDescriptorArray.length - 1; ++i2) {
            dataValueDescriptorArray2[i2] = dataValueDescriptorArray[i2].cloneValue(false);
        }
        return dataValueDescriptorArray2;
    }

    public void keepCount(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        int n2;
        int n3 = dataValueDescriptorArray.length - 1;
        ++this.numRows;
        if (this.prevKey == null) {
            this.prevKey = this.clone(dataValueDescriptorArray);
            this.cardinality = new long[dataValueDescriptorArray.length - 1];
            for (int i2 = 0; i2 < n3; ++i2) {
                this.cardinality[i2] = 1L;
            }
            return;
        }
        for (n2 = 0; n2 < n3 && !this.prevKey[n2].isNull(); ++n2) {
            if (this.prevKey[n2].compare(dataValueDescriptorArray[n2]) == 0) continue;
            this.prevKey = null;
            this.prevKey = this.clone(dataValueDescriptorArray);
            break;
        }
        int n4 = n2;
        while (n4 < n3) {
            int n5 = n4++;
            this.cardinality[n5] = this.cardinality[n5] + 1L;
        }
    }

    public long[] getCardinality() {
        return this.cardinality;
    }

    public long getRowCount() {
        return this.numRows;
    }
}

