/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.List;
import org.apache.derby.catalog.AliasInfo;
import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.RoutineAliasInfo;
import org.apache.derby.catalog.types.SynonymAliasInfo;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.UniqueSQLObjectDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.DDLConstantAction;

class CreateAliasConstantAction
extends DDLConstantAction {
    private final String aliasName;
    private final String schemaName;
    private final String javaClassName;
    private final char aliasType;
    private final char nameSpace;
    private final AliasInfo aliasInfo;

    CreateAliasConstantAction(String string, String string2, String string3, AliasInfo aliasInfo, char c2) {
        this.aliasName = string;
        this.schemaName = string2;
        this.javaClassName = string3;
        this.aliasInfo = aliasInfo;
        this.aliasType = c2;
        switch (c2) {
            case 'G': {
                this.nameSpace = (char)71;
                break;
            }
            case 'P': {
                this.nameSpace = (char)80;
                break;
            }
            case 'F': {
                this.nameSpace = (char)70;
                break;
            }
            case 'S': {
                this.nameSpace = (char)83;
                break;
            }
            case 'A': {
                this.nameSpace = (char)65;
                break;
            }
            default: {
                this.nameSpace = '\u0000';
            }
        }
    }

    public String toString() {
        String string = null;
        switch (this.aliasType) {
            case 'G': {
                string = "CREATE DERBY AGGREGATE ";
                break;
            }
            case 'P': {
                string = "CREATE PROCEDURE ";
                break;
            }
            case 'F': {
                string = "CREATE FUNCTION ";
                break;
            }
            case 'S': {
                string = "CREATE SYNONYM ";
                break;
            }
            case 'A': {
                string = "CREATE TYPE ";
                break;
            }
        }
        return string + this.aliasName;
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        dataDictionary.startWriting(languageConnectionContext);
        SchemaDescriptor schemaDescriptor = DDLConstantAction.getSchemaDescriptorForCreate(dataDictionary, activation, this.schemaName);
        UUID uUID = dataDictionary.getUUIDFactory().createUUID();
        AliasDescriptor aliasDescriptor = new AliasDescriptor(dataDictionary, uUID, this.aliasName, schemaDescriptor.getUUID(), this.javaClassName, this.aliasType, this.nameSpace, false, this.aliasInfo, null);
        switch (this.aliasType) {
            case 'G': {
                AliasDescriptor aliasDescriptor2 = dataDictionary.getAliasDescriptor(schemaDescriptor.getUUID().toString(), this.aliasName, this.nameSpace);
                if (aliasDescriptor2 != null) {
                    throw StandardException.newException("X0Y68.S", aliasDescriptor.getDescriptorType(), this.aliasName);
                }
                List<AliasDescriptor> list = dataDictionary.getRoutineList(schemaDescriptor.getUUID().toString(), this.aliasName, 'F');
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    AliasDescriptor aliasDescriptor3 = list.get(i2);
                    RoutineAliasInfo routineAliasInfo = (RoutineAliasInfo)aliasDescriptor3.getAliasInfo();
                    if (routineAliasInfo.getParameterCount() != 1) continue;
                    throw StandardException.newException("X0Y87.S", this.schemaName, this.aliasName);
                }
                break;
            }
            case 'A': {
                AliasDescriptor aliasDescriptor4 = dataDictionary.getAliasDescriptor(schemaDescriptor.getUUID().toString(), this.aliasName, this.nameSpace);
                if (aliasDescriptor4 == null) break;
                throw StandardException.newException("X0Y68.S", aliasDescriptor.getDescriptorType(), this.aliasName);
            }
            case 'P': {
                this.vetRoutine(dataDictionary, schemaDescriptor, aliasDescriptor);
                break;
            }
            case 'F': {
                AliasDescriptor aliasDescriptor5;
                this.vetRoutine(dataDictionary, schemaDescriptor, aliasDescriptor);
                int n2 = ((RoutineAliasInfo)this.aliasInfo).getParameterCount();
                if (n2 != 1 || (aliasDescriptor5 = dataDictionary.getAliasDescriptor(schemaDescriptor.getUUID().toString(), this.aliasName, 'G')) == null) break;
                throw StandardException.newException("X0Y87.S", this.schemaName, this.aliasName);
            }
            case 'S': {
                Object object;
                UniqueSQLObjectDescriptor uniqueSQLObjectDescriptor;
                SchemaDescriptor schemaDescriptor2;
                TableDescriptor tableDescriptor = dataDictionary.getTableDescriptor(this.aliasName, schemaDescriptor, transactionController);
                if (tableDescriptor != null) {
                    throw StandardException.newException("X0Y68.S", tableDescriptor.getDescriptorType(), tableDescriptor.getDescriptorName());
                }
                String string = ((SynonymAliasInfo)this.aliasInfo).getSynonymTable();
                String string2 = ((SynonymAliasInfo)this.aliasInfo).getSynonymSchema();
                while ((schemaDescriptor2 = dataDictionary.getSchemaDescriptor(string2, transactionController, false)) != null && (uniqueSQLObjectDescriptor = dataDictionary.getAliasDescriptor(schemaDescriptor2.getUUID().toString(), string, this.nameSpace)) != null) {
                    object = (SynonymAliasInfo)uniqueSQLObjectDescriptor.getAliasInfo();
                    string = ((SynonymAliasInfo)object).getSynonymTable();
                    string2 = ((SynonymAliasInfo)object).getSynonymSchema();
                    if (!this.aliasName.equals(string) || !this.schemaName.equals(string2)) continue;
                    throw StandardException.newException("42916", this.aliasName, ((SynonymAliasInfo)this.aliasInfo).getSynonymTable());
                }
                if (schemaDescriptor2 != null) {
                    tableDescriptor = dataDictionary.getTableDescriptor(string, schemaDescriptor2, transactionController);
                }
                if (schemaDescriptor2 == null || tableDescriptor == null) {
                    activation.addWarning(StandardException.newWarning("01522", this.aliasName, string2 + "." + string));
                }
                object = dataDictionary.getDataDescriptorGenerator();
                uniqueSQLObjectDescriptor = ((DataDescriptorGenerator)object).newTableDescriptor(this.aliasName, schemaDescriptor, 4, 'R');
                dataDictionary.addDescriptor(uniqueSQLObjectDescriptor, schemaDescriptor, 1, false, transactionController);
                break;
            }
        }
        dataDictionary.addDescriptor(aliasDescriptor, null, 7, false, transactionController);
        this.adjustUDTDependencies(languageConnectionContext, dataDictionary, aliasDescriptor, true);
    }

    private void vetRoutine(DataDictionary dataDictionary, SchemaDescriptor schemaDescriptor, AliasDescriptor aliasDescriptor) throws StandardException {
        List<AliasDescriptor> list = dataDictionary.getRoutineList(schemaDescriptor.getUUID().toString(), this.aliasName, this.aliasType);
        for (int i2 = list.size() - 1; i2 >= 0; --i2) {
            AliasDescriptor aliasDescriptor2 = list.get(i2);
            RoutineAliasInfo routineAliasInfo = (RoutineAliasInfo)aliasDescriptor2.getAliasInfo();
            int n2 = routineAliasInfo.getParameterCount();
            if (n2 != ((RoutineAliasInfo)this.aliasInfo).getParameterCount()) continue;
            throw StandardException.newException("X0Y68.S", aliasDescriptor.getDescriptorType(), this.aliasName);
        }
    }
}

