/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.sql.execute.RowChanger;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.impl.sql.execute.AutoincrementCounter;
import org.apache.derby.impl.sql.execute.DMLWriteResultSet;
import org.apache.derby.impl.sql.execute.InternalTriggerExecutionContext;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderImpl;
import org.apache.derby.impl.sql.execute.ValueRow;

public abstract class DMLWriteGeneratedColumnsResultSet
extends DMLWriteResultSet {
    protected DataValueDescriptor[] aiCache;
    protected String identitySequenceUUIDString;
    protected NoPutResultSet sourceResultSet;
    protected ResultSet autoGeneratedKeysResultSet;
    protected TemporaryRowHolderImpl autoGeneratedKeysRowsHolder;
    protected int[] autoGeneratedKeysColumnIndexes;
    protected boolean autoincrementGenerated;
    protected long identityVal;
    protected boolean setIdentity;

    DMLWriteGeneratedColumnsResultSet(Activation activation) throws StandardException {
        this(activation, activation.getConstantAction());
    }

    DMLWriteGeneratedColumnsResultSet(Activation activation, ConstantAction constantAction) throws StandardException {
        super(activation, constantAction);
    }

    public NumberDataValue getSetAutoincrementValue(int n2, long l2) throws StandardException {
        return null;
    }

    public void saveAIcacheInformation(String string, String string2, String[] stringArray) throws StandardException {
        if (this.aiCache != null) {
            HashMap<String, Long> hashMap = new HashMap<String, Long>();
            int n2 = this.aiCache.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (this.aiCache[i2] == null) continue;
                hashMap.put(AutoincrementCounter.makeIdentity(string, string2, stringArray[i2]), this.aiCache[i2].getLong());
            }
            InternalTriggerExecutionContext internalTriggerExecutionContext = (InternalTriggerExecutionContext)this.lcc.getTriggerExecutionContext();
            if (internalTriggerExecutionContext == null) {
                this.lcc.copyHashtableToAIHT(hashMap);
            } else {
                internalTriggerExecutionContext.copyHashtableToAIHT(hashMap);
            }
        }
        this.autoGeneratedKeysResultSet = this.activation.getAutoGeneratedKeysResultsetMode() ? this.autoGeneratedKeysRowsHolder.getResultSet() : null;
    }

    protected void verifyAutoGeneratedRScolumnsList(UUID uUID) throws StandardException {
        if (this.activation.getAutoGeneratedKeysResultsetMode()) {
            int[] nArray = this.activation.getAutoGeneratedKeysColumnIndexes();
            if (nArray != null) {
                this.verifyAutoGeneratedColumnsIndexes(nArray, uUID);
            } else {
                String[] stringArray = this.activation.getAutoGeneratedKeysColumnNames();
                if (stringArray != null) {
                    this.verifyAutoGeneratedColumnsNames(stringArray, uUID);
                }
            }
        }
    }

    private void verifyAutoGeneratedColumnsIndexes(int[] nArray, UUID uUID) throws StandardException {
        int n2 = nArray.length;
        TableDescriptor tableDescriptor = this.lcc.getDataDictionary().getTableDescriptor(uUID);
        for (int i2 = 0; i2 < n2; ++i2) {
            ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(nArray[i2]);
            if (this.verifyAutoGenColumn(columnDescriptor)) continue;
            throw StandardException.newException("X0X0E.S", nArray[i2], tableDescriptor.getName());
        }
    }

    private void verifyAutoGeneratedColumnsNames(String[] stringArray, UUID uUID) throws StandardException {
        int n2 = stringArray.length;
        int[] nArray = new int[n2];
        TableDescriptor tableDescriptor = this.lcc.getDataDictionary().getTableDescriptor(uUID);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] == null) {
                throw StandardException.newException("X0X0F.S", stringArray[i2], tableDescriptor.getName());
            }
            ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(stringArray[i2]);
            if (!this.verifyAutoGenColumn(columnDescriptor)) {
                throw StandardException.newException("X0X0F.S", stringArray[i2], tableDescriptor.getName());
            }
            nArray[i2] = columnDescriptor.getPosition();
        }
        this.activation.setAutoGeneratedKeysResultsetInfo(nArray, null);
    }

    private boolean verifyAutoGenColumn(ColumnDescriptor columnDescriptor) {
        return columnDescriptor != null && columnDescriptor.isAutoincrement();
    }

    protected void firstExecuteSpecialHandlingAutoGen(boolean bl, RowChanger rowChanger, UUID uUID) throws StandardException {
        if (bl && this.activation.getAutoGeneratedKeysResultsetMode()) {
            Properties properties = new Properties();
            this.autoGeneratedKeysColumnIndexes = this.activation.getAutoGeneratedKeysColumnIndexes();
            rowChanger.getHeapConglomerateController().getInternalTablePropertySet(properties);
            this.autoGeneratedKeysColumnIndexes = this.autoGeneratedKeysColumnIndexes != null ? this.uniqueColumnPositionArray(this.autoGeneratedKeysColumnIndexes, uUID) : this.generatedColumnPositionsArray(uUID);
            ResultDescription resultDescription = this.lcc.getLanguageFactory().getResultDescription(this.resultDescription, this.autoGeneratedKeysColumnIndexes);
            this.autoGeneratedKeysRowsHolder = new TemporaryRowHolderImpl(this.activation, properties, resultDescription);
        }
    }

    private int[] generatedColumnPositionsArray(UUID uUID) throws StandardException {
        TableDescriptor tableDescriptor = this.lcc.getDataDictionary().getTableDescriptor(uUID);
        int n2 = tableDescriptor.getMaxColumnID();
        int[] nArray = new int[n2];
        Arrays.fill(nArray, -1);
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(i2 + 1);
            if (columnDescriptor.isAutoincrement()) {
                ++n3;
                nArray[i2] = i2 + 1;
                continue;
            }
            if (columnDescriptor.getDefaultValue() == null && columnDescriptor.getDefaultInfo() == null) continue;
            ++n3;
            nArray[i2] = i2 + 1;
        }
        int[] nArray2 = new int[n3];
        int n4 = 0;
        for (int i3 = 0; i3 < n2; ++i3) {
            if (nArray[i3] == -1) continue;
            nArray2[n4++] = nArray[i3];
        }
        return nArray2;
    }

    private int[] uniqueColumnPositionArray(int[] nArray, UUID uUID) throws StandardException {
        int n2 = nArray.length;
        TableDescriptor tableDescriptor = this.lcc.getDataDictionary().getTableDescriptor(uUID);
        int[] nArray2 = new int[tableDescriptor.getMaxColumnID()];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (nArray2[nArray[i2] - 1] != 0) continue;
            ++n3;
            nArray2[nArray[i2] - 1] = nArray[i2];
        }
        int[] nArray3 = new int[n3];
        int n4 = 0;
        for (int i3 = 0; i3 < nArray2.length; ++i3) {
            if (nArray2[i3] == 0) continue;
            nArray3[n4++] = nArray2[i3];
        }
        return nArray3;
    }

    protected ExecRow getCompactRow(ExecRow execRow, int[] nArray) throws StandardException {
        int n2 = execRow.nColumns();
        if (nArray == null) {
            ValueRow valueRow = new ValueRow(n2);
            DataValueDescriptor[] dataValueDescriptorArray = execRow.getRowArray();
            DataValueDescriptor[] dataValueDescriptorArray2 = valueRow.getRowArray();
            System.arraycopy(dataValueDescriptorArray, 0, dataValueDescriptorArray2, 0, dataValueDescriptorArray.length);
            return valueRow;
        }
        int n3 = nArray.length;
        ValueRow valueRow = new ValueRow(n3);
        for (int i2 = 0; i2 < n3; ++i2) {
            valueRow.setColumn(i2 + 1, execRow.getColumn(nArray[i2]));
        }
        return valueRow;
    }

    @Override
    public ResultSet getAutoGeneratedKeysResultset() {
        return this.autoGeneratedKeysResultSet;
    }
}

