/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.BackingStoreHashtable;
import org.apache.derby.iapi.store.access.DynamicCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.FKInfo;
import org.apache.derby.impl.sql.execute.IndexRow;

public abstract class GenericRIChecker {
    protected FKInfo fkInfo;
    protected DynamicCompiledOpenConglomInfo[] fkDcocis;
    protected StaticCompiledOpenConglomInfo[] fkScocis;
    protected DynamicCompiledOpenConglomInfo refDcoci;
    protected StaticCompiledOpenConglomInfo refScoci;
    protected TransactionController tc;
    protected LanguageConnectionContext lcc;
    protected BackingStoreHashtable deferredRowsHashTable;
    private final Hashtable<Long, ScanController> scanControllers;
    protected final int numColumns;
    protected int[] identityMap;
    final IndexRow indexQualifierRow;

    GenericRIChecker(LanguageConnectionContext languageConnectionContext, TransactionController transactionController, FKInfo fKInfo) throws StandardException {
        this.lcc = languageConnectionContext;
        this.fkInfo = fKInfo;
        this.tc = transactionController;
        this.scanControllers = new Hashtable();
        this.numColumns = this.fkInfo.colArray.length;
        this.indexQualifierRow = new IndexRow(this.numColumns);
        this.fkDcocis = new DynamicCompiledOpenConglomInfo[this.fkInfo.fkConglomNumbers.length];
        this.fkScocis = new StaticCompiledOpenConglomInfo[this.fkInfo.fkConglomNumbers.length];
        for (int i2 = 0; i2 < this.fkInfo.fkConglomNumbers.length; ++i2) {
            this.fkDcocis[i2] = transactionController.getDynamicCompiledConglomInfo(this.fkInfo.fkConglomNumbers[i2]);
            this.fkScocis[i2] = transactionController.getStaticCompiledConglomInfo(this.fkInfo.fkConglomNumbers[i2]);
        }
        this.refDcoci = transactionController.getDynamicCompiledConglomInfo(this.fkInfo.refConglomNumber);
        this.refScoci = transactionController.getStaticCompiledConglomInfo(this.fkInfo.refConglomNumber);
    }

    abstract void doCheck(Activation var1, ExecRow var2, boolean var3, int var4) throws StandardException;

    protected ScanController getScanController(long l2, StaticCompiledOpenConglomInfo staticCompiledOpenConglomInfo, DynamicCompiledOpenConglomInfo dynamicCompiledOpenConglomInfo, ExecRow execRow) throws StandardException {
        int n2 = this.getRICheckIsolationLevel();
        Long l3 = l2;
        ScanController scanController = this.scanControllers.get(l3);
        if (scanController == null) {
            this.setupQualifierRow(execRow);
            scanController = this.tc.openCompiledScan(false, 0, 6, n2, null, this.indexQualifierRow.getRowArray(), 1, null, this.indexQualifierRow.getRowArray(), -1, staticCompiledOpenConglomInfo, dynamicCompiledOpenConglomInfo);
            this.scanControllers.put(l3, scanController);
        } else {
            this.setupQualifierRow(execRow);
            scanController.reopenScan(this.indexQualifierRow.getRowArray(), 1, null, this.indexQualifierRow.getRowArray(), -1);
        }
        return scanController;
    }

    private void setupQualifierRow(ExecRow execRow) {
        DataValueDescriptor[] dataValueDescriptorArray = this.indexQualifierRow.getRowArray();
        DataValueDescriptor[] dataValueDescriptorArray2 = execRow.getRowArray();
        for (int i2 = 0; i2 < this.numColumns; ++i2) {
            dataValueDescriptorArray[i2] = dataValueDescriptorArray2[this.fkInfo.colArray[i2] - 1];
        }
    }

    boolean isAnyFieldNull(ExecRow execRow) {
        DataValueDescriptor[] dataValueDescriptorArray = execRow.getRowArray();
        for (int i2 = 0; i2 < this.numColumns; ++i2) {
            DataValueDescriptor dataValueDescriptor = dataValueDescriptorArray[this.fkInfo.colArray[i2] - 1];
            if (!dataValueDescriptor.isNull()) continue;
            return true;
        }
        return false;
    }

    void close() throws StandardException {
        Enumeration<ScanController> enumeration = this.scanControllers.elements();
        while (enumeration.hasMoreElements()) {
            ScanController scanController = enumeration.nextElement();
            scanController.close();
        }
        this.scanControllers.clear();
    }

    int getRICheckIsolationLevel() {
        return 3;
    }
}

