/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.BackingStoreHashtable;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.GroupFetchScanController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.DeferredConstraintsMemory;

public class RIBulkChecker {
    private static final int EQUAL = 0;
    private static final int GREATER_THAN = 1;
    private static final int LESS_THAN = -1;
    private final long fkCID;
    private final long pkCID;
    private final String schemaName;
    private final String tableName;
    private final UUID constraintId;
    private BackingStoreHashtable deferredRowsHashTable;
    private final LanguageConnectionContext lcc;
    private final boolean deferred;
    private GroupFetchScanController referencedKeyScan;
    private DataValueDescriptor[][] referencedKeyRowArray;
    private GroupFetchScanController foreignKeyScan;
    private DataValueDescriptor[][] foreignKeyRowArray;
    private ConglomerateController unreferencedCC;
    private int failedCounter;
    private boolean quitOnFirstFailure;
    private int numColumns;
    private int currRefRowIndex;
    private int currFKRowIndex;
    private int lastRefRowIndex;
    private int lastFKRowIndex;
    private ExecRow firstRowToFail;

    public RIBulkChecker(Activation activation, GroupFetchScanController groupFetchScanController, GroupFetchScanController groupFetchScanController2, ExecRow execRow, boolean bl, ConglomerateController conglomerateController, ExecRow execRow2, String string, String string2, UUID uUID, boolean bl2, long l2, long l3) throws StandardException {
        this.referencedKeyScan = groupFetchScanController;
        this.foreignKeyScan = groupFetchScanController2;
        this.quitOnFirstFailure = bl;
        this.unreferencedCC = conglomerateController;
        this.firstRowToFail = execRow2;
        this.constraintId = uUID;
        this.fkCID = l2;
        this.pkCID = l3;
        this.schemaName = string;
        this.tableName = string2;
        this.foreignKeyRowArray = new DataValueDescriptor[16][];
        this.foreignKeyRowArray[0] = execRow.getRowArrayClone();
        this.referencedKeyRowArray = new DataValueDescriptor[16][];
        this.referencedKeyRowArray[0] = execRow.getRowArrayClone();
        this.failedCounter = 0;
        this.numColumns = execRow.getRowArray().length - 1;
        this.currFKRowIndex = -1;
        this.currRefRowIndex = -1;
        this.lcc = activation.getLanguageConnectionContext();
        this.deferred = bl2 && this.lcc.isEffectivelyDeferred(this.lcc.getCurrentSQLSessionContext(activation), uUID);
    }

    public int doCheck() throws StandardException {
        DataValueDescriptor[] dataValueDescriptorArray;
        DataValueDescriptor[] dataValueDescriptorArray2 = this.getNextRef();
        while ((dataValueDescriptorArray = this.getNextFK()) != null) {
            int n2;
            if (!this.anyNull(dataValueDescriptorArray) && dataValueDescriptorArray2 == null) {
                do {
                    this.failure(dataValueDescriptorArray);
                    if (!this.quitOnFirstFailure) continue;
                    return this.failedCounter;
                } while ((dataValueDescriptorArray = this.getNextFK()) != null);
                return this.failedCounter;
            }
            while ((n2 = this.greaterThan(dataValueDescriptorArray, dataValueDescriptorArray2)) == 1) {
                dataValueDescriptorArray2 = this.getNextRef();
                if (dataValueDescriptorArray2 != null) continue;
                do {
                    this.failure(dataValueDescriptorArray);
                    if (!this.quitOnFirstFailure) continue;
                    return this.failedCounter;
                } while ((dataValueDescriptorArray = this.getNextFK()) != null);
                return this.failedCounter;
            }
            if (n2 == 0) continue;
            this.failure(dataValueDescriptorArray);
            if (!this.quitOnFirstFailure) continue;
            return this.failedCounter;
        }
        return this.failedCounter;
    }

    private DataValueDescriptor[] getNextFK() throws StandardException {
        if (this.currFKRowIndex > this.lastFKRowIndex || this.currFKRowIndex == -1) {
            int n2 = this.foreignKeyScan.fetchNextGroup(this.foreignKeyRowArray, null);
            if (n2 == 0) {
                this.currFKRowIndex = -1;
                return null;
            }
            this.lastFKRowIndex = n2 - 1;
            this.currFKRowIndex = 0;
        }
        return this.foreignKeyRowArray[this.currFKRowIndex++];
    }

    private DataValueDescriptor[] getNextRef() throws StandardException {
        if (this.currRefRowIndex > this.lastRefRowIndex || this.currRefRowIndex == -1) {
            int n2 = this.referencedKeyScan.fetchNextGroup(this.referencedKeyRowArray, null);
            if (n2 == 0) {
                this.currRefRowIndex = -1;
                return null;
            }
            this.lastRefRowIndex = n2 - 1;
            this.currRefRowIndex = 0;
        }
        return this.referencedKeyRowArray[this.currRefRowIndex++];
    }

    private void failure(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        if (this.deferred) {
            this.deferredRowsHashTable = DeferredConstraintsMemory.rememberFKViolation(this.lcc, this.deferredRowsHashTable, this.constraintId, dataValueDescriptorArray, this.schemaName, this.tableName);
        } else {
            if (this.failedCounter == 0 && this.firstRowToFail != null) {
                this.firstRowToFail.setRowArray(dataValueDescriptorArray);
                this.firstRowToFail.setRowArray(this.firstRowToFail.getRowArrayClone());
            }
            ++this.failedCounter;
            if (this.unreferencedCC != null) {
                this.unreferencedCC.insert(dataValueDescriptorArray);
            }
        }
    }

    private boolean anyNull(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        for (int i2 = 0; i2 < this.numColumns; ++i2) {
            DataValueDescriptor dataValueDescriptor = dataValueDescriptorArray[i2];
            if (!dataValueDescriptor.isNull()) continue;
            return true;
        }
        return false;
    }

    private int greaterThan(DataValueDescriptor[] dataValueDescriptorArray, DataValueDescriptor[] dataValueDescriptorArray2) throws StandardException {
        if (this.anyNull(dataValueDescriptorArray)) {
            return 0;
        }
        for (int i2 = 0; i2 < this.numColumns; ++i2) {
            DataValueDescriptor dataValueDescriptor = dataValueDescriptorArray[i2];
            DataValueDescriptor dataValueDescriptor2 = dataValueDescriptorArray2[i2];
            int n2 = dataValueDescriptor.compare(dataValueDescriptor2);
            if (n2 > 0) {
                return 1;
            }
            if (n2 >= 0) continue;
            return -1;
        }
        return 0;
    }
}

