/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.GenericAggregateResultSet;
import org.apache.derby.impl.sql.execute.GenericAggregator;

class ScalarAggregateResultSet
extends GenericAggregateResultSet
implements CursorResultSet {
    public int rowsInput;
    public boolean singleInputRow;
    protected boolean isInSortedOrder;
    protected ExecIndexRow sourceExecIndexRow;
    private boolean nextSatisfied;
    protected int countOfRows;

    ScalarAggregateResultSet(NoPutResultSet noPutResultSet, boolean bl, int n2, Activation activation, int n3, int n4, boolean bl2, double d2, double d3) throws StandardException {
        super(noPutResultSet, n2, activation, n3, n4, d2, d3);
        this.isInSortedOrder = bl;
        this.singleInputRow = bl2;
        this.recordConstructorTime();
    }

    @Override
    public void openCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        this.sourceExecIndexRow = (ExecIndexRow)this.getRowTemplate().getClone();
        this.source.openCore();
        this.isOpen = true;
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (this.isXplainOnlyMode()) {
            return null;
        }
        if (this.nextSatisfied) {
            this.clearCurrentRow();
            return null;
        }
        ExecIndexRow execIndexRow = null;
        ExecIndexRow execIndexRow2 = null;
        boolean bl = this.singleInputRow && this.aggregates[0].getAggregatorInfo().aggregateName.equals("MIN");
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            while ((execIndexRow = this.getRowFromResultSet(false)) != null) {
                if (execIndexRow2 == null) {
                    execIndexRow2 = this.singleInputRow && bl ? execIndexRow : (ExecIndexRow)execIndexRow.getClone();
                    this.initializeScalarAggregation(execIndexRow2);
                } else {
                    this.accumulateScalarAggregation(execIndexRow, execIndexRow2, false);
                }
                if (!this.singleInputRow || !bl && execIndexRow2.getColumn(this.aggregates[0].aggregatorColumnId).isNull()) continue;
            }
            if (this.countOfRows == 0) {
                execIndexRow2 = this.finishAggregation(execIndexRow2);
                this.setCurrentRow(execIndexRow2);
                ++this.countOfRows;
            }
        }
        this.nextSatisfied = true;
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return execIndexRow2;
    }

    @Override
    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.clearCurrentRow();
            this.countOfRows = 0;
            this.sourceExecIndexRow = null;
            this.source.close();
            super.close();
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
        this.nextSatisfied = false;
        this.isOpen = false;
    }

    @Override
    public long getTimeSpent(int n2) {
        long l2 = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (n2 == 0) {
            return l2 - this.originalSource.getTimeSpent(1);
        }
        return l2;
    }

    @Override
    public RowLocation getRowLocation() throws StandardException {
        return null;
    }

    @Override
    public ExecRow getCurrentRow() throws StandardException {
        return this.currentRow;
    }

    public ExecIndexRow getRowFromResultSet(boolean bl) throws StandardException {
        ExecIndexRow execIndexRow = null;
        ExecRow execRow = this.source.getNextRowCore();
        if (execRow != null) {
            ++this.rowsInput;
            this.sourceExecIndexRow.execRowToExecIndexRow(bl ? execRow.getClone() : execRow);
            execIndexRow = this.sourceExecIndexRow;
        }
        return execIndexRow;
    }

    @Override
    public void reopenCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        this.source.reopenCore();
        ++this.numOpens;
        this.countOfRows = 0;
        this.nextSatisfied = false;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    protected void accumulateScalarAggregation(ExecRow execRow, ExecRow execRow2, boolean bl) throws StandardException {
        for (GenericAggregator genericAggregator : this.aggregates) {
            if (bl && !genericAggregator.getAggregatorInfo().isDistinct()) {
                genericAggregator.merge(execRow, execRow2);
                continue;
            }
            genericAggregator.accumulate(execRow, execRow2);
        }
    }

    private void initializeScalarAggregation(ExecRow execRow) throws StandardException {
        for (GenericAggregator genericAggregator : this.aggregates) {
            genericAggregator.initialize(execRow);
            genericAggregator.accumulate(execRow, execRow);
        }
    }
}

