/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.sql.execute.RowChanger;
import org.apache.derby.iapi.store.access.BackingStoreHashtable;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.SQLBoolean;
import org.apache.derby.iapi.types.SQLInteger;
import org.apache.derby.impl.sql.execute.CursorActivation;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;
import org.apache.derby.impl.sql.execute.ProjectRestrictResultSet;
import org.apache.derby.impl.sql.execute.RowCountResultSet;
import org.apache.derby.impl.sql.execute.ValueRow;

public class ScrollInsensitiveResultSet
extends NoPutResultSetImpl
implements CursorResultSet {
    public NoPutResultSet source;
    private int sourceRowWidth;
    private BackingStoreHashtable ht;
    private ExecRow resultRow;
    private int positionInSource;
    private int currentPosition;
    private int lastPosition;
    private boolean seenFirst;
    private boolean seenLast;
    private boolean beforeFirst = true;
    private boolean afterLast;
    public int numFromHashTable;
    public int numToHashTable;
    private long maxRows;
    private boolean keepAfterCommit;
    private int extraColumns;
    private SQLInteger positionInHashTable;
    private CursorResultSet target;
    private boolean needsRepositioning;
    private static final int POS_ROWLOCATION = 1;
    private static final int POS_ROWDELETED = 2;
    private static final int POS_ROWUPDATED = 3;
    private static final int LAST_EXTRA_COLUMN = 3;

    public ScrollInsensitiveResultSet(NoPutResultSet noPutResultSet, Activation activation, int n2, int n3, double d2, double d3) throws StandardException {
        super(activation, n2, d2, d3);
        this.source = noPutResultSet;
        this.sourceRowWidth = n3;
        this.keepAfterCommit = activation.getResultSetHoldability();
        this.maxRows = activation.getMaxRows();
        this.positionInHashTable = new SQLInteger();
        this.needsRepositioning = false;
        if (this.isForUpdate()) {
            this.target = ((CursorActivation)activation).getTargetResultSet();
            this.extraColumns = 4;
        } else {
            this.target = null;
            this.extraColumns = 1;
        }
        this.recordConstructorTime();
    }

    @Override
    public void openCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        this.source.openCore();
        this.isOpen = true;
        ++this.numOpens;
        int[] nArray = new int[]{0};
        this.ht = new BackingStoreHashtable(this.getTransactionController(), null, nArray, false, -1L, -1L, -1, -1.0f, false, this.keepAfterCommit);
        this.lastPosition = 0;
        this.needsRepositioning = false;
        this.numFromHashTable = 0;
        this.numToHashTable = 0;
        this.positionInSource = 0;
        this.seenFirst = false;
        this.seenLast = false;
        this.maxRows = this.activation.getMaxRows();
        this.openTime += this.getElapsedMillis(this.beginTime);
        this.setBeforeFirstRow();
    }

    @Override
    public void reopenCore() throws StandardException {
        boolean bl = true;
        this.beginTime = this.getCurrentTimeMillis();
        this.setBeforeFirstRow();
    }

    @Override
    public ExecRow getAbsoluteRow(int n2) throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S", "absolute");
        }
        this.attachStatementContext();
        if (n2 == 0) {
            this.setBeforeFirstRow();
            return null;
        }
        if (this.seenLast && n2 > this.lastPosition) {
            return this.setAfterLastRow();
        }
        if (n2 > 0) {
            if (n2 <= this.positionInSource) {
                return this.getRowFromHashTable(n2);
            }
            ExecRow execRow = null;
            for (int i2 = n2 - this.positionInSource; i2 > 0 && (execRow = this.getNextRowFromSource()) != null; --i2) {
            }
            if (execRow != null) {
                execRow = this.getRowFromHashTable(n2);
            }
            this.currentRow = execRow;
            return execRow;
        }
        if (n2 < 0) {
            int n3;
            if (!this.seenLast) {
                this.getLastRow();
            }
            if ((n3 = this.lastPosition + 1) + n2 > 0) {
                return this.getRowFromHashTable(n3 + n2);
            }
            return this.setBeforeFirstRow();
        }
        this.currentRow = null;
        return null;
    }

    @Override
    public ExecRow getRelativeRow(int n2) throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S", "relative");
        }
        this.attachStatementContext();
        if (n2 == 0) {
            if (this.beforeFirst || this.afterLast || this.currentPosition == 0) {
                return null;
            }
            return this.getRowFromHashTable(this.currentPosition);
        }
        if (n2 > 0) {
            return this.getAbsoluteRow(this.currentPosition + n2);
        }
        if (this.currentPosition + n2 < 0) {
            return this.setBeforeFirstRow();
        }
        return this.getAbsoluteRow(this.currentPosition + n2);
    }

    @Override
    public ExecRow setBeforeFirstRow() {
        this.currentPosition = 0;
        this.beforeFirst = true;
        this.afterLast = false;
        this.currentRow = null;
        return null;
    }

    @Override
    public ExecRow getFirstRow() throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S", "first");
        }
        if (this.seenFirst) {
            return this.getRowFromHashTable(1);
        }
        this.attachStatementContext();
        return this.getNextRowCore();
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (this.isXplainOnlyMode()) {
            return null;
        }
        ExecRow execRow = null;
        this.beginTime = this.getCurrentTimeMillis();
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S", "next");
        }
        if (this.seenLast && this.currentPosition == this.lastPosition) {
            return this.setAfterLastRow();
        }
        if (this.currentPosition == this.positionInSource) {
            execRow = this.getNextRowFromSource();
            if (execRow != null) {
                execRow = this.getRowFromHashTable(this.currentPosition);
            }
        } else {
            execRow = this.currentPosition < this.positionInSource ? this.getRowFromHashTable(this.currentPosition + 1) : null;
        }
        if (execRow != null) {
            ++this.rowsSeen;
            this.afterLast = false;
        }
        this.setCurrentRow(execRow);
        this.beforeFirst = false;
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return execRow;
    }

    @Override
    public ExecRow getPreviousRow() throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S", "previous");
        }
        if (this.beforeFirst || this.currentPosition == 0) {
            this.currentRow = null;
            return null;
        }
        if (this.afterLast) {
            if (this.lastPosition == 0) {
                this.afterLast = false;
                this.beforeFirst = false;
                this.currentRow = null;
                return null;
            }
            return this.getRowFromHashTable(this.lastPosition);
        }
        --this.currentPosition;
        if (this.currentPosition == 0) {
            this.setBeforeFirstRow();
            return null;
        }
        return this.getRowFromHashTable(this.currentPosition);
    }

    @Override
    public ExecRow getLastRow() throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S", "next");
        }
        if (!this.seenLast) {
            this.attachStatementContext();
            ExecRow execRow = null;
            while ((execRow = this.getNextRowFromSource()) != null) {
            }
        }
        this.beforeFirst = false;
        this.afterLast = false;
        if (this.lastPosition == 0) {
            this.currentRow = null;
            return null;
        }
        return this.getRowFromHashTable(this.lastPosition);
    }

    @Override
    public ExecRow setAfterLastRow() throws StandardException {
        if (!this.seenLast) {
            this.getLastRow();
        }
        if (this.lastPosition == 0) {
            this.currentPosition = 0;
            this.afterLast = false;
        } else {
            this.currentPosition = this.lastPosition + 1;
            this.afterLast = true;
        }
        this.beforeFirst = false;
        this.currentRow = null;
        return null;
    }

    @Override
    public boolean checkRowPosition(int n2) throws StandardException {
        switch (n2) {
            case 101: {
                if (!this.beforeFirst) {
                    return false;
                }
                if (this.seenFirst) {
                    return true;
                }
                ExecRow execRow = this.getFirstRow();
                if (execRow == null) {
                    return false;
                }
                this.getPreviousRow();
                return true;
            }
            case 102: {
                return this.currentPosition == 1;
            }
            case 103: {
                if (this.beforeFirst || this.afterLast || this.currentPosition == 0 || this.currentPosition < this.positionInSource) {
                    return false;
                }
                if (this.seenLast) {
                    return this.currentPosition == this.lastPosition;
                }
                int n3 = this.currentPosition;
                boolean bl = this.getNextRowFromSource() == null;
                this.getRowFromHashTable(n3);
                return bl;
            }
            case 104: {
                return this.afterLast;
            }
        }
        return false;
    }

    @Override
    public int getRowNumber() {
        return this.currentRow == null ? 0 : this.currentPosition;
    }

    private ExecRow getNextRowFromSource() throws StandardException {
        ExecRow execRow = null;
        Object var2_2 = null;
        if (this.maxRows > 0L && this.maxRows == (long)this.positionInSource) {
            this.seenLast = true;
            this.lastPosition = this.positionInSource;
            this.afterLast = true;
            return null;
        }
        if (this.needsRepositioning) {
            this.positionInLastFetchedRow();
            this.needsRepositioning = false;
        }
        if ((execRow = this.source.getNextRowCore()) != null) {
            this.seenFirst = true;
            this.beforeFirst = false;
            long l2 = this.getCurrentTimeMillis();
            if (this.resultRow == null) {
                this.resultRow = this.activation.getExecutionFactory().getValueRow(this.sourceRowWidth);
            }
            ++this.positionInSource;
            this.currentPosition = this.positionInSource;
            RowLocation rowLocation = null;
            if (this.source.isForUpdate()) {
                rowLocation = ((CursorResultSet)((Object)this.source)).getRowLocation();
            }
            this.addRowToHashTable(execRow, this.currentPosition, rowLocation, false);
        } else {
            if (!this.seenLast) {
                this.lastPosition = this.positionInSource;
            }
            this.seenLast = true;
            if (this.positionInSource == 0) {
                this.afterLast = false;
            } else {
                this.afterLast = true;
                this.currentPosition = this.positionInSource + 1;
            }
        }
        return execRow;
    }

    @Override
    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.currentRow = null;
            this.source.close();
            if (this.ht != null) {
                this.ht.close();
                this.ht = null;
            }
            super.close();
        }
        this.setBeforeFirstRow();
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public void finish() throws StandardException {
        this.source.finish();
        this.finishAndRTS();
    }

    @Override
    public long getTimeSpent(int n2) {
        long l2 = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (n2 == 0) {
            return l2 - this.source.getTimeSpent(1);
        }
        return l2;
    }

    @Override
    public RowLocation getRowLocation() throws StandardException {
        return ((CursorResultSet)((Object)this.source)).getRowLocation();
    }

    @Override
    public ExecRow getCurrentRow() throws StandardException {
        if (this.isForUpdate() && this.isDeleted()) {
            return null;
        }
        return this.currentRow;
    }

    private void addRowToHashTable(ExecRow execRow, int n2, RowLocation rowLocation, boolean bl) throws StandardException {
        DataValueDescriptor[] dataValueDescriptorArray = new DataValueDescriptor[this.sourceRowWidth + this.extraColumns];
        dataValueDescriptorArray[0] = new SQLInteger(n2);
        if (this.isForUpdate()) {
            dataValueDescriptorArray[1] = rowLocation.cloneValue(false);
            dataValueDescriptorArray[2] = new SQLBoolean(false);
            dataValueDescriptorArray[3] = new SQLBoolean(bl);
        }
        DataValueDescriptor[] dataValueDescriptorArray2 = execRow.getRowArray();
        System.arraycopy(dataValueDescriptorArray2, 0, dataValueDescriptorArray, this.extraColumns, dataValueDescriptorArray2.length);
        this.ht.putRow(true, dataValueDescriptorArray, null);
        ++this.numToHashTable;
    }

    private ExecRow getRowFromHashTable(int n2) throws StandardException {
        this.positionInHashTable.setValue(n2);
        DataValueDescriptor[] dataValueDescriptorArray = this.getCurrentRowFromHashtable();
        DataValueDescriptor[] dataValueDescriptorArray2 = new DataValueDescriptor[dataValueDescriptorArray.length - this.extraColumns];
        System.arraycopy(dataValueDescriptorArray, this.extraColumns, dataValueDescriptorArray2, 0, dataValueDescriptorArray2.length);
        this.resultRow.setRowArray(dataValueDescriptorArray2);
        this.currentPosition = n2;
        ++this.numFromHashTable;
        if (this.resultRow != null) {
            this.beforeFirst = false;
            this.afterLast = false;
        }
        if (this.isForUpdate()) {
            RowLocation rowLocation = (RowLocation)dataValueDescriptorArray[1];
            ((NoPutResultSet)((Object)this.target)).setCurrentRow(this.resultRow);
            ((NoPutResultSet)((Object)this.target)).positionScanAtRowLocation(rowLocation);
            this.needsRepositioning = true;
        }
        this.setCurrentRow(this.resultRow);
        return this.resultRow;
    }

    private DataValueDescriptor[] getRowArrayFromHashTable(int n2) throws StandardException {
        this.positionInHashTable.setValue(n2);
        DataValueDescriptor[] dataValueDescriptorArray = this.getCurrentRowFromHashtable();
        DataValueDescriptor[] dataValueDescriptorArray2 = new DataValueDescriptor[dataValueDescriptorArray.length - this.extraColumns];
        System.arraycopy(dataValueDescriptorArray, this.extraColumns, dataValueDescriptorArray2, 0, dataValueDescriptorArray2.length);
        return dataValueDescriptorArray2;
    }

    private void positionInLastFetchedRow() throws StandardException {
        if (this.positionInSource > 0) {
            this.positionInHashTable.setValue(this.positionInSource);
            DataValueDescriptor[] dataValueDescriptorArray = this.getCurrentRowFromHashtable();
            RowLocation rowLocation = (RowLocation)dataValueDescriptorArray[1];
            ((NoPutResultSet)((Object)this.target)).positionScanAtRowLocation(rowLocation);
            this.currentPosition = this.positionInSource;
        }
    }

    @Override
    public void updateRow(ExecRow execRow, RowChanger rowChanger) throws StandardException {
        int n2;
        int n3;
        int[] nArray;
        ProjectRestrictResultSet projectRestrictResultSet = null;
        if (this.source instanceof ProjectRestrictResultSet) {
            projectRestrictResultSet = (ProjectRestrictResultSet)this.source;
        } else if (this.source instanceof RowCountResultSet) {
            projectRestrictResultSet = ((RowCountResultSet)this.source).getUnderlyingProjectRestrictRS();
        }
        this.positionInHashTable.setValue(this.currentPosition);
        DataValueDescriptor[] dataValueDescriptorArray = this.getCurrentRowFromHashtable();
        RowLocation rowLocation = (RowLocation)dataValueDescriptorArray[1];
        if (projectRestrictResultSet != null) {
            nArray = projectRestrictResultSet.getBaseProjectMapping();
        } else {
            int n4 = dataValueDescriptorArray.length - 4;
            nArray = new int[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                nArray[n3] = n3 + 1;
            }
        }
        ValueRow valueRow = new ValueRow(nArray.length);
        for (n3 = 0; n3 < nArray.length; ++n3) {
            n2 = rowChanger.findSelectedCol(nArray[n3]);
            if (n2 > 0) {
                valueRow.setColumn(n3 + 1, execRow.getColumn(n2));
                continue;
            }
            valueRow.setColumn(n3 + 1, dataValueDescriptorArray[4 + n3]);
        }
        this.ht.remove(new SQLInteger(this.currentPosition));
        this.addRowToHashTable(valueRow, this.currentPosition, rowLocation, true);
        DataValueDescriptor[] dataValueDescriptorArray2 = this.getRowArrayFromHashTable(this.currentPosition);
        for (n2 = 0; n2 < nArray.length; ++n2) {
            int n5 = rowChanger.findSelectedCol(nArray[n2]);
            if (n5 <= 0) continue;
            execRow.setColumn(n5, dataValueDescriptorArray2[n2]);
        }
    }

    @Override
    public void markRowAsDeleted() throws StandardException {
        this.positionInHashTable.setValue(this.currentPosition);
        DataValueDescriptor[] dataValueDescriptorArray = this.getCurrentRowFromHashtable();
        RowLocation rowLocation = (RowLocation)dataValueDescriptorArray[1];
        this.ht.remove(new SQLInteger(this.currentPosition));
        ((SQLBoolean)dataValueDescriptorArray[2]).setValue(true);
        for (int i2 = this.extraColumns; i2 < dataValueDescriptorArray.length; ++i2) {
            dataValueDescriptorArray[i2].setToNull();
        }
        this.ht.putRow(true, dataValueDescriptorArray, null);
    }

    public boolean isDeleted() throws StandardException {
        if (this.currentPosition <= this.positionInSource && this.currentPosition > 0) {
            this.positionInHashTable.setValue(this.currentPosition);
            DataValueDescriptor[] dataValueDescriptorArray = this.getCurrentRowFromHashtable();
            return dataValueDescriptorArray[2].getBoolean();
        }
        return false;
    }

    public boolean isUpdated() throws StandardException {
        if (this.currentPosition <= this.positionInSource && this.currentPosition > 0) {
            this.positionInHashTable.setValue(this.currentPosition);
            DataValueDescriptor[] dataValueDescriptorArray = this.getCurrentRowFromHashtable();
            return dataValueDescriptorArray[3].getBoolean();
        }
        return false;
    }

    @Override
    public boolean isForUpdate() {
        return this.source.isForUpdate();
    }

    private DataValueDescriptor[] getCurrentRowFromHashtable() throws StandardException {
        return this.unpackHashValue(this.ht.get(this.positionInHashTable));
    }
}

