/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.Storable;
import org.apache.derby.iapi.services.locks.CompatibilitySpace;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.BackingStoreHashtable;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.DatabaseInstant;
import org.apache.derby.iapi.store.access.DynamicCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.FileResource;
import org.apache.derby.iapi.store.access.GroupFetchScanController;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.RowLocationRetRowSource;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.SortController;
import org.apache.derby.iapi.store.access.SortCostController;
import org.apache.derby.iapi.store.access.SortObserver;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.StoreCostController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.store.access.XATransactionController;
import org.apache.derby.iapi.store.access.conglomerate.Conglomerate;
import org.apache.derby.iapi.store.access.conglomerate.ConglomerateFactory;
import org.apache.derby.iapi.store.access.conglomerate.MethodFactory;
import org.apache.derby.iapi.store.access.conglomerate.ScanControllerRowSource;
import org.apache.derby.iapi.store.access.conglomerate.ScanManager;
import org.apache.derby.iapi.store.access.conglomerate.Sort;
import org.apache.derby.iapi.store.access.conglomerate.SortFactory;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.Loggable;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.store.access.BackingStoreHashTableFromScan;
import org.apache.derby.impl.store.access.RAMAccessManager;
import org.apache.derby.impl.store.access.RAMTransactionContext;
import org.apache.derby.impl.store.access.conglomerate.ConglomerateUtil;

public class RAMTransaction
implements XATransactionController,
TransactionManager {
    protected Transaction rawtran;
    protected RAMAccessManager accessmanager;
    protected RAMTransactionContext context;
    protected RAMTransaction parent_tran;
    private ArrayList<ScanManager> scanControllers;
    private ArrayList<ConglomerateController> conglomerateControllers;
    private ArrayList<Sort> sorts;
    private ArrayList<SortController> sortControllers;
    private ArrayList<Integer> freeSortIds;
    protected HashMap<Long, Conglomerate> tempCongloms;
    private long nextTempConglomId = -1L;
    private boolean alterTableCallMade = false;
    private int transaction_lock_level;

    private final void init(RAMAccessManager rAMAccessManager, Transaction transaction, RAMTransaction rAMTransaction) {
        this.rawtran = transaction;
        this.parent_tran = rAMTransaction;
        this.accessmanager = rAMAccessManager;
        this.scanControllers = new ArrayList();
        this.conglomerateControllers = new ArrayList();
        this.sorts = null;
        this.freeSortIds = null;
        this.sortControllers = null;
        this.tempCongloms = rAMTransaction != null ? rAMTransaction.tempCongloms : null;
    }

    protected RAMTransaction(RAMAccessManager rAMAccessManager, Transaction transaction, RAMTransaction rAMTransaction) throws StandardException {
        this.init(rAMAccessManager, transaction, rAMTransaction);
    }

    RAMTransaction(RAMAccessManager rAMAccessManager, RAMTransaction rAMTransaction, int n2, byte[] byArray, byte[] byArray2) throws StandardException {
        this.init(rAMAccessManager, rAMTransaction.getRawStoreXact(), null);
        this.context = rAMTransaction.context;
        this.context.setTransaction(this);
        this.rawtran.createXATransactionFromLocalTransaction(n2, byArray, byArray2);
        rAMTransaction.rawtran = null;
    }

    RAMTransaction() {
    }

    protected void closeControllers(boolean bl) throws StandardException {
        Object object;
        int n2;
        if (!this.scanControllers.isEmpty()) {
            for (n2 = this.scanControllers.size() - 1; n2 >= 0; --n2) {
                object = this.scanControllers.get(n2);
                if (!object.closeForEndTransaction(bl)) continue;
            }
            if (bl) {
                this.scanControllers.clear();
            }
        }
        if (!this.conglomerateControllers.isEmpty()) {
            for (n2 = this.conglomerateControllers.size() - 1; n2 >= 0; --n2) {
                object = this.conglomerateControllers.get(n2);
                if (!object.closeForEndTransaction(bl)) continue;
            }
            if (bl) {
                this.conglomerateControllers.clear();
            }
        }
        if (this.sortControllers != null && !this.sortControllers.isEmpty() && bl) {
            for (n2 = this.sortControllers.size() - 1; n2 >= 0; --n2) {
                object = this.sortControllers.get(n2);
                object.completedInserts();
            }
            this.sortControllers.clear();
        }
        if (this.sorts != null && !this.sorts.isEmpty() && bl) {
            for (n2 = this.sorts.size() - 1; n2 >= 0; --n2) {
                object = this.sorts.get(n2);
                if (object == null) continue;
                object.drop(this);
            }
            this.sorts.clear();
            this.freeSortIds.clear();
        }
    }

    private LockingPolicy determine_locking_policy(int n2, int n3) {
        LockingPolicy lockingPolicy = this.accessmanager.getSystemLockLevel() == 7 || n2 == 7 ? this.accessmanager.table_level_policy[n3] : this.accessmanager.record_level_policy[n3];
        return lockingPolicy;
    }

    private int determine_lock_level(int n2) {
        int n3 = this.accessmanager.getSystemLockLevel() == 7 || n2 == 7 ? 7 : 6;
        return n3;
    }

    private Conglomerate findExistingConglomerate(long l2) throws StandardException {
        Conglomerate conglomerate = this.findConglomerate(l2);
        if (conglomerate == null) {
            throw StandardException.newException("XSAI2.S", l2);
        }
        return conglomerate;
    }

    private Conglomerate findConglomerate(long l2) throws StandardException {
        Conglomerate conglomerate = null;
        if (l2 >= 0L) {
            conglomerate = this.accessmanager.conglomCacheFind(l2);
        } else if (this.tempCongloms != null) {
            conglomerate = this.tempCongloms.get(l2);
        }
        return conglomerate;
    }

    void setContext(RAMTransactionContext rAMTransactionContext) {
        this.context = rAMTransactionContext;
    }

    private ConglomerateController openConglomerate(Conglomerate conglomerate, boolean bl, int n2, int n3, int n4, StaticCompiledOpenConglomInfo staticCompiledOpenConglomInfo, DynamicCompiledOpenConglomInfo dynamicCompiledOpenConglomInfo) throws StandardException {
        ConglomerateController conglomerateController = conglomerate.open(this, this.rawtran, bl, n2, this.determine_lock_level(n3), this.determine_locking_policy(n3, n4), staticCompiledOpenConglomInfo, dynamicCompiledOpenConglomInfo);
        this.conglomerateControllers.add(conglomerateController);
        return conglomerateController;
    }

    private ScanController openScan(Conglomerate conglomerate, boolean bl, int n2, int n3, int n4, FormatableBitSet formatableBitSet, DataValueDescriptor[] dataValueDescriptorArray, int n5, Qualifier[][] qualifierArray, DataValueDescriptor[] dataValueDescriptorArray2, int n6, StaticCompiledOpenConglomInfo staticCompiledOpenConglomInfo, DynamicCompiledOpenConglomInfo dynamicCompiledOpenConglomInfo) throws StandardException {
        ScanManager scanManager = conglomerate.openScan(this, this.rawtran, bl, n2, this.determine_lock_level(n3), this.determine_locking_policy(n3, n4), n4, formatableBitSet, dataValueDescriptorArray, n5, qualifierArray, dataValueDescriptorArray2, n6, staticCompiledOpenConglomInfo, dynamicCompiledOpenConglomInfo);
        this.scanControllers.add(scanManager);
        return scanManager;
    }

    protected void invalidateConglomerateCache() throws StandardException {
        if (this.alterTableCallMade) {
            this.accessmanager.conglomCacheInvalidate();
            this.alterTableCallMade = false;
        }
    }

    @Override
    public void addColumnToConglomerate(long l2, int n2, Storable storable, int n3) throws StandardException {
        boolean bl = l2 < 0L;
        Conglomerate conglomerate = this.findConglomerate(l2);
        if (conglomerate == null) {
            throw StandardException.newException("XSAM2.S", l2);
        }
        ConglomerateController conglomerateController = conglomerate.open(this, this.rawtran, false, 4, 7, this.accessmanager.table_level_policy[5], null, null);
        conglomerate.addColumn(this, n2, storable, n3);
        if (!bl) {
            this.alterTableCallMade = true;
        }
        conglomerateController.close();
    }

    @Override
    public StaticCompiledOpenConglomInfo getStaticCompiledConglomInfo(long l2) throws StandardException {
        return this.findExistingConglomerate(l2).getStaticCompiledConglomInfo(this, l2);
    }

    @Override
    public DynamicCompiledOpenConglomInfo getDynamicCompiledConglomInfo(long l2) throws StandardException {
        return this.findExistingConglomerate(l2).getDynamicCompiledConglomInfo();
    }

    private final int countCreatedSorts() {
        int n2 = 0;
        if (this.sorts != null) {
            for (int i2 = 0; i2 < this.sorts.size(); ++i2) {
                if (this.sorts.get(i2) == null) continue;
                ++n2;
            }
        }
        return n2;
    }

    @Override
    public int countOpens(int n2) throws StandardException {
        int n3 = -1;
        switch (n2) {
            case 1: {
                n3 = this.conglomerateControllers.size();
                break;
            }
            case 2: {
                n3 = this.scanControllers.size();
                break;
            }
            case 3: {
                n3 = this.countCreatedSorts();
                break;
            }
            case 4: {
                n3 = this.sortControllers != null ? this.sortControllers.size() : 0;
                break;
            }
            case 5: {
                n3 = this.conglomerateControllers.size() + this.scanControllers.size() + (this.sortControllers != null ? this.sortControllers.size() : 0) + this.countCreatedSorts();
            }
        }
        return n3;
    }

    @Override
    public long createConglomerate(String string, DataValueDescriptor[] dataValueDescriptorArray, ColumnOrdering[] columnOrderingArray, int[] nArray, Properties properties, int n2) throws StandardException {
        long l2;
        long l3;
        int n3;
        MethodFactory methodFactory = this.accessmanager.findMethodFactoryByImpl(string);
        if (methodFactory == null || !(methodFactory instanceof ConglomerateFactory)) {
            throw StandardException.newException("XSAM3.S", string);
        }
        ConglomerateFactory conglomerateFactory = (ConglomerateFactory)methodFactory;
        if ((n2 & 1) == 1) {
            n3 = -1;
            l3 = 0L;
        } else {
            n3 = 0;
            l3 = this.accessmanager.getNextConglomId(conglomerateFactory.getConglomerateFactoryId());
        }
        Conglomerate conglomerate = conglomerateFactory.createConglomerate(this, n3, l3, dataValueDescriptorArray, columnOrderingArray, nArray, properties, n2);
        if ((n2 & 1) == 1) {
            l2 = this.nextTempConglomId--;
            if (this.tempCongloms == null) {
                this.tempCongloms = new HashMap();
            }
            this.tempCongloms.put(l2, conglomerate);
        } else {
            l2 = conglomerate.getContainerid();
            this.accessmanager.conglomCacheAddEntry(l2, conglomerate);
        }
        return l2;
    }

    @Override
    public long createAndLoadConglomerate(String string, DataValueDescriptor[] dataValueDescriptorArray, ColumnOrdering[] columnOrderingArray, int[] nArray, Properties properties, int n2, RowLocationRetRowSource rowLocationRetRowSource, long[] lArray) throws StandardException {
        return this.recreateAndLoadConglomerate(string, true, dataValueDescriptorArray, columnOrderingArray, nArray, properties, n2, 0L, rowLocationRetRowSource, lArray);
    }

    @Override
    public long recreateAndLoadConglomerate(String string, boolean bl, DataValueDescriptor[] dataValueDescriptorArray, ColumnOrdering[] columnOrderingArray, int[] nArray, Properties properties, int n2, long l2, RowLocationRetRowSource rowLocationRetRowSource, long[] lArray) throws StandardException {
        long l3 = this.createConglomerate(string, dataValueDescriptorArray, columnOrderingArray, nArray, properties, n2);
        long l4 = this.loadConglomerate(l3, true, rowLocationRetRowSource);
        if (lArray != null) {
            lArray[0] = l4;
        }
        if (!bl && l4 == 0L) {
            this.dropConglomerate(l3);
            l3 = l2;
        }
        return l3;
    }

    @Override
    public String debugOpened() throws StandardException {
        String string = null;
        return string;
    }

    @Override
    public boolean conglomerateExists(long l2) throws StandardException {
        Conglomerate conglomerate = this.findConglomerate(l2);
        return conglomerate != null;
    }

    @Override
    public void dropConglomerate(long l2) throws StandardException {
        Conglomerate conglomerate = this.findExistingConglomerate(l2);
        conglomerate.drop(this);
        if (l2 < 0L) {
            if (this.tempCongloms != null) {
                this.tempCongloms.remove(l2);
            }
        } else {
            this.accessmanager.conglomCacheRemoveEntry(l2);
        }
    }

    @Override
    public boolean fetchMaxOnBtree(long l2, int n2, int n3, int n4, FormatableBitSet formatableBitSet, DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        Conglomerate conglomerate = this.findExistingConglomerate(l2);
        return conglomerate.fetchMaxOnBTree(this, this.rawtran, l2, n2, n3, this.determine_locking_policy(n3, n4), n4, formatableBitSet, dataValueDescriptorArray);
    }

    @Override
    public Properties getUserCreateConglomPropList() {
        Properties properties = ConglomerateUtil.createUserRawStorePropertySet(null);
        return properties;
    }

    @Override
    public boolean isIdle() {
        return this.rawtran.isIdle();
    }

    @Override
    public boolean isGlobal() {
        return this.rawtran.getGlobalId() != null;
    }

    @Override
    public boolean isPristine() {
        return this.rawtran.isPristine();
    }

    @Override
    public Object createXATransactionFromLocalTransaction(int n2, byte[] byArray, byte[] byArray2) throws StandardException {
        this.getRawStoreXact().createXATransactionFromLocalTransaction(n2, byArray, byArray2);
        return this;
    }

    public long loadConglomerate(long l2, boolean bl, RowLocationRetRowSource rowLocationRetRowSource) throws StandardException {
        Conglomerate conglomerate = this.findExistingConglomerate(l2);
        return conglomerate.load(this, bl, rowLocationRetRowSource);
    }

    public void loadConglomerate(long l2, RowLocationRetRowSource rowLocationRetRowSource) throws StandardException {
        this.loadConglomerate(l2, false, rowLocationRetRowSource);
    }

    @Override
    public void logAndDo(Loggable loggable) throws StandardException {
        this.rawtran.logAndDo(loggable);
    }

    @Override
    public ConglomerateController openCompiledConglomerate(boolean bl, int n2, int n3, int n4, StaticCompiledOpenConglomInfo staticCompiledOpenConglomInfo, DynamicCompiledOpenConglomInfo dynamicCompiledOpenConglomInfo) throws StandardException {
        return this.openConglomerate((Conglomerate)staticCompiledOpenConglomInfo.getConglom(), bl, n2, n3, n4, staticCompiledOpenConglomInfo, dynamicCompiledOpenConglomInfo);
    }

    @Override
    public ConglomerateController openConglomerate(long l2, boolean bl, int n2, int n3, int n4) throws StandardException {
        return this.openConglomerate(this.findExistingConglomerate(l2), bl, n2, n3, n4, null, null);
    }

    @Override
    public long findConglomid(long l2) throws StandardException {
        return l2;
    }

    @Override
    public long findContainerid(long l2) throws StandardException {
        return l2;
    }

    @Override
    public BackingStoreHashtable createBackingStoreHashtableFromScan(long l2, int n2, int n3, int n4, FormatableBitSet formatableBitSet, DataValueDescriptor[] dataValueDescriptorArray, int n5, Qualifier[][] qualifierArray, DataValueDescriptor[] dataValueDescriptorArray2, int n6, long l3, int[] nArray, boolean bl, long l4, long l5, int n7, float f2, boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws StandardException {
        return new BackingStoreHashTableFromScan(this, l2, n2, n3, n4, formatableBitSet, dataValueDescriptorArray, n5, qualifierArray, dataValueDescriptorArray2, n6, l3, nArray, bl, l4, l5, n7, f2, bl2, bl3, bl4, bl5);
    }

    @Override
    public GroupFetchScanController openGroupFetchScan(long l2, boolean bl, int n2, int n3, int n4, FormatableBitSet formatableBitSet, DataValueDescriptor[] dataValueDescriptorArray, int n5, Qualifier[][] qualifierArray, DataValueDescriptor[] dataValueDescriptorArray2, int n6) throws StandardException {
        Conglomerate conglomerate = this.findExistingConglomerate(l2);
        ScanManager scanManager = conglomerate.openScan(this, this.rawtran, bl, n2, this.determine_lock_level(n3), this.determine_locking_policy(n3, n4), n4, formatableBitSet, dataValueDescriptorArray, n5, qualifierArray, dataValueDescriptorArray2, n6, null, null);
        this.scanControllers.add(scanManager);
        return scanManager;
    }

    @Override
    public void purgeConglomerate(long l2) throws StandardException {
        this.findExistingConglomerate(l2).purgeConglomerate(this, this.rawtran);
    }

    @Override
    public void compressConglomerate(long l2) throws StandardException {
        this.findExistingConglomerate(l2).compressConglomerate(this, this.rawtran);
    }

    @Override
    public GroupFetchScanController defragmentConglomerate(long l2, boolean bl, boolean bl2, int n2, int n3, int n4) throws StandardException {
        Conglomerate conglomerate = this.findExistingConglomerate(l2);
        ScanManager scanManager = conglomerate.defragmentConglomerate(this, this.rawtran, bl2, n2, this.determine_lock_level(n3), this.determine_locking_policy(n3, n4), n4);
        this.scanControllers.add(scanManager);
        return scanManager;
    }

    @Override
    public ScanController openScan(long l2, boolean bl, int n2, int n3, int n4, FormatableBitSet formatableBitSet, DataValueDescriptor[] dataValueDescriptorArray, int n5, Qualifier[][] qualifierArray, DataValueDescriptor[] dataValueDescriptorArray2, int n6) throws StandardException {
        return this.openScan(this.findExistingConglomerate(l2), bl, n2, n3, n4, formatableBitSet, dataValueDescriptorArray, n5, qualifierArray, dataValueDescriptorArray2, n6, null, null);
    }

    @Override
    public ScanController openCompiledScan(boolean bl, int n2, int n3, int n4, FormatableBitSet formatableBitSet, DataValueDescriptor[] dataValueDescriptorArray, int n5, Qualifier[][] qualifierArray, DataValueDescriptor[] dataValueDescriptorArray2, int n6, StaticCompiledOpenConglomInfo staticCompiledOpenConglomInfo, DynamicCompiledOpenConglomInfo dynamicCompiledOpenConglomInfo) throws StandardException {
        return this.openScan((Conglomerate)staticCompiledOpenConglomInfo.getConglom(), bl, n2, n3, n4, formatableBitSet, dataValueDescriptorArray, n5, qualifierArray, dataValueDescriptorArray2, n6, staticCompiledOpenConglomInfo, dynamicCompiledOpenConglomInfo);
    }

    @Override
    public StoreCostController openStoreCost(long l2) throws StandardException {
        Conglomerate conglomerate = this.findExistingConglomerate(l2);
        StoreCostController storeCostController = conglomerate.openStoreCost(this, this.rawtran);
        return storeCostController;
    }

    @Override
    public long createSort(Properties properties, DataValueDescriptor[] dataValueDescriptorArray, ColumnOrdering[] columnOrderingArray, SortObserver sortObserver, boolean bl, long l2, int n2) throws StandardException {
        int n3;
        MethodFactory methodFactory;
        String string = null;
        if (properties != null) {
            string = properties.getProperty("implType");
        }
        if (string == null) {
            string = "sort external";
        }
        if ((methodFactory = this.accessmanager.findMethodFactoryByImpl(string)) == null || !(methodFactory instanceof SortFactory)) {
            throw StandardException.newException("XSAM0.S", string);
        }
        SortFactory sortFactory = (SortFactory)methodFactory;
        int n4 = 0;
        Sort sort = sortFactory.createSort(this, n4, properties, dataValueDescriptorArray, columnOrderingArray, sortObserver, bl, l2, n2);
        if (this.sorts == null) {
            this.sorts = new ArrayList();
            this.freeSortIds = new ArrayList();
        }
        if (this.freeSortIds.isEmpty()) {
            n3 = this.sorts.size();
            this.sorts.add(sort);
        } else {
            n3 = this.freeSortIds.remove(this.freeSortIds.size() - 1);
            this.sorts.set(n3, sort);
        }
        return n3;
    }

    @Override
    public void dropSort(long l2) throws StandardException {
        Sort sort = this.sorts.get((int)l2);
        if (sort != null) {
            sort.drop(this);
            this.sorts.set((int)l2, null);
            this.freeSortIds.add((int)l2);
        }
    }

    @Override
    public Serializable getProperty(String string) throws StandardException {
        return this.accessmanager.getTransactionalProperties().getProperty(this, string);
    }

    @Override
    public Serializable getPropertyDefault(String string) throws StandardException {
        return this.accessmanager.getTransactionalProperties().getPropertyDefault(this, string);
    }

    @Override
    public void setProperty(String string, Serializable serializable, boolean bl) throws StandardException {
        this.accessmanager.getTransactionalProperties().setProperty(this, string, serializable, bl);
    }

    @Override
    public void setPropertyDefault(String string, Serializable serializable) throws StandardException {
        this.accessmanager.getTransactionalProperties().setPropertyDefault(this, string, serializable);
    }

    @Override
    public boolean propertyDefaultIsVisible(String string) throws StandardException {
        return this.accessmanager.getTransactionalProperties().propertyDefaultIsVisible(this, string);
    }

    @Override
    public Properties getProperties() throws StandardException {
        return this.accessmanager.getTransactionalProperties().getProperties(this);
    }

    @Override
    public SortController openSort(long l2) throws StandardException {
        Sort sort;
        if (this.sorts == null || l2 >= (long)this.sorts.size() || (sort = this.sorts.get((int)l2)) == null) {
            throw StandardException.newException("XSAM4.S", l2);
        }
        SortController sortController = sort.open(this);
        if (this.sortControllers == null) {
            this.sortControllers = new ArrayList();
        }
        this.sortControllers.add(sortController);
        return sortController;
    }

    @Override
    public SortCostController openSortCostController() throws StandardException {
        MethodFactory methodFactory;
        String string = null;
        if (string == null) {
            string = "sort external";
        }
        if ((methodFactory = this.accessmanager.findMethodFactoryByImpl(string)) == null || !(methodFactory instanceof SortFactory)) {
            throw StandardException.newException("XSAM0.S", string);
        }
        SortFactory sortFactory = (SortFactory)methodFactory;
        return sortFactory.openSortCostController();
    }

    @Override
    public ScanController openSortScan(long l2, boolean bl) throws StandardException {
        Sort sort;
        if (this.sorts == null || l2 >= (long)this.sorts.size() || (sort = this.sorts.get((int)l2)) == null) {
            throw StandardException.newException("XSAM4.S", l2);
        }
        ScanManager scanManager = sort.openSortScan(this, bl);
        this.scanControllers.add(scanManager);
        return scanManager;
    }

    @Override
    public RowLocationRetRowSource openSortRowSource(long l2) throws StandardException {
        Sort sort;
        if (this.sorts == null || l2 >= (long)this.sorts.size() || (sort = this.sorts.get((int)l2)) == null) {
            throw StandardException.newException("XSAM4.S", l2);
        }
        ScanControllerRowSource scanControllerRowSource = sort.openSortRowSource(this);
        this.scanControllers.add((ScanManager)((Object)scanControllerRowSource));
        return scanControllerRowSource;
    }

    @Override
    public void commit() throws StandardException {
        this.closeControllers(false);
        this.rawtran.commit();
        this.alterTableCallMade = false;
    }

    @Override
    public DatabaseInstant commitNoSync(int n2) throws StandardException {
        this.closeControllers(false);
        return this.rawtran.commitNoSync(n2);
    }

    @Override
    public void abort() throws StandardException {
        this.invalidateConglomerateCache();
        this.closeControllers(true);
        this.rawtran.abort();
        if (this.parent_tran != null) {
            this.parent_tran.abort();
        }
    }

    @Override
    public ContextManager getContextManager() {
        return this.context.getContextManager();
    }

    @Override
    public int setSavePoint(String string, Object object) throws StandardException {
        return this.rawtran.setSavePoint(string, object);
    }

    @Override
    public int releaseSavePoint(String string, Object object) throws StandardException {
        return this.rawtran.releaseSavePoint(string, object);
    }

    @Override
    public int rollbackToSavePoint(String string, boolean bl, Object object) throws StandardException {
        if (bl) {
            this.closeControllers(true);
        }
        return this.rawtran.rollbackToSavePoint(string, object);
    }

    @Override
    public void destroy() {
        try {
            this.closeControllers(true);
            if (this.rawtran != null) {
                this.rawtran.destroy();
                this.rawtran = null;
            }
            if (this.context != null) {
                this.context.popMe();
            }
            this.context = null;
            this.accessmanager = null;
            this.tempCongloms = null;
        }
        catch (StandardException standardException) {
            this.rawtran = null;
            this.context = null;
            this.accessmanager = null;
            this.tempCongloms = null;
        }
    }

    @Override
    public boolean anyoneBlocked() {
        return this.rawtran.anyoneBlocked();
    }

    @Override
    public void xa_commit(boolean bl) throws StandardException {
        this.rawtran.xa_commit(bl);
    }

    @Override
    public int xa_prepare() throws StandardException {
        return this.rawtran.xa_prepare();
    }

    @Override
    public void xa_rollback() throws StandardException {
        this.rawtran.xa_rollback();
    }

    @Override
    public Conglomerate findExistingConglomerateFromKey(ContainerKey containerKey) throws StandardException {
        return this.findExistingConglomerate(containerKey.getContainerId());
    }

    @Override
    public void addPostCommitWork(Serviceable serviceable) {
        this.rawtran.addPostCommitWork(serviceable);
    }

    @Override
    public boolean checkVersion(int n2, int n3, String string) throws StandardException {
        return this.accessmanager.getRawStore().checkVersion(n2, n3, string);
    }

    @Override
    public void closeMe(ConglomerateController conglomerateController) {
        this.conglomerateControllers.remove(conglomerateController);
    }

    @Override
    public void closeMe(SortController sortController) {
        this.sortControllers.remove(sortController);
    }

    @Override
    public void closeMe(ScanManager scanManager) {
        this.scanControllers.remove(scanManager);
    }

    @Override
    public AccessFactory getAccessManager() {
        return this.accessmanager;
    }

    @Override
    public TransactionManager getInternalTransaction() throws StandardException {
        ContextManager contextManager = this.getContextManager();
        Transaction transaction = this.accessmanager.getRawStore().startInternalTransaction(contextManager);
        RAMTransaction rAMTransaction = new RAMTransaction(this.accessmanager, transaction, null);
        RAMTransactionContext rAMTransactionContext = new RAMTransactionContext(contextManager, "RAMInternalContext", rAMTransaction, true);
        transaction.setDefaultLockingPolicy(this.accessmanager.getDefaultLockingPolicy());
        return rAMTransaction;
    }

    @Override
    public TransactionController startNestedUserTransaction(boolean bl, boolean bl2) throws StandardException {
        ContextManager contextManager = this.getContextManager();
        Transaction transaction = bl ? this.accessmanager.getRawStore().startNestedReadOnlyUserTransaction(this.rawtran, this.getLockSpace(), contextManager, "nestedReadOnlyUserTransaction") : this.accessmanager.getRawStore().startNestedUpdateUserTransaction(this.rawtran, contextManager, "nestedUpdateUserTransaction", bl2);
        RAMTransaction rAMTransaction = new RAMTransaction(this.accessmanager, transaction, this);
        RAMTransactionContext rAMTransactionContext = new RAMTransactionContext(contextManager, "RAMChildContext", rAMTransaction, true);
        transaction.setDefaultLockingPolicy(this.accessmanager.getDefaultLockingPolicy());
        return rAMTransaction;
    }

    @Override
    public Transaction getRawStoreXact() {
        return this.rawtran;
    }

    @Override
    public FileResource getFileHandler() {
        return this.rawtran.getFileHandler();
    }

    @Override
    public CompatibilitySpace getLockSpace() {
        return this.rawtran.getCompatibilitySpace();
    }

    @Override
    public void setNoLockWait(boolean bl) {
        this.rawtran.setNoLockWait(bl);
    }

    @Override
    public String getTransactionIdString() {
        return this.rawtran.toString();
    }

    @Override
    public String getActiveStateTxIdString() {
        return this.rawtran.getActiveStateTxIdString();
    }

    public String toString() {
        String string = null;
        return string;
    }
}

