/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.btree;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.store.access.BackingStoreHashtable;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.store.access.btree.BTreeRowPosition;
import org.apache.derby.impl.store.access.btree.BTreeScan;
import org.apache.derby.impl.store.access.btree.ControlRow;
import org.apache.derby.impl.store.access.btree.LeafControlRow;
import org.apache.derby.impl.store.access.btree.WaitError;

public class BTreeMaxScan
extends BTreeScan {
    private boolean moveToLeftSibling() throws StandardException {
        try {
            this.positionAtPreviousPage();
            return true;
        }
        catch (WaitError waitError) {
            long l2 = this.scan_position.current_leaf.getleftSiblingPageNumber();
            if (BTreeMaxScan.isEmpty(this.scan_position.current_leaf.getPage())) {
                this.scan_position.current_leaf.release();
                this.scan_position.init();
            } else {
                this.scan_position.current_slot = 1;
                this.savePositionAndReleasePage();
            }
            Page page = this.container.getPage(l2);
            if (page != null) {
                page.unlatch();
                page = null;
            }
            return false;
        }
    }

    @Override
    protected int fetchRows(BTreeRowPosition bTreeRowPosition, DataValueDescriptor[][] dataValueDescriptorArray, RowLocation[] rowLocationArray, BackingStoreHashtable backingStoreHashtable, long l2, int[] nArray) throws StandardException {
        throw StandardException.newException("XSCB3.S", new Object[0]);
    }

    @Override
    protected void positionAtStartPosition(BTreeRowPosition bTreeRowPosition) throws StandardException {
        while (true) {
            ControlRow controlRow = ControlRow.get(this, 1L);
            this.stat_numpages_visited += controlRow.getLevel() + 1;
            if (this.init_startKeyValue != null) {
                throw StandardException.newException("XSCB3.S", new Object[0]);
            }
            bTreeRowPosition.current_leaf = (LeafControlRow)controlRow.searchRight(this);
            bTreeRowPosition.current_slot = bTreeRowPosition.current_leaf.page.recordCount();
            boolean bl = false;
            --bTreeRowPosition.current_slot;
            boolean bl2 = !this.getLockingPolicy().lockScanRow(this, bTreeRowPosition, this.init_lock_fetch_desc, bTreeRowPosition.current_lock_template, bTreeRowPosition.current_lock_row_loc, false, this.init_forUpdate, this.lock_operation);
            ++bTreeRowPosition.current_slot;
            if (!bl2) break;
            bTreeRowPosition.init();
        }
        this.scan_state = 2;
    }

    public boolean fetchMax(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        BTreeRowPosition bTreeRowPosition = this.scan_position;
        int n2 = 0;
        if (this.scan_state == 2) {
            if (!this.reposition(this.scan_position, true)) {
                // empty if block
            }
        } else if (this.scan_state == 1) {
            this.positionAtStartPosition(this.scan_position);
        } else {
            return false;
        }
        boolean bl = false;
        block0: while (!bl && bTreeRowPosition.current_leaf != null) {
            if (bTreeRowPosition.current_slot <= 1) {
                boolean bl2 = !this.moveToLeftSibling();
                if (!bl2) continue;
                if (bTreeRowPosition.current_positionKey == null) {
                    this.scan_state = 1;
                    this.positionAtStartPosition(bTreeRowPosition);
                    continue;
                }
                if (this.reposition(bTreeRowPosition, false)) continue;
                if (!this.reposition(bTreeRowPosition, true)) {
                    // empty if block
                }
                ++bTreeRowPosition.current_slot;
                continue;
            }
            --bTreeRowPosition.current_slot;
            while (bTreeRowPosition.current_slot > 0) {
                ++this.stat_numrows_visited;
                RecordHandle recordHandle = bTreeRowPosition.current_leaf.page.fetchFromSlot(null, bTreeRowPosition.current_slot, dataValueDescriptorArray, this.init_fetchDesc, true);
                boolean bl3 = !this.getLockingPolicy().lockScanRow(this, bTreeRowPosition, this.init_lock_fetch_desc, bTreeRowPosition.current_lock_template, bTreeRowPosition.current_lock_row_loc, false, this.init_forUpdate, this.lock_operation);
                bTreeRowPosition.current_rh = recordHandle;
                if (bl3 && !this.reposition(bTreeRowPosition, false)) {
                    if (!this.reposition(bTreeRowPosition, true)) {
                        // empty if block
                    }
                    ++bTreeRowPosition.current_slot;
                    continue block0;
                }
                if (bTreeRowPosition.current_leaf.page.isDeletedAtSlot(bTreeRowPosition.current_slot)) {
                    ++this.stat_numdeleted_rows_visited;
                    bTreeRowPosition.current_rh_qualified = false;
                } else {
                    bTreeRowPosition.current_rh_qualified = !dataValueDescriptorArray[0].isNull();
                }
                if (bTreeRowPosition.current_rh_qualified) {
                    ++n2;
                    ++this.stat_numrows_qualified;
                    bTreeRowPosition.current_slot = -1;
                    bl = true;
                    continue block0;
                }
                --bTreeRowPosition.current_slot;
            }
        }
        if (bTreeRowPosition.current_leaf != null) {
            bTreeRowPosition.current_leaf.release();
            bTreeRowPosition.current_leaf = null;
        }
        this.positionAtDoneScan(this.scan_position);
        return bl;
    }
}

