/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.sort;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.store.access.sort.MergeSort;
import org.apache.derby.impl.store.access.sort.Node;
import org.apache.derby.impl.store.access.sort.NodeAllocator;

class SortBuffer {
    public static final int INSERT_OK = 0;
    public static final int INSERT_DUPLICATE = 1;
    public static final int INSERT_FULL = 2;
    private MergeSort sort;
    private NodeAllocator allocator = null;
    private Node head = null;
    private int height = 0;
    private DataValueDescriptor[] deletedKey;
    private boolean subtreeShrunk;
    private int nextAux;
    private int lastAux;

    void setNextAux(int n2) {
        this.nextAux = n2;
    }

    int getLastAux() {
        return this.lastAux;
    }

    SortBuffer(MergeSort mergeSort) {
        this.sort = mergeSort;
    }

    boolean init() {
        this.allocator = new NodeAllocator();
        boolean bl = false;
        bl = this.sort.sortBufferMin > 0 ? this.allocator.init(this.sort.sortBufferMin, this.sort.sortBufferMax) : this.allocator.init(this.sort.sortBufferMax);
        if (!bl) {
            this.allocator = null;
            return false;
        }
        this.reset();
        return true;
    }

    void reset() {
        this.allocator.reset();
        this.head = this.allocator.newNode();
        this.height = 0;
    }

    void close() {
        if (this.allocator != null) {
            this.allocator.close();
        }
        this.allocator = null;
        this.height = 0;
        this.head = null;
    }

    void grow(int n2) {
        if (n2 > 0) {
            this.allocator.grow(n2);
        }
    }

    int capacity() {
        if (this.allocator == null) {
            return 0;
        }
        return this.allocator.capacity() - 1;
    }

    int insert(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        int n2;
        Node node;
        int n3;
        Node node2;
        if (this.head.rightLink == null) {
            if (this.sort.sortObserver != null && (dataValueDescriptorArray = this.sort.sortObserver.insertNonDuplicateKey(dataValueDescriptorArray)) == null) {
                return 1;
            }
            Node node3 = this.allocator.newNode();
            node3.key = dataValueDescriptorArray;
            node3.aux = this.nextAux;
            this.head.rightLink = node3;
            this.height = 1;
            return 0;
        }
        Node node4 = this.head;
        Node node5 = node2 = this.head.rightLink;
        while (true) {
            if ((n3 = this.sort.compare(dataValueDescriptorArray, node5.key)) == 0) {
                if (this.sort.sortObserver != null && (dataValueDescriptorArray = this.sort.sortObserver.insertDuplicateKey(dataValueDescriptorArray, node5.key)) == null) {
                    return 1;
                }
                node = this.allocator.newNode();
                if (node == null) {
                    return 2;
                }
                node.aux = this.nextAux;
                node.key = dataValueDescriptorArray;
                node.dupChain = node5.dupChain;
                node5.dupChain = node;
                return 0;
            }
            if (n3 < 0) {
                node = node5.leftLink;
                if (node == null) {
                    node = this.allocator.newNode();
                    if (node == null) {
                        return 2;
                    }
                    node.aux = this.nextAux;
                    node5.leftLink = node;
                    break;
                }
            } else {
                node = node5.rightLink;
                if (node == null) {
                    node = this.allocator.newNode();
                    if (node == null) {
                        return 2;
                    }
                    node.aux = this.nextAux;
                    node5.rightLink = node;
                    break;
                }
            }
            if (node.balance != 0) {
                node4 = node5;
                node2 = node;
            }
            node5 = node;
        }
        if (this.sort.sortObserver != null && (dataValueDescriptorArray = this.sort.sortObserver.insertNonDuplicateKey(dataValueDescriptorArray)) == null) {
            return 1;
        }
        node.key = dataValueDescriptorArray;
        n3 = this.sort.compare(dataValueDescriptorArray, node2.key);
        Node node6 = n3 < 0 ? (node5 = node2.leftLink) : (node5 = node2.rightLink);
        while (node5 != node) {
            if (this.sort.compare(dataValueDescriptorArray, node5.key) < 0) {
                node5.balance = -1;
                node5 = node5.leftLink;
                continue;
            }
            node5.balance = 1;
            node5 = node5.rightLink;
        }
        int n4 = n3 > 0 ? 1 : (n2 = n3 == 0 ? 0 : -1);
        if (node2.balance == 0) {
            node2.balance = n2;
            ++this.height;
            return 0;
        }
        if (node2.balance == -n2) {
            node2.balance = 0;
            return 0;
        }
        if (node6.balance == n2) {
            node5 = node6;
            node2.setLink(n2, node6.link(-n2));
            node6.setLink(-n2, node2);
            node2.balance = 0;
            node6.balance = 0;
        } else {
            node5 = node6.link(-n2);
            node6.setLink(-n2, node5.link(n2));
            node5.setLink(n2, node6);
            node2.setLink(n2, node5.link(-n2));
            node5.setLink(-n2, node2);
            if (node5.balance == n2) {
                node2.balance = -n2;
                node6.balance = 0;
            } else if (node5.balance == 0) {
                node2.balance = 0;
                node6.balance = 0;
            } else {
                node2.balance = 0;
                node6.balance = n2;
            }
            node5.balance = 0;
        }
        if (node2 == node4.rightLink) {
            node4.rightLink = node5;
        } else {
            node4.leftLink = node5;
        }
        return 0;
    }

    DataValueDescriptor[] removeFirst() {
        if (this.head.rightLink == null) {
            return null;
        }
        this.head.rightLink = this.deleteLeftmost(this.head.rightLink);
        if (this.subtreeShrunk) {
            --this.height;
        }
        return this.deletedKey;
    }

    private Node deleteLeftmost(Node node) {
        if (node.leftLink == null) {
            if (node.dupChain != null) {
                Node node2 = node.dupChain;
                this.deletedKey = node2.key;
                this.lastAux = node2.aux;
                node.dupChain = node2.dupChain;
                this.allocator.freeNode(node2);
                node2 = null;
                this.subtreeShrunk = false;
                return node;
            }
            this.deletedKey = node.key;
            this.lastAux = node.aux;
            this.subtreeShrunk = true;
            Node node3 = node.rightLink;
            this.allocator.freeNode(node);
            return node3;
        }
        node.leftLink = this.deleteLeftmost(node.leftLink);
        if (!this.subtreeShrunk) {
            return node;
        }
        if (node.balance == 1) {
            return this.rotateRight(node);
        }
        if (node.balance == -1) {
            node.balance = 0;
            this.subtreeShrunk = true;
        } else {
            node.balance = 1;
            this.subtreeShrunk = false;
        }
        return node;
    }

    private Node rotateRight(Node node) {
        Node node2 = node;
        Node node3 = node.rightLink;
        if (node3.balance >= 0) {
            node2.rightLink = node3.leftLink;
            node3.leftLink = node2;
            if (node3.balance == 0) {
                node2.balance = 1;
                node3.balance = -1;
                this.subtreeShrunk = false;
            } else {
                node2.balance = 0;
                node3.balance = 0;
                this.subtreeShrunk = true;
            }
            return node3;
        }
        Node node4 = node3.leftLink;
        node2.rightLink = node4.leftLink;
        node4.leftLink = node2;
        node3.leftLink = node4.rightLink;
        node4.rightLink = node3;
        if (node4.balance == 1) {
            node2.balance = -1;
            node3.balance = 0;
        } else if (node4.balance == -1) {
            node2.balance = 0;
            node3.balance = 1;
        } else {
            node2.balance = 0;
            node3.balance = 0;
        }
        node4.balance = 0;
        this.subtreeShrunk = true;
        return node4;
    }

    public void check() {
    }

    private String checkNode(Node node) {
        return null;
    }

    private int depth(Node node) {
        int n2 = 0;
        int n3 = 0;
        if (node == null) {
            return 0;
        }
        if (node.leftLink != null) {
            n2 = this.depth(node.leftLink);
        }
        if (node.rightLink != null) {
            n3 = this.depth(node.rightLink);
        }
        if (n3 > n2) {
            return n3 + 1;
        }
        return n2 + 1;
    }

    public void print() {
        Node node = this.head.rightLink;
        System.out.println("tree height: " + this.height + " root: " + (node == null ? -1 : node.id));
        if (node != null) {
            this.printRecursive(node, 0);
        }
    }

    private void printRecursive(Node node, int n2) {
        if (node.rightLink != null) {
            this.printRecursive(node.rightLink, n2 + 1);
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            System.out.print("       ");
        }
        System.out.println(node);
        if (node.leftLink != null) {
            this.printRecursive(node.leftLink, n2 + 1);
        }
    }

    private void debug(String string) {
    }
}

