/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.services.io.DynamicByteArrayOutputStream;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.access.conglomerate.LogicalUndo;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.PageActions;

public class DirectActions
implements PageActions {
    protected DynamicByteArrayOutputStream outBytes = new DynamicByteArrayOutputStream();
    protected ArrayInputStream limitIn = new ArrayInputStream();

    @Override
    public void actionDelete(RawTransaction rawTransaction, BasePage basePage, int n2, int n3, boolean bl, LogicalUndo logicalUndo) throws StandardException {
        try {
            basePage.setDeleteStatus(null, n2, bl);
        }
        catch (IOException iOException) {
            throw StandardException.newException("XSDA4.S", iOException, new Object[0]);
        }
    }

    @Override
    public int actionUpdate(RawTransaction rawTransaction, BasePage basePage, int n2, int n3, Object[] objectArray, FormatableBitSet formatableBitSet, int n4, DynamicByteArrayOutputStream dynamicByteArrayOutputStream, int n5, RecordHandle recordHandle) throws StandardException {
        if (dynamicByteArrayOutputStream == null) {
            this.outBytes.reset();
        } else {
            this.outBytes = dynamicByteArrayOutputStream;
        }
        try {
            int n6 = basePage.logRow(n2, false, n3, objectArray, formatableBitSet, this.outBytes, 0, (byte)8, n4, n5, 100);
            this.limitIn.setData(this.outBytes.getByteArray());
            this.limitIn.setPosition(this.outBytes.getBeginPosition());
            this.limitIn.setLimit(this.outBytes.getPosition() - this.outBytes.getBeginPosition());
            basePage.storeRecord(null, n2, false, this.limitIn);
            return n6;
        }
        catch (IOException iOException) {
            throw StandardException.newException("XSDA4.S", iOException, new Object[0]);
        }
    }

    @Override
    public void actionPurge(RawTransaction rawTransaction, BasePage basePage, int n2, int n3, int[] nArray, boolean bl) throws StandardException {
        try {
            for (int i2 = n3 - 1; i2 >= 0; --i2) {
                basePage.purgeRecord(null, n2 + i2, nArray[i2]);
            }
        }
        catch (IOException iOException) {
            throw StandardException.newException("XSDA4.S", iOException, new Object[0]);
        }
    }

    @Override
    public void actionUpdateField(RawTransaction rawTransaction, BasePage basePage, int n2, int n3, int n4, Object object, LogicalUndo logicalUndo) throws StandardException {
        this.outBytes.reset();
        try {
            basePage.logColumn(n2, n4, object, this.outBytes, 100);
            this.limitIn.setData(this.outBytes.getByteArray());
            this.limitIn.setPosition(this.outBytes.getBeginPosition());
            this.limitIn.setLimit(this.outBytes.getPosition() - this.outBytes.getBeginPosition());
            basePage.storeField(null, n2, n4, this.limitIn);
        }
        catch (IOException iOException) {
            throw StandardException.newException("XSDA4.S", iOException, new Object[0]);
        }
    }

    @Override
    public int actionInsert(RawTransaction rawTransaction, BasePage basePage, int n2, int n3, Object[] objectArray, FormatableBitSet formatableBitSet, LogicalUndo logicalUndo, byte by, int n4, boolean bl, int n5, DynamicByteArrayOutputStream dynamicByteArrayOutputStream, int n6, int n7) throws StandardException {
        if (dynamicByteArrayOutputStream == null) {
            this.outBytes.reset();
        } else {
            this.outBytes = dynamicByteArrayOutputStream;
        }
        try {
            n4 = bl ? basePage.logLongColumn(n2, n3, objectArray[0], this.outBytes) : basePage.logRow(n2, true, n3, objectArray, formatableBitSet, this.outBytes, n4, by, n5, n6, n7);
            this.limitIn.setData(this.outBytes.getByteArray());
            this.limitIn.setPosition(this.outBytes.getBeginPosition());
            this.limitIn.setLimit(this.outBytes.getPosition() - this.outBytes.getBeginPosition());
            basePage.storeRecord(null, n2, true, this.limitIn);
            return n4;
        }
        catch (IOException iOException) {
            throw StandardException.newException("XSDA4.S", iOException, new Object[0]);
        }
    }

    @Override
    public void actionCopyRows(RawTransaction rawTransaction, BasePage basePage, BasePage basePage2, int n2, int n3, int n4, int[] nArray) throws StandardException {
        try {
            int n5;
            int[] nArray2 = new int[n3];
            for (n5 = 0; n5 < n3; ++n5) {
                this.outBytes.reset();
                basePage2.logRecord(n4 + n5, 0, nArray[n5], null, this.outBytes, null);
                nArray2[n5] = this.outBytes.getUsed();
            }
            if (!basePage.spaceForCopy(n3, nArray2)) {
                throw StandardException.newException("XSDA3.S", new Object[0]);
            }
            for (n5 = 0; n5 < n3; ++n5) {
                this.outBytes.reset();
                basePage2.logRecord(n4 + n5, 0, nArray[n5], null, this.outBytes, null);
                this.limitIn.setData(this.outBytes.getByteArray());
                this.limitIn.setPosition(this.outBytes.getBeginPosition());
                this.limitIn.setLimit(this.outBytes.getPosition() - this.outBytes.getBeginPosition());
                basePage.storeRecord(null, n2 + n5, true, this.limitIn);
            }
        }
        catch (IOException iOException) {
            throw StandardException.newException("XSDA4.S", iOException, new Object[0]);
        }
    }

    @Override
    public void actionInvalidatePage(RawTransaction rawTransaction, BasePage basePage) throws StandardException {
        basePage.setPageStatus(null, (byte)2);
    }

    @Override
    public void actionInitPage(RawTransaction rawTransaction, BasePage basePage, int n2, int n3, long l2) throws StandardException {
        boolean bl = (n2 & 2) != 0;
        boolean bl2 = (n2 & 1) != 0;
        int n4 = (n2 & 4) == 0 ? basePage.newRecordId() : 6;
        basePage.initPage(null, (byte)1, n4, bl, bl2);
    }

    @Override
    public void actionShrinkReservedSpace(RawTransaction rawTransaction, BasePage basePage, int n2, int n3, int n4, int n5) throws StandardException {
        try {
            basePage.setReservedSpace(null, n2, n4);
        }
        catch (IOException iOException) {
            throw StandardException.newException("XSDA4.S", iOException, new Object[0]);
        }
    }
}

