/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.impl.store.raw.data.AllocPage;
import org.apache.derby.impl.store.raw.data.AllocPageOperation;
import org.apache.derby.impl.store.raw.data.AllocationActions;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.ChainAllocPageOperation;
import org.apache.derby.impl.store.raw.data.CompressSpacePageOperation;
import org.apache.derby.impl.store.raw.data.CompressSpacePageOperation10_2;

public class LoggableAllocActions
implements AllocationActions {
    @Override
    public void actionAllocatePage(RawTransaction rawTransaction, BasePage basePage, long l2, int n2, int n3) throws StandardException {
        AllocPageOperation allocPageOperation = new AllocPageOperation((AllocPage)basePage, l2, n2, n3);
        basePage.preDirty();
        rawTransaction.logAndDo(allocPageOperation);
    }

    @Override
    public void actionChainAllocPage(RawTransaction rawTransaction, BasePage basePage, long l2, long l3) throws StandardException {
        ChainAllocPageOperation chainAllocPageOperation = new ChainAllocPageOperation((AllocPage)basePage, l2, l3);
        basePage.preDirty();
        rawTransaction.logAndDo(chainAllocPageOperation);
    }

    @Override
    public void actionCompressSpaceOperation(RawTransaction rawTransaction, BasePage basePage, int n2, int n3) throws StandardException {
        CompressSpacePageOperation compressSpacePageOperation = null;
        compressSpacePageOperation = rawTransaction.getLogFactory().checkVersion(10, 3, null) ? new CompressSpacePageOperation((AllocPage)basePage, n2, n3) : new CompressSpacePageOperation10_2((AllocPage)basePage, n2, n3);
        basePage.preDirty();
        rawTransaction.logAndDo(compressSpacePageOperation);
    }
}

