/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.apache.derby.impl.store.raw.data.ByteHolder;

public class MemByteHolder
implements ByteHolder {
    int bufSize;
    boolean writing = true;
    Vector<byte[]> bufV;
    int curBufVEleAt;
    byte[] curBuf;
    int curBufPos;
    int curBufDataBytes;
    int lastBufVEleAt = 0;
    int lastBufDataBytes = 0;

    public MemByteHolder(int n2) {
        this.bufSize = n2;
        this.curBuf = new byte[n2];
        this.curBufPos = 0;
        this.bufV = new Vector(128);
        this.bufV.addElement(this.curBuf);
        this.curBufVEleAt = 0;
    }

    @Override
    public void write(int n2) throws IOException {
        if (this.curBufPos >= this.curBuf.length) {
            this.getNextBuffer_w();
        }
        this.curBuf[this.curBufPos++] = (byte)n2;
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        while (n3 > 0) {
            int n4;
            int n5;
            if (this.curBufPos >= this.curBuf.length) {
                this.getNextBuffer_w();
            }
            if ((n5 = n3) > (n4 = this.curBuf.length - this.curBufPos)) {
                n5 = n4;
            }
            System.arraycopy(byArray, n2, this.curBuf, this.curBufPos, n5);
            n2 += n5;
            this.curBufPos += n5;
            n3 -= n5;
        }
    }

    @Override
    public long write(InputStream inputStream, long l2) throws IOException {
        long l3 = l2;
        int n2 = 0;
        do {
            int n3;
            int n4;
            if (this.curBufPos >= this.curBuf.length) {
                this.getNextBuffer_w();
            }
            if ((n2 = inputStream.read(this.curBuf, this.curBufPos, n4 = l3 >= (long)(n3 = this.curBuf.length - this.curBufPos) ? n3 : (int)l3)) <= 0) continue;
            l3 -= (long)n2;
            this.curBufPos += n2;
        } while (l3 > 0L && n2 > 0);
        return l2 - l3;
    }

    @Override
    public void clear() throws IOException {
        this.writing = true;
        this.curBuf = this.bufV.elementAt(0);
        this.curBufVEleAt = 0;
        this.curBufPos = 0;
        this.lastBufVEleAt = 0;
        this.lastBufDataBytes = 0;
    }

    @Override
    public void startReading() throws IOException {
        if (this.writing) {
            this.writing = false;
            this.lastBufDataBytes = this.curBufPos;
            this.lastBufVEleAt = this.curBufVEleAt;
        }
        this.curBuf = this.bufV.elementAt(0);
        this.curBufVEleAt = 0;
        this.curBufPos = 0;
        this.curBufDataBytes = this.curBufVEleAt == this.lastBufVEleAt ? this.lastBufDataBytes : this.bufSize;
    }

    @Override
    public int read() throws IOException {
        if (this.curBufPos >= this.curBufDataBytes) {
            this.getNextBuffer_r();
        }
        if (this.curBufPos >= this.curBufDataBytes) {
            return -1;
        }
        return 0xFF & this.curBuf[this.curBufPos++];
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        return this.read(byArray, n2, null, n3);
    }

    @Override
    public int read(OutputStream outputStream, int n2) throws IOException {
        return this.read(null, 0, outputStream, n2);
    }

    public int read(byte[] byArray, int n2, OutputStream outputStream, int n3) throws IOException {
        int n4 = 0;
        boolean bl = false;
        if (this.curBufPos >= this.curBufDataBytes) {
            bl = this.getNextBuffer_r();
        }
        if (bl) {
            return -1;
        }
        while (n3 > 0 && !bl) {
            int n5 = this.curBufDataBytes - this.curBufPos;
            int n6 = n3 >= n5 ? n5 : n3;
            if (outputStream == null) {
                System.arraycopy(this.curBuf, this.curBufPos, byArray, n2, n6);
            } else {
                outputStream.write(this.curBuf, this.curBufPos, n6);
            }
            n2 += n6;
            this.curBufPos += n6;
            n3 -= n6;
            n4 += n6;
            if (this.curBufPos < this.curBufDataBytes) continue;
            bl = this.getNextBuffer_r();
        }
        return n4;
    }

    @Override
    public int shiftToFront() throws IOException {
        int n2 = this.available();
        n2 = n2 > 0 ? n2 : -1 * n2;
        byte[] byArray = new byte[n2 + 1];
        int n3 = this.read(byArray, 0, n2);
        this.clear();
        this.writing = true;
        this.write(byArray, 0, n3);
        this.curBufDataBytes = 0;
        return n3;
    }

    @Override
    public int available() {
        int n2 = this.curBufDataBytes - this.curBufPos;
        int n3 = 0;
        int n4 = 0;
        if (this.curBufVEleAt != this.lastBufVEleAt) {
            n4 = this.lastBufVEleAt - this.curBufVEleAt - 1;
            n3 = this.lastBufDataBytes;
        }
        int n5 = n2 + n3 + n4 * this.bufSize;
        return n5;
    }

    @Override
    public int numBytesSaved() {
        int n2 = this.writing ? this.curBufVEleAt * this.bufSize + this.curBufPos : this.lastBufVEleAt * this.bufSize + this.lastBufDataBytes;
        return n2;
    }

    @Override
    public long skip(long l2) throws IOException {
        long l3 = 0L;
        boolean bl = false;
        if (this.curBufPos >= this.curBufDataBytes) {
            bl = this.getNextBuffer_r();
        }
        while (l2 > 0L && !bl) {
            int n2 = this.curBufDataBytes - this.curBufPos;
            int n3 = l2 >= (long)n2 ? n2 : (int)l2;
            this.curBufPos += n3;
            l3 += (long)n3;
            if ((l2 -= (long)n3) <= 0L) continue;
            bl = this.getNextBuffer_r();
        }
        return l3;
    }

    @Override
    public boolean writingMode() {
        return this.writing;
    }

    @Override
    public ByteHolder cloneEmpty() {
        return new MemByteHolder(this.bufSize);
    }

    protected void getNextBuffer_w() throws IOException {
        ++this.curBufVEleAt;
        if (this.bufV.size() <= this.curBufVEleAt) {
            this.curBuf = new byte[this.bufSize];
            this.bufV.addElement(this.curBuf);
        } else {
            this.curBuf = this.bufV.elementAt(this.curBufVEleAt);
        }
        this.initBuffer_w();
    }

    protected void getNextBuffer_w_Sanity() {
    }

    protected void initBuffer_w() {
        this.curBufPos = 0;
    }

    protected boolean getNextBuffer_r() throws IOException {
        if (this.curBufVEleAt >= this.lastBufVEleAt) {
            return true;
        }
        this.curBuf = this.bufV.elementAt(++this.curBufVEleAt);
        this.curBufPos = 0;
        this.curBufDataBytes = this.curBufVEleAt == this.lastBufVEleAt ? this.lastBufDataBytes : this.bufSize;
        return false;
    }

    private String dumpBuf(int n2) {
        StringBuffer stringBuffer = new StringBuffer(100);
        byte[] byArray = this.bufV.elementAt(n2);
        stringBuffer.append("(");
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            stringBuffer.append(byArray[i2] + ".");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String toString() {
        return " writing: " + this.writing + " curBufVEleAt: " + this.curBufVEleAt + " curBufPos: " + this.curBufPos + " curBufDataBytes: " + this.curBufDataBytes + " lastBufVEleAt: " + this.lastBufVEleAt + " lastBufDataBytes: " + this.lastBufDataBytes + " curBuf: " + this.dumpBuf(this.curBufVEleAt);
    }
}

