/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.log;

import java.io.IOException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.TransactionId;
import org.apache.derby.impl.store.raw.log.LogCounter;
import org.apache.derby.impl.store.raw.log.LogRecord;
import org.apache.derby.impl.store.raw.log.LogToFile;
import org.apache.derby.impl.store.raw.log.StreamLogScan;
import org.apache.derby.io.StorageRandomAccessFile;

public class FlushedScan
implements StreamLogScan {
    private StorageRandomAccessFile scan;
    LogToFile logFactory;
    boolean open;
    long currentLogFileNumber;
    long currentLogFileFirstUnflushedPosition;
    long currentInstant;
    long firstUnflushed = -1L;
    long firstUnflushedFileNumber;
    long firstUnflushedFilePosition;
    static final int LOG_REC_LEN_BYTE_LENGTH = 4;
    int nextRecordLength;
    boolean readNextRecordLength;

    public FlushedScan(LogToFile logToFile, long l2) throws StandardException {
        try {
            this.currentLogFileNumber = LogCounter.getLogFileNumber(l2);
            this.logFactory = logToFile;
            this.scan = logToFile.getLogFileAtPosition(l2);
            this.setFirstUnflushed();
            this.open = true;
            this.currentInstant = 0L;
        }
        catch (IOException iOException) {
            throw logToFile.markCorrupt(StandardException.newException("XSLA2.D", iOException, new Object[0]));
        }
    }

    @Override
    public LogRecord getNextRecord(ArrayInputStream arrayInputStream, TransactionId transactionId, int n2) throws StandardException {
        try {
            LogRecord logRecord;
            boolean bl;
            int n3 = LogRecord.formatOverhead() + LogRecord.maxGroupStoredSize();
            if (transactionId != null) {
                n3 += LogRecord.maxTransactionIdStoredSize(transactionId);
            }
            do {
                int n4;
                if (!this.open || !this.positionToNextRecord()) {
                    return null;
                }
                logRecord = null;
                bl = true;
                int n5 = -1;
                this.currentInstant = this.scan.readLong();
                byte[] byArray = arrayInputStream.getData();
                if (byArray.length < this.nextRecordLength) {
                    byArray = new byte[this.nextRecordLength];
                    arrayInputStream.setData(byArray);
                }
                if (this.logFactory.databaseEncrypted()) {
                    this.scan.readFully(byArray, 0, this.nextRecordLength);
                    n4 = this.logFactory.decrypt(byArray, 0, this.nextRecordLength, byArray, 0);
                    arrayInputStream.setLimit(0, n4);
                } else if (n2 == 0 && transactionId == null) {
                    this.scan.readFully(byArray, 0, this.nextRecordLength);
                    arrayInputStream.setLimit(0, this.nextRecordLength);
                } else {
                    n5 = this.nextRecordLength > n3 ? n3 : this.nextRecordLength;
                    this.scan.readFully(byArray, 0, n5);
                    arrayInputStream.setLimit(0, n5);
                }
                logRecord = (LogRecord)arrayInputStream.readObject();
                if (n2 != 0 || transactionId != null) {
                    TransactionId transactionId2;
                    if (n2 != 0 && (n2 & logRecord.group()) == 0) {
                        bl = false;
                    }
                    if (bl && transactionId != null && !(transactionId2 = logRecord.getTransactionId()).equals(transactionId)) {
                        bl = false;
                    }
                    if (bl && !this.logFactory.databaseEncrypted() && n5 < this.nextRecordLength) {
                        n4 = arrayInputStream.getPosition();
                        this.scan.readFully(byArray, n5, this.nextRecordLength - n5);
                        arrayInputStream.setLimit(0, this.nextRecordLength);
                        arrayInputStream.setPosition(n4);
                    }
                }
                if (bl || this.logFactory.databaseEncrypted()) {
                    int n6 = this.scan.readInt();
                    continue;
                }
                long l2 = LogCounter.getLogFilePosition(this.currentInstant) + (long)this.nextRecordLength + 16L;
                this.scan.seek(l2);
            } while (!bl);
            return logRecord;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw this.logFactory.markCorrupt(StandardException.newException("XSLA3.D", classNotFoundException, new Object[0]));
        }
        catch (IOException iOException) {
            throw this.logFactory.markCorrupt(StandardException.newException("XSLA2.D", iOException, new Object[0]));
        }
    }

    @Override
    public void resetPosition(LogInstant logInstant) throws IOException {
    }

    @Override
    public long getLogRecordEnd() {
        return 0L;
    }

    @Override
    public boolean isLogEndFuzzy() {
        return false;
    }

    @Override
    public long getInstant() {
        return this.currentInstant;
    }

    @Override
    public LogInstant getLogInstant() {
        if (this.currentInstant == 0L) {
            return null;
        }
        return new LogCounter(this.currentInstant);
    }

    @Override
    public void close() {
        if (this.scan != null) {
            try {
                this.scan.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.scan = null;
        }
        this.currentInstant = 0L;
        this.open = false;
    }

    private void setFirstUnflushed() throws StandardException, IOException {
        LogInstant logInstant = this.logFactory.getFirstUnflushedInstant();
        this.firstUnflushed = ((LogCounter)logInstant).getValueAsLong();
        this.firstUnflushedFileNumber = LogCounter.getLogFileNumber(this.firstUnflushed);
        this.firstUnflushedFilePosition = LogCounter.getLogFilePosition(this.firstUnflushed);
        this.setCurrentLogFileFirstUnflushedPosition();
    }

    private void setCurrentLogFileFirstUnflushedPosition() throws IOException {
        if (this.currentLogFileNumber == this.firstUnflushedFileNumber) {
            this.currentLogFileFirstUnflushedPosition = this.firstUnflushedFilePosition;
        } else if (this.currentLogFileNumber < this.firstUnflushedFileNumber) {
            this.currentLogFileFirstUnflushedPosition = this.scan.length();
        } else {
            throw new IOException(MessageService.getTextMessage("L014", new Object[0]));
        }
    }

    private void switchLogFile() throws StandardException {
        try {
            this.readNextRecordLength = false;
            this.scan.close();
            this.scan = null;
            this.scan = this.logFactory.getLogFileAtBeginning(++this.currentLogFileNumber);
            this.setCurrentLogFileFirstUnflushedPosition();
        }
        catch (IOException iOException) {
            throw this.logFactory.markCorrupt(StandardException.newException("XSLA2.D", iOException, new Object[0]));
        }
    }

    private boolean currentLogFileHasUnflushedRecord() throws IOException {
        long l2 = this.scan.getFilePointer();
        if (!this.readNextRecordLength) {
            if (l2 + 4L > this.currentLogFileFirstUnflushedPosition) {
                return false;
            }
            this.nextRecordLength = this.scan.readInt();
            l2 += 4L;
            this.readNextRecordLength = true;
        }
        if (this.nextRecordLength == 0) {
            return false;
        }
        int n2 = this.nextRecordLength + 4;
        if (l2 + (long)n2 > this.currentLogFileFirstUnflushedPosition) {
            return false;
        }
        this.readNextRecordLength = false;
        return true;
    }

    private boolean positionToNextRecord() throws StandardException, IOException {
        if (this.currentLogFileHasUnflushedRecord()) {
            return true;
        }
        this.setFirstUnflushed();
        if (this.currentLogFileHasUnflushedRecord()) {
            return true;
        }
        while (this.currentLogFileNumber < this.firstUnflushedFileNumber) {
            this.switchLogFile();
            if (!this.currentLogFileHasUnflushedRecord()) continue;
            return true;
        }
        this.currentInstant = 0L;
        return false;
    }
}

