/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.log;

import java.io.IOException;
import java.io.SyncFailedException;
import java.util.LinkedList;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.ArrayOutputStream;
import org.apache.derby.iapi.services.io.FormatIdOutputStream;
import org.apache.derby.iapi.store.replication.master.MasterFactory;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.impl.store.raw.log.ChecksumOperation;
import org.apache.derby.impl.store.raw.log.LogAccessFileBuffer;
import org.apache.derby.impl.store.raw.log.LogCounter;
import org.apache.derby.impl.store.raw.log.LogRecord;
import org.apache.derby.impl.store.raw.log.LogToFile;
import org.apache.derby.io.StorageRandomAccessFile;

public class LogAccessFile {
    private static final int LOG_RECORD_FIXED_OVERHEAD_SIZE = 16;
    private static final int LOG_RECORD_HEADER_SIZE = 12;
    private static final int LOG_RECORD_TRAILER_SIZE = 4;
    private static final int LOG_NUMBER_LOG_BUFFERS = 3;
    private LinkedList<LogAccessFileBuffer> freeBuffers;
    private LinkedList<LogAccessFileBuffer> dirtyBuffers;
    private LogAccessFileBuffer currentBuffer;
    private boolean flushInProgress = false;
    private final StorageRandomAccessFile log;
    private final Object logFileSemaphore;
    static int mon_numWritesToLog;
    static int mon_numBytesToLog;
    MasterFactory masterFac;
    boolean inReplicationMasterMode = false;
    boolean inReplicationSlaveMode = false;
    private ArrayOutputStream logOutputBuffer;
    private FormatIdOutputStream logicalOut;
    private long checksumInstant = -1L;
    private int checksumLength;
    private int checksumLogRecordSize;
    private boolean writeChecksum;
    private ChecksumOperation checksumLogOperation;
    private LogRecord checksumLogRecord;
    private LogToFile logFactory;
    private boolean databaseEncrypted = false;

    public LogAccessFile(LogToFile logToFile, StorageRandomAccessFile storageRandomAccessFile, int n2) {
        logToFile.checkForReplication(this);
        this.log = storageRandomAccessFile;
        this.logFileSemaphore = storageRandomAccessFile;
        this.logFactory = logToFile;
        this.freeBuffers = new LinkedList();
        this.dirtyBuffers = new LinkedList();
        for (int i2 = 0; i2 < 3; ++i2) {
            LogAccessFileBuffer logAccessFileBuffer = new LogAccessFileBuffer(n2);
            this.freeBuffers.addLast(logAccessFileBuffer);
        }
        this.currentBuffer = this.freeBuffers.removeFirst();
        this.writeChecksum = logToFile.checkVersion(10, 1);
        if (this.inReplicationSlaveMode) {
            this.writeChecksum = false;
        }
        if (this.writeChecksum) {
            this.checksumLogOperation = new ChecksumOperation();
            this.checksumLogOperation.init();
            this.checksumLogRecord = new LogRecord();
            this.checksumLogRecord.setValue(null, this.checksumLogOperation);
            this.checksumLength = LogRecord.getStoredSize(this.checksumLogOperation.group(), null) + this.checksumLogOperation.getStoredSize();
            if (logToFile.databaseEncrypted()) {
                this.checksumLength = logToFile.getEncryptedDataLength(this.checksumLength);
                this.databaseEncrypted = true;
            }
            this.checksumLogRecordSize = this.checksumLength + 16;
            this.logOutputBuffer = new ArrayOutputStream();
            this.logicalOut = new FormatIdOutputStream(this.logOutputBuffer);
        } else {
            this.checksumLogRecordSize = 0;
        }
        this.currentBuffer.init(this.checksumLogRecordSize);
    }

    public void writeLogRecord(int n2, long l2, byte[] byArray, int n3, byte[] byArray2, int n4, int n5) throws StandardException, IOException {
        int n6 = n2 + 16;
        if (n6 <= this.currentBuffer.bytes_free) {
            int n7;
            this.currentBuffer.position = n7 = this.appendLogRecordToBuffer(this.currentBuffer.buffer, this.currentBuffer.position, n2, l2, byArray, n3, byArray2, n4, n5);
            this.currentBuffer.bytes_free -= n6;
            this.currentBuffer.greatest_instant = l2;
        } else {
            int n8 = this.checksumLogRecordSize + n6;
            byte[] byArray3 = new byte[n8];
            this.appendLogRecordToBuffer(byArray3, this.checksumLogRecordSize, n2, l2, byArray, n3, byArray2, n4, n5);
            if (this.writeChecksum) {
                this.checksumLogOperation.reset();
                this.checksumLogOperation.update(byArray3, this.checksumLogRecordSize, n6);
                this.writeChecksumLogRecord(byArray3);
            }
            this.flushLogAccessFile();
            this.writeToLog(byArray3, 0, n8, l2);
        }
    }

    private int appendLogRecordToBuffer(byte[] byArray, int n2, int n3, long l2, byte[] byArray2, int n4, byte[] byArray3, int n5, int n6) {
        n2 = this.writeInt(n3, byArray, n2);
        n2 = this.writeLong(l2, byArray, n2);
        int n7 = n3 - n6;
        System.arraycopy(byArray2, n4, byArray, n2, n7);
        n2 += n7;
        if (n6 != 0) {
            System.arraycopy(byArray3, n5, byArray, n2, n6);
            n2 += n6;
        }
        n2 = this.writeInt(n3, byArray, n2);
        return n2;
    }

    private final int writeInt(int n2, byte[] byArray, int n3) {
        byArray[n3++] = (byte)(n2 >>> 24 & 0xFF);
        byArray[n3++] = (byte)(n2 >>> 16 & 0xFF);
        byArray[n3++] = (byte)(n2 >>> 8 & 0xFF);
        byArray[n3++] = (byte)(n2 & 0xFF);
        return n3;
    }

    private final int writeLong(long l2, byte[] byArray, int n2) {
        byArray[n2++] = (byte)((int)(l2 >>> 56) & 0xFF);
        byArray[n2++] = (byte)((int)(l2 >>> 48) & 0xFF);
        byArray[n2++] = (byte)((int)(l2 >>> 40) & 0xFF);
        byArray[n2++] = (byte)((int)(l2 >>> 32) & 0xFF);
        byArray[n2++] = (byte)((int)(l2 >>> 24) & 0xFF);
        byArray[n2++] = (byte)((int)(l2 >>> 16) & 0xFF);
        byArray[n2++] = (byte)((int)(l2 >>> 8) & 0xFF);
        byArray[n2++] = (byte)((int)l2 & 0xFF);
        return n2;
    }

    public void writeInt(int n2) {
        this.currentBuffer.position = this.writeInt(n2, this.currentBuffer.buffer, this.currentBuffer.position);
        this.currentBuffer.bytes_free -= 4;
    }

    public void writeLong(long l2) {
        this.currentBuffer.position = this.writeLong(l2, this.currentBuffer.buffer, this.currentBuffer.position);
        this.currentBuffer.bytes_free -= 8;
    }

    public void write(int n2) {
        this.currentBuffer.buffer[this.currentBuffer.position++] = (byte)n2;
        --this.currentBuffer.bytes_free;
    }

    public void write(byte[] byArray, int n2, int n3) {
        System.arraycopy(byArray, n2, this.currentBuffer.buffer, this.currentBuffer.position, n3);
        this.currentBuffer.bytes_free -= n3;
        this.currentBuffer.position += n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void flushDirtyBuffers() throws IOException {
        LogAccessFile logAccessFile;
        LogAccessFileBuffer logAccessFileBuffer = null;
        int n2 = 0;
        try {
            int n3;
            logAccessFile = this;
            synchronized (logAccessFile) {
                while (this.flushInProgress) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        InterruptStatus.setInterrupted();
                    }
                }
                n3 = this.dirtyBuffers.size();
                if (n3 > 0) {
                    logAccessFileBuffer = this.dirtyBuffers.removeFirst();
                }
                this.flushInProgress = true;
            }
            while (n2 < n3) {
                if (logAccessFileBuffer.position != 0) {
                    this.writeToLog(logAccessFileBuffer.buffer, 0, logAccessFileBuffer.position, logAccessFileBuffer.greatest_instant);
                }
                logAccessFile = this;
                synchronized (logAccessFile) {
                    this.freeBuffers.addLast(logAccessFileBuffer);
                    if (++n2 < n3) {
                        logAccessFileBuffer = this.dirtyBuffers.removeFirst();
                    } else {
                        int n4 = this.dirtyBuffers.size();
                        if (n4 > 0 && n2 <= 3) {
                            n3 += n4;
                            logAccessFileBuffer = this.dirtyBuffers.removeFirst();
                        }
                    }
                }
            }
            return;
        }
        finally {
            logAccessFile = this;
            synchronized (logAccessFile) {
                this.flushInProgress = false;
                this.notifyAll();
            }
        }
    }

    public void flushLogAccessFile() throws IOException, StandardException {
        this.switchLogBuffer();
        this.flushDirtyBuffers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchLogBuffer() throws IOException, StandardException {
        LogAccessFile logAccessFile = this;
        synchronized (logAccessFile) {
            if (this.currentBuffer.position == this.checksumLogRecordSize) {
                return;
            }
            if (this.writeChecksum) {
                this.checksumLogOperation.reset();
                this.checksumLogOperation.update(this.currentBuffer.buffer, this.checksumLogRecordSize, this.currentBuffer.position - this.checksumLogRecordSize);
                this.writeChecksumLogRecord(this.currentBuffer.buffer);
            }
            this.dirtyBuffers.addLast(this.currentBuffer);
            if (this.freeBuffers.size() == 0) {
                this.flushDirtyBuffers();
            }
            this.currentBuffer = this.freeBuffers.removeFirst();
            this.currentBuffer.init(this.checksumLogRecordSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncLogAccessFile() throws IOException, StandardException {
        int n2 = 0;
        while (true) {
            try {
                LogAccessFile logAccessFile = this;
                synchronized (logAccessFile) {
                    this.log.sync();
                }
            }
            catch (SyncFailedException syncFailedException) {
                ++n2;
                try {
                    Thread.sleep(200L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    InterruptStatus.setInterrupted();
                }
                if (n2 <= 20) continue;
                throw StandardException.newException("XSLA4.D", syncFailedException, new Object[0]);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void corrupt() throws IOException {
        Object object = this.logFileSemaphore;
        synchronized (object) {
            if (this.log != null) {
                this.log.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException, StandardException {
        this.flushLogAccessFile();
        Object object = this.logFileSemaphore;
        synchronized (object) {
            if (this.log != null) {
                this.log.close();
            }
        }
    }

    protected void setReplicationMasterRole(MasterFactory masterFactory) {
        this.masterFac = masterFactory;
        this.inReplicationMasterMode = true;
    }

    protected void stopReplicationMasterRole() {
        this.inReplicationMasterMode = false;
        this.masterFac = null;
    }

    protected void setReplicationSlaveRole() {
        this.inReplicationSlaveMode = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToLog(byte[] byArray, int n2, int n3, long l2) throws IOException {
        Object object = this.logFileSemaphore;
        synchronized (object) {
            if (this.log != null) {
                int n4 = 0;
                while (true) {
                    try {
                        this.log.write(byArray, n2, n3);
                        if (!this.inReplicationMasterMode) break;
                        this.masterFac.appendLog(l2, byArray, n2, n3);
                    }
                    catch (IOException iOException) {
                        if (n4 >= 5) {
                            throw iOException;
                        }
                        ++n4;
                        continue;
                    }
                    break;
                }
            }
        }
    }

    protected long reserveSpaceForChecksum(int n2, long l2, long l3) throws StandardException, IOException {
        int n3 = n2 + 16;
        boolean bl = false;
        if (this.currentBuffer.position == this.checksumLogRecordSize) {
            bl = this.writeChecksum;
        } else if (n3 > this.currentBuffer.bytes_free) {
            this.switchLogBuffer();
            bl = this.writeChecksum;
        }
        if (bl) {
            this.checksumInstant = LogCounter.makeLogInstantAsLong(l2, l3);
            return this.checksumLogRecordSize;
        }
        return 0L;
    }

    private void writeChecksumLogRecord(byte[] byArray) throws IOException, StandardException {
        int n2 = 0;
        n2 = this.writeInt(this.checksumLength, byArray, n2);
        n2 = this.writeLong(this.checksumInstant, byArray, n2);
        this.logOutputBuffer.setData(byArray);
        this.logOutputBuffer.setPosition(n2);
        this.logicalOut.writeObject(this.checksumLogRecord);
        if (this.databaseEncrypted) {
            int n3 = this.logFactory.encrypt(byArray, 12, this.checksumLength, byArray, 12);
        }
        n2 = 12 + this.checksumLength;
        n2 = this.writeInt(this.checksumLength, byArray, n2);
    }

    public int getChecksumLogRecordSize() {
        return this.checksumLogRecordSize;
    }

    protected void writeEndMarker(int n2) throws IOException, StandardException {
        this.flushLogAccessFile();
        byte[] byArray = this.currentBuffer.buffer;
        int n3 = 0;
        n3 = this.writeInt(n2, byArray, n3);
        this.writeToLog(byArray, 0, n3, -1L);
    }
}

