/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.optional;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.derby.iapi.sql.dictionary.OptionalTool;

public class DBMDWrapper
implements OptionalTool {
    private static final int DEFAULT_PRECISION = 128;

    @Override
    public void loadTool(String ... stringArray) throws SQLException {
        this.register(true);
    }

    @Override
    public void unloadTool(String ... stringArray) throws SQLException {
        this.register(false);
    }

    private void register(boolean bl) throws SQLException {
        Connection connection = DBMDWrapper.getDefaultConnection();
        for (Method method : this.getClass().getDeclaredMethods()) {
            int n2 = method.getModifiers();
            if (!this.isSet(n2, 1) || !this.isSet(n2, 8)) continue;
            if (bl) {
                this.registerFunction(connection, method);
                continue;
            }
            this.unregisterFunction(connection, method);
        }
    }

    public static boolean allProceduresAreCallable() throws SQLException {
        return DBMDWrapper.getDBMD().allProceduresAreCallable();
    }

    public static boolean allTablesAreSelectable() throws SQLException {
        return DBMDWrapper.getDBMD().allTablesAreSelectable();
    }

    public static boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return DBMDWrapper.getDBMD().autoCommitFailureClosesAllResultSets();
    }

    public static boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return DBMDWrapper.getDBMD().dataDefinitionCausesTransactionCommit();
    }

    public static boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return DBMDWrapper.getDBMD().dataDefinitionIgnoredInTransactions();
    }

    public static boolean deletesAreDetected(int n2) throws SQLException {
        return DBMDWrapper.getDBMD().deletesAreDetected(n2);
    }

    public static boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return DBMDWrapper.getDBMD().doesMaxRowSizeIncludeBlobs();
    }

    public static ResultSet getAttributes(String string, String string2, String string3, String string4) throws SQLException {
        return DBMDWrapper.getDBMD().getAttributes(string, string2, string3, string4);
    }

    public static ResultSet getBestRowIdentifier(String string, String string2, String string3, int n2, boolean bl) throws SQLException {
        return DBMDWrapper.getDBMD().getBestRowIdentifier(string, string2, string3, n2, bl);
    }

    public static ResultSet getCatalogs() throws SQLException {
        return DBMDWrapper.getDBMD().getCatalogs();
    }

    public static String getCatalogSeparator() throws SQLException {
        return DBMDWrapper.getDBMD().getCatalogSeparator();
    }

    public static String getCatalogTerm() throws SQLException {
        return DBMDWrapper.getDBMD().getCatalogTerm();
    }

    public static ResultSet getClientInfoProperties() throws SQLException {
        return DBMDWrapper.getDBMD().getClientInfoProperties();
    }

    public static ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        return DBMDWrapper.getDBMD().getColumnPrivileges(string, string2, string3, string4);
    }

    public static ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        return DBMDWrapper.getDBMD().getColumns(string, string2, string3, string4);
    }

    public static ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        return DBMDWrapper.getDBMD().getCrossReference(string, string2, string3, string4, string5, string6);
    }

    public static int getDatabaseMajorVersion() throws SQLException {
        return DBMDWrapper.getDBMD().getDatabaseMajorVersion();
    }

    public static int getDatabaseMinorVersion() throws SQLException {
        return DBMDWrapper.getDBMD().getDatabaseMinorVersion();
    }

    public static String getDatabaseProductName() throws SQLException {
        return DBMDWrapper.getDBMD().getDatabaseProductName();
    }

    public static String getDatabaseProductVersion() throws SQLException {
        return DBMDWrapper.getDBMD().getDatabaseProductVersion();
    }

    public static int getDefaultTransactionIsolation() throws SQLException {
        return DBMDWrapper.getDBMD().getDefaultTransactionIsolation();
    }

    public static int getDriverMajorVersion() throws SQLException {
        return DBMDWrapper.getDBMD().getDriverMajorVersion();
    }

    public static int getDriverMinorVersion() throws SQLException {
        return DBMDWrapper.getDBMD().getDriverMinorVersion();
    }

    public static String getDriverName() throws SQLException {
        return DBMDWrapper.getDBMD().getDriverName();
    }

    public static String getDriverVersion() throws SQLException {
        return DBMDWrapper.getDBMD().getDriverVersion();
    }

    public static ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        return DBMDWrapper.getDBMD().getExportedKeys(string, string2, string3);
    }

    public static String getExtraNameCharacters() throws SQLException {
        return DBMDWrapper.getDBMD().getExtraNameCharacters();
    }

    public static ResultSet getFunctionColumns(String string, String string2, String string3, String string4) throws SQLException {
        return DBMDWrapper.getDBMD().getFunctionColumns(string, string2, string3, string4);
    }

    public static ResultSet getFunctions(String string, String string2, String string3) throws SQLException {
        return DBMDWrapper.getDBMD().getFunctions(string, string2, string3);
    }

    public static String getIdentifierQuoteString() throws SQLException {
        return DBMDWrapper.getDBMD().getIdentifierQuoteString();
    }

    public static ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        return DBMDWrapper.getDBMD().getImportedKeys(string, string2, string3);
    }

    public static ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        return DBMDWrapper.getDBMD().getIndexInfo(string, string2, string3, bl, bl2);
    }

    public static int getJDBCMajorVersion() throws SQLException {
        return DBMDWrapper.getDBMD().getJDBCMajorVersion();
    }

    public static int getJDBCMinorVersion() throws SQLException {
        return DBMDWrapper.getDBMD().getJDBCMinorVersion();
    }

    public static int getMaxBinaryLiteralLength() throws SQLException {
        return DBMDWrapper.getDBMD().getMaxBinaryLiteralLength();
    }

    public static int getMaxCatalogNameLength() throws SQLException {
        return DBMDWrapper.getDBMD().getMaxCatalogNameLength();
    }

    public static int getMaxCharLiteralLength() throws SQLException {
        return DBMDWrapper.getDBMD().getMaxCharLiteralLength();
    }

    public static int getMaxColumnNameLength() throws SQLException {
        return DBMDWrapper.getDBMD().getMaxColumnNameLength();
    }

    public static int getMaxColumnsInGroupBy() throws SQLException {
        return DBMDWrapper.getDBMD().getMaxColumnsInGroupBy();
    }

    public static int getMaxColumnsInIndex() throws SQLException {
        return DBMDWrapper.getDBMD().getMaxColumnsInIndex();
    }

    public static int getMaxColumnsInOrderBy() throws SQLException {
        return DBMDWrapper.getDBMD().getMaxColumnsInOrderBy();
    }

    public static int getMaxColumnsInSelect() throws SQLException {
        return DBMDWrapper.getDBMD().getMaxColumnsInSelect();
    }

    public static int getMaxColumnsInTable() throws SQLException {
        return DBMDWrapper.getDBMD().getMaxColumnsInTable();
    }

    public static int getMaxConnections() throws SQLException {
        return DBMDWrapper.getDBMD().getMaxConnections();
    }

    public static int getMaxCursorNameLength() throws SQLException {
        return DBMDWrapper.getDBMD().getMaxCursorNameLength();
    }

    public static int getMaxIndexLength() throws SQLException {
        return DBMDWrapper.getDBMD().getMaxIndexLength();
    }

    public static int getMaxProcedureNameLength() throws SQLException {
        return DBMDWrapper.getDBMD().getMaxProcedureNameLength();
    }

    public static int getMaxRowSize() throws SQLException {
        return DBMDWrapper.getDBMD().getMaxRowSize();
    }

    public static int getMaxSchemaNameLength() throws SQLException {
        return DBMDWrapper.getDBMD().getMaxSchemaNameLength();
    }

    public static int getMaxStatementLength() throws SQLException {
        return DBMDWrapper.getDBMD().getMaxStatementLength();
    }

    public static int getMaxStatements() throws SQLException {
        return DBMDWrapper.getDBMD().getMaxStatements();
    }

    public static int getMaxTableNameLength() throws SQLException {
        return DBMDWrapper.getDBMD().getMaxTableNameLength();
    }

    public static int getMaxTablesInSelect() throws SQLException {
        return DBMDWrapper.getDBMD().getMaxTablesInSelect();
    }

    public static int getMaxUserNameLength() throws SQLException {
        return DBMDWrapper.getDBMD().getMaxUserNameLength();
    }

    public static String getNumericFunctions() throws SQLException {
        return DBMDWrapper.getDBMD().getNumericFunctions();
    }

    public static ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        return DBMDWrapper.getDBMD().getPrimaryKeys(string, string2, string3);
    }

    public static ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        return DBMDWrapper.getDBMD().getProcedureColumns(string, string2, string3, string4);
    }

    public static ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        return DBMDWrapper.getDBMD().getProcedures(string, string2, string3);
    }

    public static String getProcedureTerm() throws SQLException {
        return DBMDWrapper.getDBMD().getProcedureTerm();
    }

    public static int getResultSetHoldability() throws SQLException {
        return DBMDWrapper.getDBMD().getResultSetHoldability();
    }

    public static ResultSet getSchemas(String string, String string2) throws SQLException {
        return DBMDWrapper.getDBMD().getSchemas(string, string2);
    }

    public static String getSchemaTerm() throws SQLException {
        return DBMDWrapper.getDBMD().getSchemaTerm();
    }

    public static String getSearchStringEscape() throws SQLException {
        return DBMDWrapper.getDBMD().getSearchStringEscape();
    }

    public static String getSQLKeywords() throws SQLException {
        return DBMDWrapper.getDBMD().getSQLKeywords();
    }

    public static int getSQLStateType() throws SQLException {
        return DBMDWrapper.getDBMD().getSQLStateType();
    }

    public static String getStringFunctions() throws SQLException {
        return DBMDWrapper.getDBMD().getStringFunctions();
    }

    public static ResultSet getSuperTables(String string, String string2, String string3) throws SQLException {
        return DBMDWrapper.getDBMD().getSuperTables(string, string2, string3);
    }

    public static ResultSet getSuperTypes(String string, String string2, String string3) throws SQLException {
        return DBMDWrapper.getDBMD().getSuperTypes(string, string2, string3);
    }

    public static String getSystemFunctions() throws SQLException {
        return DBMDWrapper.getDBMD().getSystemFunctions();
    }

    public static ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        return DBMDWrapper.getDBMD().getTablePrivileges(string, string2, string3);
    }

    public static ResultSet getTables(String string, String string2, String string3) throws SQLException {
        return DBMDWrapper.getDBMD().getTables(string, string2, string3, null);
    }

    public static ResultSet getTableTypes() throws SQLException {
        return DBMDWrapper.getDBMD().getTableTypes();
    }

    public static String getTimeDateFunctions() throws SQLException {
        return DBMDWrapper.getDBMD().getTimeDateFunctions();
    }

    public static ResultSet getTypeInfo() throws SQLException {
        return DBMDWrapper.getDBMD().getTypeInfo();
    }

    public static ResultSet getUDTs(String string, String string2, String string3) throws SQLException {
        return DBMDWrapper.getDBMD().getUDTs(string, string2, string3, null);
    }

    public static String getURL() throws SQLException {
        return DBMDWrapper.getDBMD().getURL();
    }

    public static String getUserName() throws SQLException {
        return DBMDWrapper.getDBMD().getUserName();
    }

    public static ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        return DBMDWrapper.getDBMD().getVersionColumns(string, string2, string3);
    }

    public static boolean insertsAreDetected(int n2) throws SQLException {
        return DBMDWrapper.getDBMD().insertsAreDetected(n2);
    }

    public static boolean isCatalogAtStart() throws SQLException {
        return DBMDWrapper.getDBMD().isCatalogAtStart();
    }

    public static boolean isReadOnly() throws SQLException {
        return DBMDWrapper.getDBMD().isReadOnly();
    }

    public static boolean locatorsUpdateCopy() throws SQLException {
        return DBMDWrapper.getDBMD().locatorsUpdateCopy();
    }

    public static boolean nullPlusNonNullIsNull() throws SQLException {
        return DBMDWrapper.getDBMD().nullPlusNonNullIsNull();
    }

    public static boolean nullsAreSortedAtEnd() throws SQLException {
        return DBMDWrapper.getDBMD().nullsAreSortedAtEnd();
    }

    public static boolean nullsAreSortedAtStart() throws SQLException {
        return DBMDWrapper.getDBMD().nullsAreSortedAtStart();
    }

    public static boolean nullsAreSortedHigh() throws SQLException {
        return DBMDWrapper.getDBMD().nullsAreSortedHigh();
    }

    public static boolean nullsAreSortedLow() throws SQLException {
        return DBMDWrapper.getDBMD().nullsAreSortedLow();
    }

    public static boolean othersDeletesAreVisible(int n2) throws SQLException {
        return DBMDWrapper.getDBMD().othersDeletesAreVisible(n2);
    }

    public static boolean othersInsertsAreVisible(int n2) throws SQLException {
        return DBMDWrapper.getDBMD().othersInsertsAreVisible(n2);
    }

    public static boolean othersUpdatesAreVisible(int n2) throws SQLException {
        return DBMDWrapper.getDBMD().othersUpdatesAreVisible(n2);
    }

    public static boolean ownDeletesAreVisible(int n2) throws SQLException {
        return DBMDWrapper.getDBMD().ownDeletesAreVisible(n2);
    }

    public static boolean ownInsertsAreVisible(int n2) throws SQLException {
        return DBMDWrapper.getDBMD().ownInsertsAreVisible(n2);
    }

    public static boolean ownUpdatesAreVisible(int n2) throws SQLException {
        return DBMDWrapper.getDBMD().ownUpdatesAreVisible(n2);
    }

    public static boolean storesLowerCaseIdentifiers() throws SQLException {
        return DBMDWrapper.getDBMD().storesLowerCaseIdentifiers();
    }

    public static boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return DBMDWrapper.getDBMD().storesLowerCaseQuotedIdentifiers();
    }

    public static boolean storesMixedCaseIdentifiers() throws SQLException {
        return DBMDWrapper.getDBMD().storesMixedCaseIdentifiers();
    }

    public static boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return DBMDWrapper.getDBMD().storesMixedCaseQuotedIdentifiers();
    }

    public static boolean storesUpperCaseIdentifiers() throws SQLException {
        return DBMDWrapper.getDBMD().storesUpperCaseIdentifiers();
    }

    public static boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return DBMDWrapper.getDBMD().storesUpperCaseQuotedIdentifiers();
    }

    public static boolean supportsAlterTableWithAddColumn() throws SQLException {
        return DBMDWrapper.getDBMD().supportsAlterTableWithAddColumn();
    }

    public static boolean supportsAlterTableWithDropColumn() throws SQLException {
        return DBMDWrapper.getDBMD().supportsAlterTableWithDropColumn();
    }

    public static boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return DBMDWrapper.getDBMD().supportsANSI92EntryLevelSQL();
    }

    public static boolean supportsANSI92FullSQL() throws SQLException {
        return DBMDWrapper.getDBMD().supportsANSI92FullSQL();
    }

    public static boolean supportsANSI92IntermediateSQL() throws SQLException {
        return DBMDWrapper.getDBMD().supportsANSI92IntermediateSQL();
    }

    public static boolean supportsBatchUpdates() throws SQLException {
        return DBMDWrapper.getDBMD().supportsBatchUpdates();
    }

    public static boolean supportsCatalogsInDataManipulation() throws SQLException {
        return DBMDWrapper.getDBMD().supportsCatalogsInDataManipulation();
    }

    public static boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return DBMDWrapper.getDBMD().supportsCatalogsInIndexDefinitions();
    }

    public static boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return DBMDWrapper.getDBMD().supportsCatalogsInPrivilegeDefinitions();
    }

    public static boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return DBMDWrapper.getDBMD().supportsCatalogsInProcedureCalls();
    }

    public static boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return DBMDWrapper.getDBMD().supportsCatalogsInTableDefinitions();
    }

    public static boolean supportsColumnAliasing() throws SQLException {
        return DBMDWrapper.getDBMD().supportsColumnAliasing();
    }

    public static boolean supportsConvert(int n2, int n3) throws SQLException {
        return DBMDWrapper.getDBMD().supportsConvert(n2, n3);
    }

    public static boolean supportsCoreSQLGrammar() throws SQLException {
        return DBMDWrapper.getDBMD().supportsCoreSQLGrammar();
    }

    public static boolean supportsCorrelatedSubqueries() throws SQLException {
        return DBMDWrapper.getDBMD().supportsCorrelatedSubqueries();
    }

    public static boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return DBMDWrapper.getDBMD().supportsDataDefinitionAndDataManipulationTransactions();
    }

    public static boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return DBMDWrapper.getDBMD().supportsDataManipulationTransactionsOnly();
    }

    public static boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return DBMDWrapper.getDBMD().supportsDifferentTableCorrelationNames();
    }

    public static boolean supportsExpressionsInOrderBy() throws SQLException {
        return DBMDWrapper.getDBMD().supportsExpressionsInOrderBy();
    }

    public static boolean supportsExtendedSQLGrammar() throws SQLException {
        return DBMDWrapper.getDBMD().supportsExtendedSQLGrammar();
    }

    public static boolean supportsFullOuterJoins() throws SQLException {
        return DBMDWrapper.getDBMD().supportsFullOuterJoins();
    }

    public static boolean supportsGetGeneratedKeys() throws SQLException {
        return DBMDWrapper.getDBMD().supportsGetGeneratedKeys();
    }

    public static boolean supportsGroupBy() throws SQLException {
        return DBMDWrapper.getDBMD().supportsGroupBy();
    }

    public static boolean supportsGroupByBeyondSelect() throws SQLException {
        return DBMDWrapper.getDBMD().supportsGroupByBeyondSelect();
    }

    public static boolean supportsGroupByUnrelated() throws SQLException {
        return DBMDWrapper.getDBMD().supportsGroupByUnrelated();
    }

    public static boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return DBMDWrapper.getDBMD().supportsIntegrityEnhancementFacility();
    }

    public static boolean supportsLikeEscapeClause() throws SQLException {
        return DBMDWrapper.getDBMD().supportsLikeEscapeClause();
    }

    public static boolean supportsLimitedOuterJoins() throws SQLException {
        return DBMDWrapper.getDBMD().supportsLimitedOuterJoins();
    }

    public static boolean supportsMinimumSQLGrammar() throws SQLException {
        return DBMDWrapper.getDBMD().supportsMinimumSQLGrammar();
    }

    public static boolean supportsMixedCaseIdentifiers() throws SQLException {
        return DBMDWrapper.getDBMD().supportsMixedCaseIdentifiers();
    }

    public static boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return DBMDWrapper.getDBMD().supportsMixedCaseQuotedIdentifiers();
    }

    public static boolean supportsMultipleOpenResults() throws SQLException {
        return DBMDWrapper.getDBMD().supportsMultipleOpenResults();
    }

    public static boolean supportsMultipleResultSets() throws SQLException {
        return DBMDWrapper.getDBMD().supportsMultipleResultSets();
    }

    public static boolean supportsMultipleTransactions() throws SQLException {
        return DBMDWrapper.getDBMD().supportsMultipleTransactions();
    }

    public static boolean supportsNamedParameters() throws SQLException {
        return DBMDWrapper.getDBMD().supportsNamedParameters();
    }

    public static boolean supportsNonNullableColumns() throws SQLException {
        return DBMDWrapper.getDBMD().supportsNonNullableColumns();
    }

    public static boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return DBMDWrapper.getDBMD().supportsOpenCursorsAcrossCommit();
    }

    public static boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return DBMDWrapper.getDBMD().supportsOpenCursorsAcrossRollback();
    }

    public static boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return DBMDWrapper.getDBMD().supportsOpenStatementsAcrossCommit();
    }

    public static boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return DBMDWrapper.getDBMD().supportsOpenStatementsAcrossRollback();
    }

    public static boolean supportsOrderByUnrelated() throws SQLException {
        return DBMDWrapper.getDBMD().supportsOrderByUnrelated();
    }

    public static boolean supportsOuterJoins() throws SQLException {
        return DBMDWrapper.getDBMD().supportsOuterJoins();
    }

    public static boolean supportsPositionedDelete() throws SQLException {
        return DBMDWrapper.getDBMD().supportsPositionedDelete();
    }

    public static boolean supportsPositionedUpdate() throws SQLException {
        return DBMDWrapper.getDBMD().supportsPositionedUpdate();
    }

    public static boolean supportsResultSetConcurrency(int n2, int n3) throws SQLException {
        return DBMDWrapper.getDBMD().supportsResultSetConcurrency(n2, n3);
    }

    public static boolean supportsResultSetHoldability(int n2) throws SQLException {
        return DBMDWrapper.getDBMD().supportsResultSetHoldability(n2);
    }

    public static boolean supportsResultSetType(int n2) throws SQLException {
        return DBMDWrapper.getDBMD().supportsResultSetType(n2);
    }

    public static boolean supportsSavepoints() throws SQLException {
        return DBMDWrapper.getDBMD().supportsSavepoints();
    }

    public static boolean supportsSchemasInDataManipulation() throws SQLException {
        return DBMDWrapper.getDBMD().supportsSchemasInDataManipulation();
    }

    public static boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return DBMDWrapper.getDBMD().supportsSchemasInIndexDefinitions();
    }

    public static boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return DBMDWrapper.getDBMD().supportsSchemasInPrivilegeDefinitions();
    }

    public static boolean supportsSchemasInProcedureCalls() throws SQLException {
        return DBMDWrapper.getDBMD().supportsSchemasInProcedureCalls();
    }

    public static boolean supportsSchemasInTableDefinitions() throws SQLException {
        return DBMDWrapper.getDBMD().supportsSchemasInTableDefinitions();
    }

    public static boolean supportsSelectForUpdate() throws SQLException {
        return DBMDWrapper.getDBMD().supportsSelectForUpdate();
    }

    public static boolean supportsStatementPooling() throws SQLException {
        return DBMDWrapper.getDBMD().supportsStatementPooling();
    }

    public static boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return DBMDWrapper.getDBMD().supportsStoredFunctionsUsingCallSyntax();
    }

    public static boolean supportsStoredProcedures() throws SQLException {
        return DBMDWrapper.getDBMD().supportsStoredProcedures();
    }

    public static boolean supportsSubqueriesInComparisons() throws SQLException {
        return DBMDWrapper.getDBMD().supportsSubqueriesInComparisons();
    }

    public static boolean supportsSubqueriesInExists() throws SQLException {
        return DBMDWrapper.getDBMD().supportsSubqueriesInExists();
    }

    public static boolean supportsSubqueriesInIns() throws SQLException {
        return DBMDWrapper.getDBMD().supportsSubqueriesInIns();
    }

    public static boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return DBMDWrapper.getDBMD().supportsSubqueriesInQuantifieds();
    }

    public static boolean supportsTableCorrelationNames() throws SQLException {
        return DBMDWrapper.getDBMD().supportsTableCorrelationNames();
    }

    public static boolean supportsTransactionIsolationLevel(int n2) throws SQLException {
        return DBMDWrapper.getDBMD().supportsTransactionIsolationLevel(n2);
    }

    public static boolean supportsTransactions() throws SQLException {
        return DBMDWrapper.getDBMD().supportsTransactions();
    }

    public static boolean supportsUnion() throws SQLException {
        return DBMDWrapper.getDBMD().supportsUnion();
    }

    public static boolean supportsUnionAll() throws SQLException {
        return DBMDWrapper.getDBMD().supportsUnionAll();
    }

    public static boolean updatesAreDetected(int n2) throws SQLException {
        return DBMDWrapper.getDBMD().updatesAreDetected(n2);
    }

    public static boolean usesLocalFilePerTable() throws SQLException {
        return DBMDWrapper.getDBMD().usesLocalFilePerTable();
    }

    public static boolean usesLocalFiles() throws SQLException {
        return DBMDWrapper.getDBMD().usesLocalFiles();
    }

    private boolean isSet(int n2, int n3) {
        return (n2 & n3) != 0;
    }

    private void unregisterFunction(Connection connection, Method method) throws SQLException {
        try {
            DBMDWrapper.executeDDL(connection, "drop function " + method.getName());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void registerFunction(Connection connection, Method method) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = method.getName();
        boolean bl = this.isTableFunction(method);
        stringBuffer.append("create function " + string + "\n(");
        this.appendArgs(stringBuffer, method);
        stringBuffer.append("\n)\n");
        stringBuffer.append("returns ");
        this.appendReturnType(stringBuffer, connection, method);
        stringBuffer.append("\nlanguage java\nreads sql data\nparameter style ");
        if (bl) {
            stringBuffer.append("DERBY_JDBC_RESULT_SET");
        } else {
            stringBuffer.append("java");
        }
        stringBuffer.append("\nexternal name '" + this.getClass().getName() + "." + string + "'");
        DBMDWrapper.executeDDL(connection, stringBuffer.toString());
    }

    private boolean isTableFunction(Method method) {
        Class<?> clazz = method.getReturnType();
        return clazz == ResultSet.class;
    }

    private void appendArgs(StringBuffer stringBuffer, Method method) throws SQLException {
        Class<?>[] classArray = method.getParameterTypes();
        int n2 = classArray.length;
        String string = "a_";
        for (int i2 = 0; i2 < n2; ++i2) {
            Class<?> clazz = classArray[i2];
            if (i2 > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append("\n\t");
            stringBuffer.append(string + i2);
            stringBuffer.append(' ');
            stringBuffer.append(this.mapJavaToSQLType(clazz));
        }
    }

    private void appendReturnType(StringBuffer stringBuffer, Connection connection, Method method) throws SQLException {
        Class<?> clazz = method.getReturnType();
        if (ResultSet.class == clazz) {
            this.appendTableFunctionSignature(stringBuffer, connection, method);
        } else {
            stringBuffer.append(this.mapJavaToSQLType(clazz));
        }
    }

    private void appendTableFunctionSignature(StringBuffer stringBuffer, Connection connection, Method method) throws SQLException {
        ResultSet resultSet;
        stringBuffer.append("table\n(");
        Class<?>[] classArray = method.getParameterTypes();
        int n2 = classArray.length;
        Object[] objectArray = new Object[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            objectArray[i2] = this.getDummyValue(classArray[i2]);
        }
        try {
            resultSet = (ResultSet)method.invoke(null, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw DBMDWrapper.wrap(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw DBMDWrapper.wrap(invocationTargetException);
        }
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n3 = resultSetMetaData.getColumnCount();
        for (int i3 = 0; i3 < n3; ++i3) {
            int n4 = i3 + 1;
            if (i3 > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append("\n\t");
            stringBuffer.append(resultSetMetaData.getColumnName(n4));
            stringBuffer.append("\t");
            this.stringifyJDBCType(stringBuffer, resultSetMetaData, n4);
        }
        stringBuffer.append("\n)");
    }

    private Object getDummyValue(Class clazz) {
        if (String.class == clazz) {
            return "";
        }
        if (Integer.TYPE == clazz) {
            return 1;
        }
        if (Short.TYPE == clazz) {
            return (short)1;
        }
        if (Boolean.TYPE == clazz) {
            return Boolean.TRUE;
        }
        return null;
    }

    private void stringifyJDBCType(StringBuffer stringBuffer, ResultSetMetaData resultSetMetaData, int n2) throws SQLException {
        switch (resultSetMetaData.getColumnType(n2)) {
            case 1: 
            case 12: {
                stringBuffer.append(resultSetMetaData.getColumnTypeName(n2));
                stringBuffer.append("( ");
                int n3 = resultSetMetaData.getPrecision(n2);
                if (n3 <= 0) {
                    n3 = 128;
                }
                stringBuffer.append(n3);
                stringBuffer.append(" )");
                break;
            }
            default: {
                stringBuffer.append(resultSetMetaData.getColumnTypeName(n2));
            }
        }
    }

    private String mapJavaToSQLType(Class clazz) throws SQLException {
        if (Short.TYPE == clazz) {
            return "smallint";
        }
        if (Integer.TYPE == clazz) {
            return "int";
        }
        if (Boolean.TYPE == clazz) {
            return "boolean";
        }
        if (String.class == clazz) {
            return "varchar( 32672 )";
        }
        throw new SQLException("Unsupported type: " + clazz.getName());
    }

    private static DatabaseMetaData getDBMD() throws SQLException {
        return DBMDWrapper.getDefaultConnection().getMetaData();
    }

    private static Connection getDefaultConnection() throws SQLException {
        return DriverManager.getConnection("jdbc:default:connection");
    }

    private static void executeDDL(Connection connection, String string) throws SQLException {
        try (PreparedStatement preparedStatement = null;){
            preparedStatement = DBMDWrapper.prepareStatement(connection, string);
            preparedStatement.execute();
        }
    }

    private static PreparedStatement prepareStatement(Connection connection, String string) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        return preparedStatement;
    }

    private static SQLException wrap(Throwable throwable) {
        return new SQLException(throwable.getMessage(), throwable);
    }
}

