/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.Block;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ExtendedBlock {
    private String poolId;
    private Block block;

    public ExtendedBlock() {
        this(null, 0L, 0L, 0L);
    }

    public ExtendedBlock(ExtendedBlock b2) {
        this(b2.poolId, new Block(b2.block));
    }

    public ExtendedBlock(String poolId, long blockId) {
        this(poolId, blockId, 0L, 0L);
    }

    public ExtendedBlock(String poolId, Block b2) {
        this.poolId = poolId != null ? poolId.intern() : null;
        this.block = b2;
    }

    public ExtendedBlock(String poolId, long blkid, long len, long genstamp) {
        this.poolId = poolId != null ? poolId.intern() : null;
        this.block = new Block(blkid, len, genstamp);
    }

    public String getBlockPoolId() {
        return this.poolId;
    }

    public String getBlockName() {
        return this.block.getBlockName();
    }

    public long getNumBytes() {
        return this.block.getNumBytes();
    }

    public long getBlockId() {
        return this.block.getBlockId();
    }

    public long getGenerationStamp() {
        return this.block.getGenerationStamp();
    }

    public void setBlockId(long bid) {
        this.block.setBlockId(bid);
    }

    public void setGenerationStamp(long genStamp) {
        this.block.setGenerationStamp(genStamp);
    }

    public void setNumBytes(long len) {
        this.block.setNumBytes(len);
    }

    public void set(String poolId, Block blk) {
        this.poolId = poolId != null ? poolId.intern() : null;
        this.block = blk;
    }

    public static Block getLocalBlock(ExtendedBlock b2) {
        return b2 == null ? null : b2.getLocalBlock();
    }

    public Block getLocalBlock() {
        return this.block;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof ExtendedBlock)) {
            return false;
        }
        ExtendedBlock b2 = (ExtendedBlock)o2;
        return b2.block.equals(this.block) && (b2.poolId != null ? b2.poolId.equals(this.poolId) : this.poolId == null);
    }

    public int hashCode() {
        return new HashCodeBuilder(31, 17).append(this.poolId).append(this.block).toHashCode();
    }

    public String toString() {
        return this.poolId + ":" + this.block;
    }
}

