/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web.resources;

import org.apache.hadoop.hdfs.web.resources.Param;

abstract class IntegerParam
extends Param<Integer, Domain> {
    IntegerParam(Domain domain, Integer value, Integer min2, Integer max) {
        super(domain, value);
        this.checkRange(min2, max);
    }

    private void checkRange(Integer min2, Integer max) {
        if (this.value == null) {
            return;
        }
        if (min2 != null && (Integer)this.value < min2) {
            throw new IllegalArgumentException("Invalid parameter range: " + this.getName() + " = " + ((Domain)this.domain).toString((Integer)this.value) + " < " + ((Domain)this.domain).toString(min2));
        }
        if (max != null && (Integer)this.value > max) {
            throw new IllegalArgumentException("Invalid parameter range: " + this.getName() + " = " + ((Domain)this.domain).toString((Integer)this.value) + " > " + ((Domain)this.domain).toString(max));
        }
    }

    @Override
    public String toString() {
        return this.getName() + "=" + ((Domain)this.domain).toString((Integer)this.getValue());
    }

    @Override
    public String getValueString() {
        return ((Domain)this.domain).toString((Integer)this.getValue());
    }

    static final class Domain
    extends Param.Domain<Integer> {
        final int radix;

        Domain(String paramName) {
            this(paramName, 10);
        }

        Domain(String paramName, int radix) {
            super(paramName);
            this.radix = radix;
        }

        @Override
        public String getDomain() {
            return "<null | int in radix " + this.radix + ">";
        }

        @Override
        Integer parse(String str) {
            try {
                return "null".equals(str) || str == null ? null : Integer.valueOf(Integer.parseInt(str, this.radix));
            }
            catch (NumberFormatException e2) {
                throw new IllegalArgumentException("Failed to parse \"" + str + "\" as a radix-" + this.radix + " integer.", e2);
            }
        }

        String toString(Integer n2) {
            return n2 == null ? "null" : Integer.toString(n2, this.radix);
        }
    }
}

