/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web.resources;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Comparator;

public abstract class Param<T, D extends Domain<T>> {
    static final String NULL = "null";
    static final Comparator<Param<?, ?>> NAME_CMP = new Comparator<Param<?, ?>>(){

        @Override
        public int compare(Param<?, ?> left, Param<?, ?> right) {
            return left.getName().compareTo(right.getName());
        }
    };
    final D domain;
    final T value;

    public static String toSortedString(String separator, Param<?, ?> ... parameters) {
        Arrays.sort(parameters, NAME_CMP);
        StringBuilder b2 = new StringBuilder();
        try {
            for (Param<?, ?> p2 : parameters) {
                if (p2.getValue() == null) continue;
                b2.append(separator).append(URLEncoder.encode(p2.getName(), "UTF-8")).append("=").append(URLEncoder.encode(p2.getValueString(), "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e2) {
            throw new RuntimeException(e2);
        }
        return b2.toString();
    }

    Param(D domain, T value) {
        this.domain = domain;
        this.value = value;
    }

    public final T getValue() {
        return this.value;
    }

    public abstract String getValueString();

    public abstract String getName();

    public String toString() {
        return this.getName() + "=" + this.value;
    }

    static abstract class Domain<T> {
        final String paramName;

        Domain(String paramName) {
            this.paramName = paramName;
        }

        public final String getParamName() {
            return this.paramName;
        }

        public abstract String getDomain();

        abstract T parse(String var1);

        public final T parse(String varName, String str) {
            try {
                return str != null && str.trim().length() > 0 ? (T)this.parse(str) : null;
            }
            catch (Exception e2) {
                throw new IllegalArgumentException("Failed to parse \"" + str + "\" for the parameter " + varName + ".  The value must be in the domain " + this.getDomain(), e2);
            }
        }
    }
}

