/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Collections;
import java.util.List;
import org.codehaus.plexus.archiver.AbstractArchiveFinalizer;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class DotDirectiveArchiveFinalizer
extends AbstractArchiveFinalizer {
    private static final String DEFAULT_DOT_FILE_PREFIX = ".plxarc";
    private final File dotFileDirectory;
    private final String dotFilePrefix;

    public DotDirectiveArchiveFinalizer(File dotFileDirectory) {
        this(dotFileDirectory, DEFAULT_DOT_FILE_PREFIX);
    }

    public DotDirectiveArchiveFinalizer(File dotFileDirectory, String dotFilePrefix) {
        this.dotFileDirectory = dotFileDirectory;
        this.dotFilePrefix = dotFilePrefix;
    }

    @Override
    public void finalizeArchiveCreation(Archiver archiver) throws ArchiverException {
        try {
            List<File> dotFiles = FileUtils.getFiles(this.dotFileDirectory, this.dotFilePrefix + "*", null);
            for (File dotFile : dotFiles) {
                BufferedReader in = Files.newBufferedReader(dotFile.toPath(), StandardCharsets.UTF_8);
                Throwable throwable = null;
                try {
                    String line = in.readLine();
                    while (line != null) {
                        File directory;
                        String[] s2 = StringUtils.split(line, ":");
                        if (s2.length == 1) {
                            directory = new File(this.dotFileDirectory, s2[0]);
                            System.out.println("adding directory = " + directory);
                            archiver.addDirectory(directory);
                        } else {
                            directory = new File(this.dotFileDirectory, s2[0]);
                            System.out.println("adding directory = " + directory + " to: " + s2[1]);
                            if (s2[1].endsWith("/")) {
                                archiver.addDirectory(directory, s2[1]);
                            } else {
                                archiver.addDirectory(directory, s2[1] + "/");
                            }
                        }
                        line = in.readLine();
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
        }
        catch (IOException e2) {
            throw new ArchiverException("Error processing dot files.", e2);
        }
    }

    @Override
    public List getVirtualFiles() {
        return Collections.EMPTY_LIST;
    }
}

