/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.configuration.configurators;

import java.io.File;
import java.io.InputStreamReader;
import java.util.Map;
import org.jahia.configuration.configurators.AbstractXMLConfigurator;
import org.jahia.configuration.configurators.ConfigFile;
import org.jahia.configuration.configurators.JahiaConfigInterface;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.xpath.XPath;

public class TomcatContextXmlConfigurator
extends AbstractXMLConfigurator {
    public TomcatContextXmlConfigurator(Map dbProperties, JahiaConfigInterface jahiaConfigInterface) {
        super(dbProperties, jahiaConfigInterface);
    }

    @Override
    public void updateConfiguration(ConfigFile sourceConfigFile, String destFileName) throws Exception {
        try {
            SAXBuilder saxBuilder = new SAXBuilder();
            saxBuilder.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            InputStreamReader fileReader = new InputStreamReader(sourceConfigFile.getInputStream());
            Document jdomDocument = saxBuilder.build(fileReader);
            Element root = jdomDocument.getRootElement();
            this.setElementAttribute(root, "/Context/Resource", "password", TomcatContextXmlConfigurator.getValue(this.dbProperties, "jahia.database.pass"));
            Element resource = (Element)XPath.newInstance("/Context/Resource").selectSingleNode(root);
            if (resource.getAttributeValue("username") != null) {
                resource.setAttribute("username", TomcatContextXmlConfigurator.getValue(this.dbProperties, "jahia.database.user"));
            }
            if (resource.getAttributeValue("user") != null) {
                resource.setAttribute("user", TomcatContextXmlConfigurator.getValue(this.dbProperties, "jahia.database.user"));
            }
            if (resource.getAttributeValue("url") != null) {
                resource.setAttribute("url", TomcatContextXmlConfigurator.getValue(this.dbProperties, "jahia.database.url"));
            }
            if (resource.getAttributeValue("jdbcUrl") != null) {
                resource.setAttribute("jdbcUrl", TomcatContextXmlConfigurator.getValue(this.dbProperties, "jahia.database.url"));
            }
            if (resource.getAttributeValue("driverClassName") != null) {
                resource.setAttribute("driverClassName", TomcatContextXmlConfigurator.getValue(this.dbProperties, "jahia.database.driver"));
            }
            if (resource.getAttributeValue("driverClass") != null) {
                resource.setAttribute("driverClass", TomcatContextXmlConfigurator.getValue(this.dbProperties, "jahia.database.driver"));
            }
            if (resource.getAttributeValue("validationQuery") != null) {
                resource.setAttribute("validationQuery", TomcatContextXmlConfigurator.getValue(this.dbProperties, "jahia.database.validationQuery"));
            }
            this.write(jdomDocument, new File(destFileName));
        }
        catch (JDOMException jdome) {
            throw new Exception("Error while updating configuration file " + sourceConfigFile, jdome);
        }
    }
}

