/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.configuration.deployers.jboss;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;

final class DriverDeploymentHelper {
    private static final Map<String, String> DBMS_TYPES = new HashMap<String, String>();
    private static final String FILE_CONTENT_ENCODING = "ISO-8859-1";

    public static boolean deploy(File targetServerDirectory, File driverJar) throws IOException {
        File moduleXml;
        String driverKey = DriverDeploymentHelper.getDriverKey(driverJar.getName());
        String driverType = DriverDeploymentHelper.getDriverType(driverKey, driverJar.getName());
        File targetDir = new File(targetServerDirectory, "/modules/org/jahia/jdbc/" + driverType + "/main");
        boolean inPlace = targetDir.equals(driverJar.getParentFile());
        if (targetDir.isDirectory()) {
            if (!"oracle".equals(driverType) && !inPlace) {
                FileUtils.cleanDirectory(targetDir);
            }
        } else if (!targetDir.mkdirs()) {
            throw new IOException("Unable to create target directory: " + targetDir);
        }
        if (!inPlace) {
            FileUtils.copyFileToDirectory(driverJar, targetDir);
        }
        String existingContent = (moduleXml = new File(targetDir, "module.xml")).isFile() ? FileUtils.readFileToString(moduleXml, FILE_CONTENT_ENCODING) : null;
        FileUtils.writeStringToFile(moduleXml, DriverDeploymentHelper.generateModuleXmlContent(existingContent, driverJar.getName(), driverType), FILE_CONTENT_ENCODING);
        return Boolean.TRUE;
    }

    private static String generateModuleXmlContent(String existingContent, String driverJarFileName, String driverType) {
        StringBuilder xml = null;
        if (existingContent != null) {
            xml = new StringBuilder(existingContent.length() + 128);
            int pos = existingContent.indexOf(62, existingContent.indexOf(".jar\""));
            xml.append(existingContent.substring(0, pos + 1));
            xml.append("\n").append("        <resource-root path=\"").append(driverJarFileName).append("\"/>\n");
            xml.append(existingContent.substring(pos + 2, existingContent.length()));
        } else {
            xml = new StringBuilder(256);
            xml.append("<?xml version=\"1.0\" ?>\n");
            xml.append("\n");
            xml.append("<module xmlns=\"urn:jboss:module:1.1\" name=\"org.jahia.jdbc.").append(driverType).append("\">\n");
            xml.append("    <resources>\n");
            xml.append("        <resource-root path=\"").append(driverJarFileName).append("\"/>\n");
            xml.append("    </resources>\n");
            xml.append("\n");
            xml.append("    <dependencies>\n");
            xml.append("        <module name=\"javax.api\"/>\n");
            xml.append("        <module name=\"javax.transaction.api\"/>\n");
            xml.append("    </dependencies>\n");
            xml.append("</module>\n");
        }
        return xml.toString();
    }

    private static String getDriverKey(String fileName) {
        int pos = fileName.indexOf(45);
        if (pos == -1) {
            throw new IllegalArgumentException("Unsupported driver JAR file: " + fileName);
        }
        return fileName.substring(0, pos);
    }

    private static String getDriverType(String driverKey, String fileName) {
        String type = DBMS_TYPES.get(driverKey);
        if (type == null) {
            throw new IllegalArgumentException("Unknown driver JAR file: " + fileName);
        }
        return type;
    }

    private DriverDeploymentHelper() {
    }

    static {
        DBMS_TYPES.put("derby", "derby_embedded");
        DBMS_TYPES.put("derbyclient", "derby");
        DBMS_TYPES.put("mariadb", "mariadb");
        DBMS_TYPES.put("mysql", "mysql");
        DBMS_TYPES.put("ojdbc6", "oracle");
        DBMS_TYPES.put("ojdbc7", "oracle");
        DBMS_TYPES.put("ojdbc8", "oracle");
        DBMS_TYPES.put("orai18n", "oracle");
        DBMS_TYPES.put("postgresql", "postgresql");
        DBMS_TYPES.put("sqljdbc4", "mssql");
        DBMS_TYPES.put("sqljdbc41", "mssql");
        DBMS_TYPES.put("mssql", "mssql");
    }
}

