/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.concurrent.locks.ReentrantLock;
import org.mariadb.jdbc.BaseCallableStatement;
import org.mariadb.jdbc.Connection;
import org.mariadb.jdbc.client.util.Parameter;
import org.mariadb.jdbc.util.ParameterList;

public class FunctionStatement
extends BaseCallableStatement
implements CallableStatement {
    public FunctionStatement(Connection con, String databaseName, String procedureName, String arguments, ReentrantLock lock, boolean canUseServerTimeout, boolean canUseServerMaxRows, int resultSetType, int resultSetConcurrency) throws SQLException {
        super("SELECT " + procedureName + arguments, con, lock, databaseName, procedureName, canUseServerTimeout, canUseServerMaxRows, resultSetType, resultSetConcurrency, 0);
        this.registerOutParameter(1, null);
    }

    @Override
    public boolean isFunction() {
        return true;
    }

    @Override
    protected void handleParameterOutput() throws SQLException {
        this.outputResultFromRes(1);
    }

    @Override
    public void registerOutParameter(int index, int sqlType) throws SQLException {
        if (index != 1) {
            throw this.con.getExceptionFactory().of(this).create(String.format("wrong parameter index %s", index));
        }
        super.registerOutParameter(index, sqlType);
    }

    @Override
    protected void executeInternal() throws SQLException {
        this.preValidParameters();
        super.executeInternal();
    }

    protected void preValidParameters() throws SQLException {
        ParameterList newParameters = new ParameterList(this.parameters.size() - 1);
        for (int i2 = 0; i2 < this.parameters.size() - 1; ++i2) {
            newParameters.set(i2, this.parameters.get(i2 + 1));
        }
        this.parameters = newParameters;
        super.validParameters();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("FunctionStatement{sql:'" + this.sql + "'");
        sb.append(", parameters:[");
        for (int i2 = 0; i2 < this.parameters.size(); ++i2) {
            Parameter param = this.parameters.get(i2);
            if (this.outputParameters.contains(i2 + 1)) {
                sb.append("<OUT>");
            }
            if (param == null) {
                sb.append("null");
            } else {
                sb.append(param.bestEffortStringValue(this.con.getContext()));
            }
            if (i2 == this.parameters.size() - 1) continue;
            sb.append(",");
        }
        sb.append("]}");
        return sb.toString();
    }
}

