/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.client.result;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantLock;
import org.mariadb.jdbc.Statement;
import org.mariadb.jdbc.client.Column;
import org.mariadb.jdbc.client.Context;
import org.mariadb.jdbc.client.DataType;
import org.mariadb.jdbc.client.result.Result;
import org.mariadb.jdbc.client.socket.Reader;
import org.mariadb.jdbc.message.server.ColumnDefinitionPacket;

public class CompleteResult
extends Result {
    protected static final int BEFORE_FIRST_POS = -1;

    public CompleteResult(Statement stmt, boolean binaryProtocol, long maxRows, Column[] metadataList, Reader reader, Context context, int resultSetType, boolean closeOnCompletion, boolean traceEnable) throws IOException, SQLException {
        super(stmt, binaryProtocol, maxRows, metadataList, reader, context, resultSetType, closeOnCompletion, traceEnable);
        this.data = new byte[10][];
        if (maxRows > 0L) {
            while (this.readNext() && (long)this.dataSize < maxRows) {
            }
            if (!this.loaded) {
                this.skipRemaining();
            }
        } else {
            while (this.readNext()) {
            }
        }
        this.loaded = true;
    }

    public CompleteResult(ColumnDefinitionPacket[] metadataList, byte[][] data, Context context) {
        super(metadataList, data, context);
    }

    public static ResultSet createResultSet(String columnName, DataType columnType, String[][] data, Context context, int flags) {
        return CompleteResult.createResultSet(new String[]{columnName}, new DataType[]{columnType}, data, context, flags);
    }

    public static ResultSet createResultSet(String[] columnNames, DataType[] columnTypes, String[][] data, Context context, int flags) {
        int columnNameLength = columnNames.length;
        ColumnDefinitionPacket[] columns = new ColumnDefinitionPacket[columnNameLength];
        for (int i2 = 0; i2 < columnNameLength; ++i2) {
            columns[i2] = ColumnDefinitionPacket.create(columnNames[i2], columnTypes[i2], flags);
        }
        ArrayList<byte[]> rows = new ArrayList<byte[]>();
        for (String[] rowData : data) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            for (String rowDatum : rowData) {
                if (rowDatum != null) {
                    byte[] bb = rowDatum.getBytes();
                    int len = bb.length;
                    if (len < 251) {
                        baos.write((byte)len);
                    } else {
                        baos.write(-4);
                        baos.write((byte)len);
                        baos.write((byte)(len >>> 8));
                    }
                    baos.write(bb, 0, bb.length);
                    continue;
                }
                baos.write(-5);
            }
            byte[] bb = baos.toByteArray();
            rows.add(bb);
        }
        return new CompleteResult(columns, (byte[][])rows.toArray((T[])new byte[0][0]), context);
    }

    @Override
    public boolean next() throws SQLException {
        if (this.rowPointer < this.dataSize - 1) {
            this.row.setRow(this.data[++this.rowPointer]);
            return true;
        }
        this.row.setRow(null);
        this.rowPointer = this.dataSize;
        return false;
    }

    @Override
    public boolean streaming() {
        return false;
    }

    @Override
    public void fetchRemaining() {
    }

    @Override
    public void closeFromStmtClose(ReentrantLock lock) {
        this.closed = true;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkClose();
        if (this.rowPointer < this.dataSize) {
            return false;
        }
        return this.dataSize > 0;
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkClose();
        return this.rowPointer == 0 && this.dataSize > 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.checkClose();
        return this.rowPointer == this.dataSize - 1 && this.dataSize > 0;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.checkClose();
        this.rowPointer = -1;
        this.row.setRow(null);
    }

    @Override
    public void afterLast() throws SQLException {
        this.checkClose();
        this.row.setRow(null);
        this.rowPointer = this.dataSize;
    }

    @Override
    public boolean first() throws SQLException {
        this.checkClose();
        this.rowPointer = 0;
        if (this.dataSize == 0) {
            this.row.setRow(null);
            return false;
        }
        this.row.setRow(this.data[this.rowPointer]);
        return true;
    }

    @Override
    public boolean last() throws SQLException {
        this.checkClose();
        this.rowPointer = this.dataSize - 1;
        if (this.rowPointer == -1) {
            this.row.setRow(null);
            return false;
        }
        this.row.setRow(this.data[this.rowPointer]);
        return true;
    }

    @Override
    public int getRow() throws SQLException {
        this.checkClose();
        return this.rowPointer == this.dataSize ? 0 : this.rowPointer + 1;
    }

    @Override
    public boolean absolute(int idx) throws SQLException {
        this.checkClose();
        if (idx == 0 || idx > this.dataSize) {
            this.rowPointer = idx == 0 ? -1 : this.dataSize;
            this.row.setRow(null);
            return false;
        }
        if (idx > 0) {
            this.rowPointer = idx - 1;
            this.row.setRow(this.data[this.rowPointer]);
            return true;
        }
        if (this.dataSize + idx >= 0) {
            this.rowPointer = this.dataSize + idx;
            this.row.setRow(this.data[this.rowPointer]);
            return true;
        }
        this.rowPointer = -1;
        this.row.setRow(null);
        return false;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.checkClose();
        int newPos = this.rowPointer + rows;
        if (newPos <= -1) {
            this.rowPointer = -1;
            this.row.setRow(null);
            return false;
        }
        if (newPos >= this.dataSize) {
            this.rowPointer = this.dataSize;
            this.row.setRow(null);
            return false;
        }
        this.rowPointer = newPos;
        this.row.setRow(this.data[this.rowPointer]);
        return true;
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkClose();
        if (this.rowPointer > -1) {
            --this.rowPointer;
            if (this.rowPointer != -1) {
                this.row.setRow(this.data[this.rowPointer]);
                return true;
            }
        }
        this.row.setRow(null);
        return false;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkClose();
        return 0;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkClose();
    }
}

