/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.message;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import org.mariadb.jdbc.BasePreparedStatement;
import org.mariadb.jdbc.Statement;
import org.mariadb.jdbc.client.Column;
import org.mariadb.jdbc.client.Completion;
import org.mariadb.jdbc.client.Context;
import org.mariadb.jdbc.client.ReadableByteBuf;
import org.mariadb.jdbc.client.result.CompleteResult;
import org.mariadb.jdbc.client.result.StreamingResult;
import org.mariadb.jdbc.client.result.UpdatableResult;
import org.mariadb.jdbc.client.socket.Reader;
import org.mariadb.jdbc.client.socket.Writer;
import org.mariadb.jdbc.client.util.Parameters;
import org.mariadb.jdbc.export.ExceptionFactory;
import org.mariadb.jdbc.message.server.ColumnDefinitionPacket;
import org.mariadb.jdbc.message.server.ErrorPacket;
import org.mariadb.jdbc.message.server.OkPacket;

public interface ClientMessage {
    public int encode(Writer var1, Context var2) throws IOException, SQLException;

    default public int batchUpdateLength() {
        return 0;
    }

    default public String description() {
        return null;
    }

    default public boolean binaryProtocol() {
        return false;
    }

    default public boolean canSkipMeta() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public Completion readPacket(Statement stmt, int fetchSize, long maxRows, int resultSetConcurrency, int resultSetType, boolean closeOnCompletion, Reader reader, Writer writer, Context context, ExceptionFactory exceptionFactory, ReentrantLock lock, boolean traceEnable, ClientMessage message) throws IOException, SQLException {
        Column[] ci;
        boolean skipMeta;
        boolean canSkipMeta;
        ReadableByteBuf buf = reader.readPacket(true, traceEnable);
        switch (buf.getUnsignedByte()) {
            case 0: {
                return new OkPacket(buf, context);
            }
            case 255: {
                ErrorPacket errorPacket = new ErrorPacket(buf, context);
                throw exceptionFactory.withSql(this.description()).create(errorPacket.getMessage(), errorPacket.getSqlState(), errorPacket.getErrorCode());
            }
            case 251: {
                buf.skip(1);
                SQLException exception = null;
                InputStream is = this.getLocalInfileInputStream();
                if (is == null) {
                    String fileName = buf.readStringNullEnd();
                    if (!message.validateLocalFileName(fileName, context)) {
                        exception = exceptionFactory.withSql(this.description()).create(String.format("LOAD DATA LOCAL INFILE asked for file '%s' that doesn't correspond to initial query %s. Possible malicious proxy changing server answer ! Command interrupted", fileName, this.description()), "HY000");
                    } else {
                        try {
                            is = new FileInputStream(fileName);
                        }
                        catch (FileNotFoundException f2) {
                            exception = exceptionFactory.withSql(this.description()).create("Could not send file : " + f2.getMessage(), "HY000", f2);
                        }
                    }
                }
                if (is != null) {
                    try {
                        int len;
                        byte[] fileBuf = new byte[8192];
                        while ((len = is.read(fileBuf)) > 0) {
                            writer.writeBytes(fileBuf, 0, len);
                            writer.flush();
                        }
                    }
                    finally {
                        is.close();
                    }
                }
                writer.writeEmptyPacket();
                Completion completion = this.readPacket(stmt, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion, reader, writer, context, exceptionFactory, lock, traceEnable, message);
                if (exception != null) {
                    throw exception;
                }
                return completion;
            }
        }
        int fieldCount = buf.readIntLengthEncodedNotNull();
        boolean bl = canSkipMeta = context.canSkipMeta() && this.canSkipMeta();
        boolean bl2 = canSkipMeta ? buf.readByte() == 0 : (skipMeta = false);
        if (canSkipMeta && skipMeta) {
            ci = ((BasePreparedStatement)stmt).getMeta();
        } else {
            ci = new Column[fieldCount];
            for (int i2 = 0; i2 < fieldCount; ++i2) {
                ci[i2] = new ColumnDefinitionPacket(reader.readPacket(false, traceEnable), context.isExtendedInfo());
            }
        }
        if (canSkipMeta && !skipMeta) {
            ((BasePreparedStatement)stmt).updateMeta(ci);
        }
        if (!context.isEofDeprecated()) {
            reader.readPacket(true, traceEnable);
        }
        if (resultSetConcurrency == 1008) {
            return new UpdatableResult(stmt, this.binaryProtocol(), maxRows, ci, reader, context, resultSetType, closeOnCompletion, traceEnable);
        }
        if (fetchSize != 0) {
            if ((context.getServerStatus() & 8) > 0) {
                context.setServerStatus(context.getServerStatus() - 8);
            }
            return new StreamingResult(stmt, this.binaryProtocol(), maxRows, ci, reader, context, fetchSize, lock, resultSetType, closeOnCompletion, traceEnable);
        }
        return new CompleteResult(stmt, this.binaryProtocol(), maxRows, ci, reader, context, resultSetType, closeOnCompletion, traceEnable);
    }

    default public InputStream getLocalInfileInputStream() {
        return null;
    }

    default public boolean validateLocalFileName(String fileName, Context context) {
        return false;
    }

    public static boolean validateLocalFileName(String sql, Parameters parameters, String fileName, Context context) {
        Pattern pattern = Pattern.compile("^(\\s*\\/\\*([^\\*]|\\*[^\\/])*\\*\\/)*\\s*LOAD\\s+(DATA|XML)\\s+((LOW_PRIORITY|CONCURRENT)\\s+)?LOCAL\\s+INFILE\\s+'" + fileName + "'", 2);
        if (pattern.matcher(sql).find()) {
            return true;
        }
        if (parameters != null && (pattern = Pattern.compile("^(\\s*\\/\\*([^\\*]|\\*[^\\/])*\\*\\/)*\\s*LOAD\\s+(DATA|XML)\\s+((LOW_PRIORITY|CONCURRENT)\\s+)?LOCAL\\s+INFILE\\s+\\?", 2)).matcher(sql).find() && parameters.size() > 0) {
            String paramString = parameters.get(0).bestEffortStringValue(context);
            if (paramString != null) {
                return paramString.toLowerCase().equals("'" + fileName.toLowerCase() + "'");
            }
            return true;
        }
        return false;
    }
}

