/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.message.server;

import java.io.IOException;
import java.sql.SQLException;
import org.mariadb.jdbc.ServerPreparedStatement;
import org.mariadb.jdbc.client.Client;
import org.mariadb.jdbc.client.Column;
import org.mariadb.jdbc.client.Completion;
import org.mariadb.jdbc.client.Context;
import org.mariadb.jdbc.client.ReadableByteBuf;
import org.mariadb.jdbc.client.socket.Reader;
import org.mariadb.jdbc.export.Prepare;
import org.mariadb.jdbc.message.server.ColumnDefinitionPacket;
import org.mariadb.jdbc.util.log.Logger;
import org.mariadb.jdbc.util.log.Loggers;

public class PrepareResultPacket
implements Completion,
Prepare {
    private static final Logger logger = Loggers.getLogger(PrepareResultPacket.class);
    private final Column[] parameters;
    private Column[] columns;
    protected int statementId;

    public PrepareResultPacket(ReadableByteBuf buffer, Reader reader, Context context) throws IOException {
        int i2;
        boolean trace = logger.isTraceEnabled();
        buffer.readByte();
        this.statementId = buffer.readInt();
        int numColumns = buffer.readUnsignedShort();
        int numParams = buffer.readUnsignedShort();
        this.parameters = new Column[numParams];
        this.columns = new Column[numColumns];
        if (numParams > 0) {
            for (i2 = 0; i2 < numParams; ++i2) {
                this.parameters[i2] = new ColumnDefinitionPacket(reader.readPacket(false, trace), context.hasClientCapability(0x800000000L));
            }
            if (!context.isEofDeprecated()) {
                reader.readPacket(true, trace);
            }
        }
        if (numColumns > 0) {
            for (i2 = 0; i2 < numColumns; ++i2) {
                this.columns[i2] = new ColumnDefinitionPacket(reader.readPacket(false, trace), context.hasClientCapability(0x800000000L));
            }
            if (!context.isEofDeprecated()) {
                reader.readPacket(true, trace);
            }
        }
    }

    @Override
    public void close(Client con) throws SQLException {
        con.closePrepare(this);
    }

    @Override
    public void decrementUse(Client con, ServerPreparedStatement preparedStatement) throws SQLException {
        this.close(con);
    }

    @Override
    public int getStatementId() {
        return this.statementId;
    }

    @Override
    public Column[] getParameters() {
        return this.parameters;
    }

    @Override
    public Column[] getColumns() {
        return this.columns;
    }

    @Override
    public void setColumns(Column[] columns) {
        this.columns = columns;
    }
}

