/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.plugin.codec;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLDataException;
import java.util.Calendar;
import java.util.EnumSet;
import org.mariadb.jdbc.client.Column;
import org.mariadb.jdbc.client.Context;
import org.mariadb.jdbc.client.DataType;
import org.mariadb.jdbc.client.ReadableByteBuf;
import org.mariadb.jdbc.client.socket.Writer;
import org.mariadb.jdbc.plugin.Codec;

public class FloatCodec
implements Codec<Float> {
    public static final FloatCodec INSTANCE = new FloatCodec();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.TINYINT, new DataType[]{DataType.SMALLINT, DataType.MEDIUMINT, DataType.INTEGER, DataType.FLOAT, DataType.BIGINT, DataType.OLDDECIMAL, DataType.DECIMAL, DataType.YEAR, DataType.DOUBLE, DataType.VARCHAR, DataType.VARSTRING, DataType.STRING, DataType.BLOB, DataType.TINYBLOB, DataType.MEDIUMBLOB, DataType.LONGBLOB});

    @Override
    public String className() {
        return Float.class.getName();
    }

    @Override
    public boolean canDecode(Column column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getType()) && (type.isPrimitive() && type == Float.TYPE || type.isAssignableFrom(Float.class));
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Float;
    }

    @Override
    public Float decodeText(ReadableByteBuf buffer, int length, Column column, Calendar cal) throws SQLDataException {
        return Float.valueOf(this.decodeTextFloat(buffer, length, column));
    }

    public float decodeTextFloat(ReadableByteBuf buf, int length, Column column) throws SQLDataException {
        switch (column.getType()) {
            case TINYINT: 
            case SMALLINT: 
            case MEDIUMINT: 
            case INTEGER: 
            case BIGINT: 
            case DOUBLE: 
            case OLDDECIMAL: 
            case DECIMAL: 
            case FLOAT: 
            case YEAR: {
                return Float.parseFloat(buf.readAscii(length));
            }
            case BLOB: 
            case TINYBLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: {
                if (column.isBinary()) {
                    buf.skip(length);
                    throw new SQLDataException(String.format("Data type %s cannot be decoded as Float", new Object[]{column.getType()}));
                }
            }
            case VARCHAR: 
            case VARSTRING: 
            case STRING: {
                String val = buf.readString(length);
                try {
                    return Float.parseFloat(val);
                }
                catch (NumberFormatException nfe) {
                    throw new SQLDataException(String.format("value '%s' cannot be decoded as Float", val));
                }
            }
        }
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Float", new Object[]{column.getType()}));
    }

    @Override
    public Float decodeBinary(ReadableByteBuf buffer, int length, Column column, Calendar cal) throws SQLDataException {
        return Float.valueOf(this.decodeBinaryFloat(buffer, length, column));
    }

    public float decodeBinaryFloat(ReadableByteBuf buf, int length, Column column) throws SQLDataException {
        switch (column.getType()) {
            case TINYINT: {
                if (!column.isSigned()) {
                    return buf.readUnsignedByte();
                }
                return buf.readByte();
            }
            case SMALLINT: 
            case YEAR: {
                if (!column.isSigned()) {
                    return buf.readUnsignedShort();
                }
                return buf.readShort();
            }
            case MEDIUMINT: {
                float f2 = column.isSigned() ? (float)buf.readMedium() : (float)buf.readUnsignedMedium();
                buf.skip();
                return f2;
            }
            case INTEGER: {
                if (!column.isSigned()) {
                    return buf.readUnsignedInt();
                }
                return buf.readInt();
            }
            case BIGINT: {
                if (column.isSigned()) {
                    return buf.readLong();
                }
                byte[] bb = new byte[8];
                for (int i2 = 7; i2 >= 0; --i2) {
                    bb[i2] = buf.readByte();
                }
                return new BigInteger(1, bb).floatValue();
            }
            case FLOAT: {
                return buf.readFloat();
            }
            case DOUBLE: {
                return (float)buf.readDouble();
            }
            case OLDDECIMAL: 
            case DECIMAL: {
                return new BigDecimal(buf.readAscii(length)).floatValue();
            }
            case BLOB: 
            case TINYBLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: {
                if (column.isBinary()) {
                    buf.skip(length);
                    throw new SQLDataException(String.format("Data type %s cannot be decoded as Float", new Object[]{column.getType()}));
                }
            }
            case VARCHAR: 
            case VARSTRING: 
            case STRING: {
                String str2 = buf.readString(length);
                try {
                    return Float.parseFloat(str2);
                }
                catch (NumberFormatException nfe) {
                    throw new SQLDataException(String.format("value '%s' cannot be decoded as Float", str2));
                }
            }
        }
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Float", new Object[]{column.getType()}));
    }

    @Override
    public void encodeText(Writer encoder, Context context, Object value, Calendar cal, Long maxLen) throws IOException {
        encoder.writeAscii(value.toString());
    }

    @Override
    public void encodeBinary(Writer encoder, Object value, Calendar cal, Long maxLength) throws IOException {
        encoder.writeFloat(((Float)value).floatValue());
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.FLOAT.get();
    }
}

