/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.type;

import java.util.Arrays;
import org.mariadb.jdbc.type.Geometry;
import org.mariadb.jdbc.type.LineString;
import org.mariadb.jdbc.type.Point;

public class Polygon
implements Geometry {
    private final LineString[] lines;

    public Polygon(LineString[] lines) {
        this.lines = lines;
    }

    public LineString[] getLines() {
        return this.lines;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("POLYGON(");
        int indexLine = 0;
        for (LineString ls : this.lines) {
            if (indexLine++ > 0) {
                sb.append(",");
            }
            sb.append("(");
            int index = 0;
            for (Point pt : ls.getPoints()) {
                if (index++ > 0) {
                    sb.append(",");
                }
                sb.append(pt.getX()).append(" ").append(pt.getY());
            }
            sb.append(")");
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || !(o2 instanceof Polygon)) {
            return false;
        }
        return this.toString().equals(o2.toString());
    }

    public int hashCode() {
        return Arrays.hashCode(this.lines);
    }
}

