/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz;

import java.io.InputStream;
import org.tukaani.xz.ArrayCache;
import org.tukaani.xz.DeltaEncoder;
import org.tukaani.xz.DeltaInputStream;
import org.tukaani.xz.DeltaOutputStream;
import org.tukaani.xz.FilterEncoder;
import org.tukaani.xz.FilterOptions;
import org.tukaani.xz.FinishableOutputStream;
import org.tukaani.xz.UnsupportedOptionsException;

public class DeltaOptions
extends FilterOptions {
    public static final int DISTANCE_MIN = 1;
    public static final int DISTANCE_MAX = 256;
    private int distance = 1;

    public DeltaOptions() {
    }

    public DeltaOptions(int n2) throws UnsupportedOptionsException {
        this.setDistance(n2);
    }

    public void setDistance(int n2) throws UnsupportedOptionsException {
        if (n2 < 1 || n2 > 256) {
            throw new UnsupportedOptionsException("Delta distance must be in the range [1, 256]: " + n2);
        }
        this.distance = n2;
    }

    public int getDistance() {
        return this.distance;
    }

    @Override
    public int getEncoderMemoryUsage() {
        return DeltaOutputStream.getMemoryUsage();
    }

    @Override
    public FinishableOutputStream getOutputStream(FinishableOutputStream finishableOutputStream, ArrayCache arrayCache) {
        return new DeltaOutputStream(finishableOutputStream, this);
    }

    @Override
    public int getDecoderMemoryUsage() {
        return 1;
    }

    @Override
    public InputStream getInputStream(InputStream inputStream, ArrayCache arrayCache) {
        return new DeltaInputStream(inputStream, this.distance);
    }

    @Override
    FilterEncoder getFilterEncoder() {
        return new DeltaEncoder(this);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            assert (false);
            throw new RuntimeException();
        }
    }
}

