/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz;

import java.io.IOException;
import java.io.OutputStream;
import org.tukaani.xz.ArrayCache;
import org.tukaani.xz.FinishableOutputStream;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.UnsupportedOptionsException;
import org.tukaani.xz.XZIOException;
import org.tukaani.xz.lz.LZEncoder;
import org.tukaani.xz.lzma.LZMAEncoder;
import org.tukaani.xz.rangecoder.RangeEncoderToStream;

public class LZMAOutputStream
extends FinishableOutputStream {
    private OutputStream out;
    private final ArrayCache arrayCache;
    private LZEncoder lz;
    private final RangeEncoderToStream rc;
    private LZMAEncoder lzma;
    private final int props;
    private final boolean useEndMarker;
    private final long expectedUncompressedSize;
    private long currentUncompressedSize = 0L;
    private boolean finished = false;
    private IOException exception = null;
    private final byte[] tempBuf = new byte[1];

    private LZMAOutputStream(OutputStream outputStream, LZMA2Options lZMA2Options, boolean bl, boolean bl2, long l2, ArrayCache arrayCache) throws IOException {
        if (outputStream == null) {
            throw new NullPointerException();
        }
        if (l2 < -1L) {
            throw new IllegalArgumentException("Invalid expected input size (less than -1)");
        }
        this.useEndMarker = bl2;
        this.expectedUncompressedSize = l2;
        this.arrayCache = arrayCache;
        this.out = outputStream;
        this.rc = new RangeEncoderToStream(outputStream);
        int n2 = lZMA2Options.getDictSize();
        this.lzma = LZMAEncoder.getInstance(this.rc, lZMA2Options.getLc(), lZMA2Options.getLp(), lZMA2Options.getPb(), lZMA2Options.getMode(), n2, 0, lZMA2Options.getNiceLen(), lZMA2Options.getMatchFinder(), lZMA2Options.getDepthLimit(), arrayCache);
        this.lz = this.lzma.getLZEncoder();
        byte[] byArray = lZMA2Options.getPresetDict();
        if (byArray != null && byArray.length > 0) {
            if (bl) {
                throw new UnsupportedOptionsException("Preset dictionary cannot be used in .lzma files (try a raw LZMA stream instead)");
            }
            this.lz.setPresetDict(n2, byArray);
        }
        this.props = (lZMA2Options.getPb() * 5 + lZMA2Options.getLp()) * 9 + lZMA2Options.getLc();
        if (bl) {
            int n3;
            outputStream.write(this.props);
            for (n3 = 0; n3 < 4; ++n3) {
                outputStream.write(n2 & 0xFF);
                n2 >>>= 8;
            }
            for (n3 = 0; n3 < 8; ++n3) {
                outputStream.write((int)(l2 >>> 8 * n3) & 0xFF);
            }
        }
    }

    public LZMAOutputStream(OutputStream outputStream, LZMA2Options lZMA2Options, long l2) throws IOException {
        this(outputStream, lZMA2Options, l2, ArrayCache.getDefaultCache());
    }

    public LZMAOutputStream(OutputStream outputStream, LZMA2Options lZMA2Options, long l2, ArrayCache arrayCache) throws IOException {
        this(outputStream, lZMA2Options, true, l2 == -1L, l2, arrayCache);
    }

    public LZMAOutputStream(OutputStream outputStream, LZMA2Options lZMA2Options, boolean bl) throws IOException {
        this(outputStream, lZMA2Options, bl, ArrayCache.getDefaultCache());
    }

    public LZMAOutputStream(OutputStream outputStream, LZMA2Options lZMA2Options, boolean bl, ArrayCache arrayCache) throws IOException {
        this(outputStream, lZMA2Options, false, bl, -1L, arrayCache);
    }

    public int getProps() {
        return this.props;
    }

    public long getUncompressedSize() {
        return this.currentUncompressedSize;
    }

    @Override
    public void write(int n2) throws IOException {
        this.tempBuf[0] = (byte)n2;
        this.write(this.tempBuf, 0, 1);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        if (n2 < 0 || n3 < 0 || n2 + n3 < 0 || n2 + n3 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.finished) {
            throw new XZIOException("Stream finished or closed");
        }
        if (this.expectedUncompressedSize != -1L && this.expectedUncompressedSize - this.currentUncompressedSize < (long)n3) {
            throw new XZIOException("Expected uncompressed input size (" + this.expectedUncompressedSize + " bytes) was exceeded");
        }
        this.currentUncompressedSize += (long)n3;
        try {
            while (n3 > 0) {
                int n4 = this.lz.fillWindow(byArray, n2, n3);
                n2 += n4;
                n3 -= n4;
                this.lzma.encodeForLZMA1();
            }
        }
        catch (IOException iOException) {
            this.exception = iOException;
            throw iOException;
        }
    }

    @Override
    public void flush() throws IOException {
        throw new XZIOException("LZMAOutputStream does not support flushing");
    }

    @Override
    public void finish() throws IOException {
        if (!this.finished) {
            if (this.exception != null) {
                throw this.exception;
            }
            try {
                if (this.expectedUncompressedSize != -1L && this.expectedUncompressedSize != this.currentUncompressedSize) {
                    throw new XZIOException("Expected uncompressed size (" + this.expectedUncompressedSize + ") doesn't equal the number of bytes written to the stream (" + this.currentUncompressedSize + ")");
                }
                this.lz.setFinishing();
                this.lzma.encodeForLZMA1();
                if (this.useEndMarker) {
                    this.lzma.encodeLZMA1EndMarker();
                }
                this.rc.finish();
            }
            catch (IOException iOException) {
                this.exception = iOException;
                throw iOException;
            }
            this.finished = true;
            this.lzma.putArraysToCache(this.arrayCache);
            this.lzma = null;
            this.lz = null;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.out != null) {
            block6: {
                try {
                    this.finish();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    this.out.close();
                }
                catch (IOException iOException) {
                    if (this.exception != null) break block6;
                    this.exception = iOException;
                }
            }
            this.out = null;
        }
        if (this.exception != null) {
            throw this.exception;
        }
    }
}

